/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model;

import org.apache.fulcrum.security.ModelManager;
import org.apache.fulcrum.security.acl.AccessControlList;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.ACLFactory;
import org.apache.fulcrum.security.model.basic.BasicAccessControlList;
import org.apache.fulcrum.security.model.basic.entity.impl.BasicGroupImpl;
import org.apache.fulcrum.security.model.basic.entity.impl.BasicUserImpl;
import org.apache.fulcrum.security.model.dynamic.DynamicAccessControlList;
import org.apache.fulcrum.security.model.dynamic.entity.impl.DynamicGroupImpl;
import org.apache.fulcrum.security.model.dynamic.entity.impl.DynamicPermissionImpl;
import org.apache.fulcrum.security.model.dynamic.entity.impl.DynamicRoleImpl;
import org.apache.fulcrum.security.model.dynamic.entity.impl.DynamicUserImpl;
import org.apache.fulcrum.security.model.turbine.TurbineAccessControlList;
import org.apache.fulcrum.security.model.turbine.TurbineModelManager;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUserGroupRole;
import org.apache.fulcrum.security.model.turbine.entity.impl.TurbineGroupImpl;
import org.apache.fulcrum.security.model.turbine.entity.impl.TurbinePermissionImpl;
import org.apache.fulcrum.security.model.turbine.entity.impl.TurbineRoleImpl;
import org.apache.fulcrum.security.model.turbine.entity.impl.TurbineUserImpl;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.testcontainer.BaseUnit5Test;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ACLFactoryTest
extends BaseUnit5Test {
    @Test
    public void testCreatingTurbineACLandModel() throws Exception {
        this.setRoleFileName("src/test/TurbineACLRoleModelConfig.xml");
        this.setConfigurationFileName("src/test/ACLModelComponentConfig.xml");
        ACLFactory factory = (ACLFactory)this.lookup(ACLFactory.ROLE);
        TurbineModelManager modelManager = (TurbineModelManager)this.lookup(TurbineModelManager.ROLE);
        Assertions.assertTrue((boolean)modelManager.getGlobalGroupName().equals("dumb"));
        TurbineUserImpl user = new TurbineUserImpl();
        user.setName("bob");
        user.setId((Object)1);
        TurbineGroupImpl group = new TurbineGroupImpl();
        group.setName("group1");
        group.setId((Object)1);
        TurbineRoleImpl role = new TurbineRoleImpl();
        role.setName("role1");
        role.setId((Object)1);
        TurbinePermissionImpl permission = new TurbinePermissionImpl();
        permission.setName("permission1");
        permission.setId((Object)1);
        role.addPermission((Permission)permission);
        TurbineUserGroupRole ugr = new TurbineUserGroupRole();
        ugr.setGroup((Group)group);
        ugr.setRole((Role)role);
        ugr.setUser((User)user);
        user.addUserGroupRole(ugr);
        AccessControlList acl = factory.getAccessControlList((User)user);
        Assertions.assertTrue((boolean)(acl instanceof TurbineAccessControlList));
        TurbineAccessControlList tacl = (TurbineAccessControlList)acl;
        Assertions.assertTrue((boolean)tacl.hasPermission((Permission)permission, (Group)group));
        RoleSet roleSet = tacl.getRoles((Group)group);
        Assertions.assertTrue((boolean)roleSet.contains((Object)role), (String)("expect group " + String.valueOf(group) + " has role " + String.valueOf(role)));
        Assertions.assertNull((Object)tacl.getRoles(), (String)"expect no role in global group");
        Assertions.assertTrue((tacl.getGroupSet().size() > 0 ? 1 : 0) != 0, (String)("expect length for all group set:" + String.valueOf(tacl.getAllGroups())));
    }

    @Test
    public void testCreatingDynamicACL() throws Exception {
        this.setRoleFileName("src/test/DynamicACLRoleConfig.xml");
        this.setConfigurationFileName("src/test/ACLModelComponentConfig.xml");
        ModelManager modelManager = (ModelManager)this.lookup(ModelManager.ROLE);
        Assertions.assertTrue((modelManager != null ? 1 : 0) != 0);
        ACLFactory factory = (ACLFactory)this.lookup(ACLFactory.ROLE);
        DynamicUserImpl user = new DynamicUserImpl();
        user.setName("bob");
        user.setId((Object)1);
        DynamicGroupImpl group = new DynamicGroupImpl();
        group.setName("group1");
        group.setId((Object)1);
        DynamicRoleImpl role = new DynamicRoleImpl();
        role.setName("role1");
        role.setId((Object)1);
        DynamicPermissionImpl permission = new DynamicPermissionImpl();
        permission.setName("permission1");
        permission.setId((Object)1);
        role.addPermission((Permission)permission);
        group.addRole((Role)role);
        user.addGroup((Group)group);
        AccessControlList acl = factory.getAccessControlList((User)user);
        Assertions.assertTrue((boolean)(acl instanceof DynamicAccessControlList));
        DynamicAccessControlList dacl = (DynamicAccessControlList)acl;
        Assertions.assertTrue((boolean)dacl.hasPermission((Permission)permission));
    }

    @Test
    public void testCreatingBasicACL() throws Exception {
        this.setRoleFileName("src/test/BasicACLRoleConfig.xml");
        this.setConfigurationFileName("src/test/ACLModelComponentConfig.xml");
        ACLFactory factory = (ACLFactory)this.lookup(ACLFactory.ROLE);
        BasicUserImpl user = new BasicUserImpl();
        user.setName("bob");
        user.setId((Object)1);
        BasicGroupImpl group = new BasicGroupImpl();
        group.setName("group1");
        group.setId((Object)1);
        user.addGroup((Group)group);
        AccessControlList acl = factory.getAccessControlList((User)user);
        Assertions.assertTrue((boolean)(acl instanceof BasicAccessControlList));
        BasicAccessControlList bacl = (BasicAccessControlList)acl;
        Assertions.assertTrue((boolean)bacl.hasGroup((Group)group));
    }
}

