/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.dynamic.test;

import java.util.HashSet;
import org.apache.fulcrum.security.GroupManager;
import org.apache.fulcrum.security.PermissionManager;
import org.apache.fulcrum.security.RoleManager;
import org.apache.fulcrum.security.SecurityService;
import org.apache.fulcrum.security.UserManager;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.dynamic.DynamicAccessControlList;
import org.apache.fulcrum.security.model.dynamic.DynamicModelManager;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicGroup;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicPermission;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicRole;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicUser;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.fulcrum.security.util.UserSet;
import org.apache.fulcrum.testcontainer.BaseUnit5Test;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractDynamicModelManagerTest
extends BaseUnit5Test {
    private static final String ONLY_BORRIS_PERMISSION = "ONLY_BORRIS_PERMISSION";
    private static final String ONLY_BORRIS_GROUP = "ONLY_BORRIS_GROUP";
    private static final String ONLY_BORRIS_ROLE = "ONLY BORRIS ROLE";
    private static final String USERNAME_SAM = "sam1";
    private static final String USERNAME_BORRIS = "borris1";
    protected Role role;
    protected DynamicModelManager modelManager;
    protected RoleManager roleManager;
    protected GroupManager groupManager;
    protected PermissionManager permissionManager;
    protected UserManager userManager;
    protected SecurityService securityService;

    @BeforeEach
    public void setUp() throws Exception {
        this.roleManager = this.securityService.getRoleManager();
        this.userManager = this.securityService.getUserManager();
        this.groupManager = this.securityService.getGroupManager();
        this.permissionManager = this.securityService.getPermissionManager();
        this.modelManager = (DynamicModelManager)this.securityService.getModelManager();
    }

    @AfterEach
    public void tearDown() {
        this.release(this.roleManager);
        this.release(this.userManager);
        this.release(this.groupManager);
        this.release(this.permissionManager);
        this.release(this.modelManager);
    }

    @Test
    public void testGrantRolePermission() throws Exception {
        Permission permission = this.permissionManager.getPermissionInstance();
        permission.setName("ANSWER_PHONE");
        this.permissionManager.addPermission(permission);
        this.role = this.roleManager.getRoleInstance("RECEPTIONIST");
        this.roleManager.addRole(this.role);
        this.modelManager.grant(this.role, permission);
        this.role = this.roleManager.getRoleById(this.role.getId());
        PermissionSet permissions = ((DynamicRole)this.role).getPermissions();
        Assertions.assertEquals((int)1, (int)permissions.size());
        Assertions.assertTrue((boolean)((DynamicRole)this.role).getPermissions().contains((Object)permission));
    }

    @Test
    public void testRevokeRolePermission() throws Exception {
        Permission permission = this.securityService.getPermissionManager().getPermissionInstance();
        permission.setName("ANSWER_FAX");
        this.securityService.getPermissionManager().addPermission(permission);
        this.role = this.roleManager.getRoleInstance("SECRETARY");
        this.roleManager.addRole(this.role);
        this.modelManager.grant(this.role, permission);
        this.role = this.roleManager.getRoleById(this.role.getId());
        PermissionSet permissions = ((DynamicRole)this.role).getPermissions();
        Assertions.assertEquals((int)1, (int)permissions.size());
        this.modelManager.revoke(this.role, permission);
        this.role = this.roleManager.getRoleById(this.role.getId());
        permissions = ((DynamicRole)this.role).getPermissions();
        Assertions.assertEquals((int)0, (int)permissions.size());
        Assertions.assertFalse((boolean)((DynamicRole)this.role).getPermissions().contains((Object)permission));
    }

    @Test
    public void testRevokeAllRole() throws Exception {
        Permission permission = this.securityService.getPermissionManager().getPermissionInstance();
        Permission permission2 = this.securityService.getPermissionManager().getPermissionInstance();
        permission.setName("SEND_SPAM");
        permission2.setName("ANSWER_EMAIL");
        this.securityService.getPermissionManager().addPermission(permission);
        this.securityService.getPermissionManager().addPermission(permission2);
        this.role = this.roleManager.getRoleInstance("HELPER");
        this.roleManager.addRole(this.role);
        this.modelManager.grant(this.role, permission);
        this.modelManager.grant(this.role, permission2);
        this.role = this.roleManager.getRoleById(this.role.getId());
        PermissionSet permissions = ((DynamicRole)this.role).getPermissions();
        Assertions.assertEquals((int)2, (int)permissions.size());
        this.modelManager.revokeAll(this.role);
        this.role = this.roleManager.getRoleById(this.role.getId());
        permissions = ((DynamicRole)this.role).getPermissions();
        Assertions.assertEquals((int)0, (int)permissions.size());
    }

    @Test
    public void testRevokeAllGroup() throws Exception {
        Permission permission = this.securityService.getPermissionManager().getPermissionInstance();
        Permission permission2 = this.securityService.getPermissionManager().getPermissionInstance();
        permission.setName("SEND_SPAM2");
        permission2.setName("ANSWER_EMAIL2");
        this.securityService.getPermissionManager().addPermission(permission);
        this.securityService.getPermissionManager().addPermission(permission2);
        this.role = this.roleManager.getRoleInstance("HELPER2");
        this.roleManager.addRole(this.role);
        this.modelManager.grant(this.role, permission);
        this.modelManager.grant(this.role, permission2);
        this.role = this.roleManager.getRoleById(this.role.getId());
        PermissionSet permissions = ((DynamicRole)this.role).getPermissions();
        Assertions.assertEquals((int)2, (int)permissions.size());
        this.modelManager.revokeAll(this.role);
        this.role = this.roleManager.getRoleById(this.role.getId());
        permissions = ((DynamicRole)this.role).getPermissions();
        Assertions.assertEquals((int)0, (int)permissions.size());
    }

    @Test
    public void testRevokeAllUser() throws Exception {
        Group group = this.securityService.getGroupManager().getGroupInstance();
        group.setName("TEST_REVOKEALLUSER_GROUP");
        this.securityService.getGroupManager().addGroup(group);
        Role role = this.securityService.getRoleManager().getRoleInstance();
        role.setName("TEST_REVOKEALLUSER_ROLE");
        this.securityService.getRoleManager().addRole(role);
        User user = this.userManager.getUserInstance("calvin");
        this.userManager.addUser(user, "calvin");
        this.modelManager.grant(user, group);
        this.modelManager.grant(group, role);
        group = this.groupManager.getGroupById(group.getId());
        RoleSet roles = ((DynamicGroup)group).getRoles();
        Assertions.assertEquals((int)1, (int)roles.size());
        UserSet users = ((DynamicGroup)group).getUsers();
        Assertions.assertEquals((int)1, (int)users.size());
        this.modelManager.revokeAll(group);
        Assertions.assertEquals((int)0, (int)((DynamicGroup)group).getUsers().size());
        role = this.securityService.getRoleManager().getRoleByName("TEST_REVOKEALLUSER_ROLE");
        Assertions.assertFalse((boolean)((DynamicRole)role).getGroups().contains((Object)group));
    }

    @Test
    public void testRevokeAllPermission() throws Exception {
        Role role = this.securityService.getRoleManager().getRoleInstance();
        Role role2 = this.securityService.getRoleManager().getRoleInstance();
        role.setName("SEND_SPAM");
        role2.setName("ANSWER_EMAIL");
        this.securityService.getRoleManager().addRole(role);
        this.securityService.getRoleManager().addRole(role2);
        Permission permission = this.permissionManager.getPermissionInstance("HELPER");
        this.permissionManager.addPermission(permission);
        this.modelManager.grant(role, permission);
        this.modelManager.grant(role2, permission);
        permission = this.permissionManager.getPermissionById(permission.getId());
        RoleSet roles = ((DynamicPermission)permission).getRoles();
        Assertions.assertEquals((int)2, (int)roles.size());
        this.modelManager.revokeAll(permission);
        permission = this.permissionManager.getPermissionById(permission.getId());
        roles = ((DynamicPermission)permission).getRoles();
        Assertions.assertEquals((int)0, (int)roles.size());
    }

    @Test
    public void testGrantUserGroup() throws Exception {
        Group group = this.securityService.getGroupManager().getGroupInstance();
        group.setName("TEST_GROUP");
        this.securityService.getGroupManager().addGroup(group);
        User user = this.userManager.getUserInstance("Clint");
        this.userManager.addUser(user, "clint");
        this.modelManager.grant(user, group);
        Assertions.assertTrue((boolean)((DynamicUser)user).getGroups().contains((Object)group));
        Assertions.assertTrue((boolean)((DynamicGroup)group).getUsers().contains((Object)user));
    }

    @Test
    public void testRevokeUserGroup() throws Exception {
        Group group = this.securityService.getGroupManager().getGroupInstance();
        group.setName("TEST_REVOKE");
        this.securityService.getGroupManager().addGroup(group);
        User user = this.userManager.getUserInstance("Lima");
        this.userManager.addUser(user, "pet");
        this.modelManager.revoke(user, group);
        Assertions.assertFalse((boolean)((DynamicUser)user).getGroups().contains((Object)group));
        Assertions.assertFalse((boolean)((DynamicGroup)group).getUsers().contains((Object)user));
        user = this.userManager.getUser("Lima");
        Assertions.assertFalse((boolean)((DynamicUser)user).getGroups().contains((Object)group));
    }

    @Test
    public void testGrantGroupRole() throws Exception {
        Role role = this.securityService.getRoleManager().getRoleInstance();
        role.setName("TEST_PERMISSION");
        this.securityService.getRoleManager().addRole(role);
        Group group = this.groupManager.getGroupInstance("TEST_GROUP2");
        this.groupManager.addGroup(group);
        this.modelManager.grant(group, role);
        group = this.groupManager.getGroupByName("TEST_GROUP2");
        Assertions.assertTrue((boolean)((DynamicGroup)group).getRoles().contains((Object)role));
        Assertions.assertTrue((boolean)((DynamicRole)role).getGroups().contains((Object)group));
    }

    @Test
    public void testRevokeGroupRole() throws Exception {
        Role role = this.securityService.getRoleManager().getRoleInstance();
        role.setName("TEST_PERMISSION2");
        this.securityService.getRoleManager().addRole(role);
        Group group = this.groupManager.getGroupInstance("Lima2");
        this.groupManager.addGroup(group);
        this.modelManager.grant(group, role);
        this.modelManager.revoke(group, role);
        group = this.groupManager.getGroupByName("Lima2");
        Assertions.assertFalse((boolean)((DynamicGroup)group).getRoles().contains((Object)role));
        Assertions.assertFalse((boolean)((DynamicRole)role).getGroups().contains((Object)group));
    }

    @Test
    public void testRetrieveingUsersByGroup() throws Exception {
        User user = this.userManager.getUserInstance("Joe3");
        this.userManager.addUser(user, "mc");
        String GROUP_NAME = "oddbug2";
        Group group = null;
        GroupManager groupManager = this.securityService.getGroupManager();
        try {
            group = groupManager.getGroupByName("");
        }
        catch (UnknownEntityException uue) {
            group = groupManager.getGroupInstance(GROUP_NAME);
            groupManager.addGroup(group);
        }
        Assertions.assertNotNull((Object)group);
        user = null;
        UserManager userManager = this.securityService.getUserManager();
        user = userManager.getUser("joe3");
        ((DynamicModelManager)this.securityService.getModelManager()).grant(user, group);
        Assertions.assertTrue((boolean)((DynamicGroup)group).getUsers().contains((Object)user));
        group = groupManager.getGroupByName(GROUP_NAME);
        UserSet users = ((DynamicGroup)group).getUsers();
        int size = users.size();
        Assertions.assertEquals((int)1, (int)size);
        boolean found = false;
        HashSet<User> newSet = new HashSet<User>();
        for (User u : users) {
            if (!u.equals((Object)user)) continue;
            found = true;
            newSet.add(u);
        }
        Assertions.assertTrue((boolean)found);
        Assertions.assertTrue((boolean)users.contains(user));
    }

    @Test
    public void testAddRemoveDelegate() throws Exception {
        DynamicUser borris = (DynamicUser)this.userManager.getUserInstance(USERNAME_BORRIS);
        this.userManager.addUser((User)borris, "mc");
        DynamicUser sam = (DynamicUser)this.userManager.getUserInstance(USERNAME_SAM);
        this.userManager.addUser((User)sam, "mc");
        this.modelManager.addDelegate((User)borris, (User)sam);
        Assertions.assertTrue((boolean)borris.getDelegatees().contains(sam));
        Assertions.assertTrue((boolean)sam.getDelegators().contains(borris));
        DynamicUser borrisLoaded = (DynamicUser)this.userManager.getUser(USERNAME_BORRIS);
        DynamicUser samLoaded = (DynamicUser)this.userManager.getUser(USERNAME_SAM);
        Assertions.assertTrue((boolean)borrisLoaded.getDelegatees().contains(samLoaded));
        Assertions.assertTrue((boolean)samLoaded.getDelegators().contains(borrisLoaded));
        Group group = this.groupManager.getGroupInstance();
        group.setName(ONLY_BORRIS_GROUP);
        this.groupManager.addGroup(group);
        Role role = this.roleManager.getRoleInstance();
        role.setName(ONLY_BORRIS_ROLE);
        this.roleManager.addRole(role);
        Permission permission = this.permissionManager.getPermissionInstance();
        permission.setName(ONLY_BORRIS_PERMISSION);
        this.permissionManager.addPermission(permission);
        this.modelManager.grant(role, permission);
        this.modelManager.grant(group, role);
        this.modelManager.grant((User)borris, group);
        DynamicAccessControlList acl = (DynamicAccessControlList)this.userManager.getACL((User)sam);
        Assertions.assertTrue((boolean)acl.hasPermission(permission));
        Assertions.assertTrue((boolean)acl.hasRole(role));
        this.modelManager.addDelegate((User)sam, (User)borris);
        acl = (DynamicAccessControlList)this.userManager.getACL((User)sam);
        Assertions.assertTrue((boolean)acl.hasPermission(permission));
        Assertions.assertTrue((boolean)acl.hasRole(role));
        this.modelManager.removeDelegate((User)borris, (User)sam);
        Assertions.assertFalse((boolean)borris.getDelegatees().contains(sam));
        Assertions.assertFalse((boolean)sam.getDelegators().contains(borris));
        borrisLoaded = (DynamicUser)this.userManager.getUser(USERNAME_BORRIS);
        samLoaded = (DynamicUser)this.userManager.getUser(USERNAME_SAM);
        Assertions.assertFalse((boolean)borrisLoaded.getDelegatees().contains(samLoaded));
        Assertions.assertFalse((boolean)samLoaded.getDelegators().contains(borrisLoaded));
        boolean thrown = false;
        try {
            this.modelManager.removeDelegate((User)borris, (User)sam);
        }
        catch (DataBackendException e) {
            throw e;
        }
        catch (UnknownEntityException e) {
            thrown = true;
        }
        Assertions.assertTrue((boolean)thrown);
    }
}

