/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.turbine;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.turbine.TurbineModelManager;
import org.apache.fulcrum.security.model.turbine.entity.TurbineGroup;
import org.apache.fulcrum.security.model.turbine.entity.TurbineRole;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUser;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUserGroupRole;
import org.apache.fulcrum.security.spi.AbstractManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.UnknownEntityException;

public abstract class AbstractTurbineModelManager
extends AbstractManager
implements TurbineModelManager,
Configurable {
    private static final long serialVersionUID = 1L;
    private String globalGroupName;

    public void configure(Configuration conf) {
        this.globalGroupName = conf.getAttribute("globalGroup", "global");
    }

    @Override
    public Group getGlobalGroup() throws DataBackendException {
        Group g = null;
        try {
            g = (Group)this.getGroupManager().getGroupByName(this.globalGroupName);
        }
        catch (UnknownEntityException uee) {
            g = (Group)this.getGroupManager().getGroupInstance(this.globalGroupName);
            try {
                this.getGroupManager().addGroup(g);
            }
            catch (EntityExistsException eee) {
                throw new DataBackendException(eee.getMessage(), eee);
            }
        }
        return g;
    }

    @Override
    public synchronized void revokeAll(Role role) throws DataBackendException, UnknownEntityException {
        this.revokeAll(role, false);
    }

    @Override
    public synchronized void revokeAll(Role role, boolean cascadeDelete) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        roleExists = this.getRoleManager().checkExists(role);
        if (roleExists) {
            Object[] permissions;
            for (Object permission : permissions = ((TurbineRole)role).getPermissions().toArray()) {
                this.revoke(role, (Permission)permission);
            }
            if (cascadeDelete) {
                Object[] userGroupRoles;
                for (Object userGroupRole : userGroupRoles = ((TurbineRole)role).getUserGroupRoleSet().toArray()) {
                    TurbineUserGroupRole ugr = (TurbineUserGroupRole)userGroupRole;
                    this.revoke(ugr.getUser(), ugr.getGroup(), role);
                }
            }
        } else {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
    }

    @Override
    public synchronized void revokeAll(User user) throws DataBackendException, UnknownEntityException {
        boolean userExists = false;
        userExists = this.getUserManager().checkExists(user);
        if (userExists) {
            Object[] userGroupRoles;
            for (Object userGroupRole : userGroupRoles = ((TurbineUser)user).getUserGroupRoleSet().toArray()) {
                TurbineUserGroupRole ugr = (TurbineUserGroupRole)userGroupRole;
                this.revoke(user, ugr.getGroup(), ugr.getRole());
            }
        } else {
            throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
        }
    }

    @Override
    public synchronized void revokeAll(Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        groupExists = this.getGroupManager().checkExists(group);
        if (groupExists) {
            Object[] userGroupRoles;
            for (Object userGroupRole : userGroupRoles = ((TurbineGroup)group).getUserGroupRoleSet().toArray()) {
                TurbineUserGroupRole ugr = (TurbineUserGroupRole)userGroupRole;
                this.revoke(ugr.getUser(), group, ugr.getRole());
            }
        } else {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
    }

    @Override
    public String getGlobalGroupName() {
        return this.globalGroupName;
    }
}

