/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.upload;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.apache.fulcrum.upload.UploadService;

public class DefaultUploadService
extends AbstractLogEnabled
implements UploadService,
Initializable,
Configurable,
Contextualizable {
    private DiskFileItemFactory itemFactory;
    private int sizeThreshold;
    private int sizeMax = -1;
    private long fileSizeMax = -1L;
    private int fileCountMax = -1;
    private String repositoryPath;
    private String headerEncoding;
    private String applicationRoot;

    @Override
    public long getSizeMax() {
        return this.sizeMax;
    }

    @Override
    public long getSizeThreshold() {
        return this.itemFactory.getThreshold();
    }

    @Override
    public String getRepository() {
        return this.itemFactory.getRepository().toAbsolutePath().toString();
    }

    @Override
    public String getHeaderEncoding() {
        return this.headerEncoding;
    }

    public JakartaServletFileUpload getDefaultFileUpload(HttpServletRequest req, DiskFileItemFactory factory) {
        JakartaServletFileUpload fileUpload = new JakartaServletFileUpload((FileItemFactory)factory);
        fileUpload.setSizeMax((long)this.sizeMax);
        fileUpload.setHeaderCharset(null);
        fileUpload.setFileSizeMax(this.fileSizeMax);
        fileUpload.setFileCountMax((long)this.fileCountMax);
        if (this.getHeaderEncoding() != null) {
            Charset uploadCharset = this.getHeaderEncoding().equals("UTF-8") ? StandardCharsets.UTF_8 : (this.getHeaderEncoding().startsWith("ISO-8859") ? StandardCharsets.ISO_8859_1 : StandardCharsets.UTF_8);
            fileUpload.setHeaderCharset(uploadCharset);
        }
        return fileUpload;
    }

    @Override
    public List<FileItem> parseRequest(HttpServletRequest req) throws ServiceException {
        return this.parseRequest(req, this.sizeMax, this.itemFactory);
    }

    @Override
    public List<FileItem> parseRequest(HttpServletRequest req, String path) throws ServiceException {
        return this.parseRequest(req, this.sizeThreshold, this.sizeMax, path);
    }

    @Override
    public List<FileItem> parseRequest(HttpServletRequest req, int sizeThreshold, int sizeMax, String path) throws ServiceException {
        Path buildPath = Paths.get(path, new String[0]);
        return this.parseRequest(req, sizeMax, ((DiskFileItemFactory.Builder)((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setPath(buildPath)).setBufferSize(sizeThreshold)).get());
    }

    protected List<FileItem> parseRequest(HttpServletRequest req, int sizeMax, DiskFileItemFactory factory) throws ServiceException {
        try {
            JakartaServletFileUpload fileUpload = new JakartaServletFileUpload((FileItemFactory)factory);
            fileUpload.setSizeMax((long)sizeMax);
            fileUpload.setHeaderCharset(null);
            fileUpload.setFileSizeMax(this.fileSizeMax);
            fileUpload.setFileCountMax((long)this.fileCountMax);
            if (this.getHeaderEncoding() != null) {
                Charset uploadCharset = this.getHeaderEncoding().equals("UTF-8") ? StandardCharsets.UTF_8 : (this.getHeaderEncoding().startsWith("ISO-8859") ? StandardCharsets.ISO_8859_1 : StandardCharsets.UTF_8);
                fileUpload.setHeaderCharset(uploadCharset);
            }
            return fileUpload.parseRequest(req);
        }
        catch (FileUploadException e) {
            throw new ServiceException(UploadService.ROLE, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public FileItemInputIterator getItemIterator(HttpServletRequest req) throws ServiceException {
        JakartaServletFileUpload upload = new JakartaServletFileUpload();
        try {
            return upload.getItemIterator(req);
        }
        catch (FileUploadException e) {
            throw new ServiceException(UploadService.ROLE, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ServiceException(UploadService.ROLE, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isMultipart(HttpServletRequest req) {
        return JakartaServletFileUpload.isMultipartContent((HttpServletRequest)req);
    }

    private String getRealPath(String path) {
        String absolutePath = null;
        absolutePath = this.applicationRoot == null ? new File(path).getAbsolutePath() : new File(this.applicationRoot, path).getAbsolutePath();
        return absolutePath;
    }

    public void configure(Configuration conf) {
        this.repositoryPath = conf.getAttribute("repository", ".");
        this.headerEncoding = conf.getAttribute("headerEncoding", "ISO-8859-1");
        this.sizeMax = conf.getAttributeAsInteger("sizeMax", 0x100000);
        this.sizeThreshold = conf.getAttributeAsInteger("sizeThreshold", 10240);
    }

    public void initialize() throws Exception {
        String testPath = this.getRealPath(this.repositoryPath);
        File testDir = new File(testPath);
        if (testDir.exists()) {
            this.repositoryPath = testPath;
        }
        this.getLogger().debug("Upload Service: REPOSITORY_KEY => " + this.repositoryPath);
        this.itemFactory = ((DiskFileItemFactory.Builder)((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setPath(Paths.get(this.repositoryPath, new String[0]))).setBufferSize(this.sizeThreshold)).get();
    }

    public void contextualize(Context context) throws ContextException {
        this.applicationRoot = context.get((Object)"urn:avalon:home").toString();
    }

    @Override
    public long getFileSizeMax() {
        return this.fileSizeMax;
    }

    public void setFileSizeMax(long fileSizeMax) {
        this.fileSizeMax = fileSizeMax;
    }

    public long getFileCountMax() {
        return this.fileCountMax;
    }

    public void setFileCountMax(int fileCountMax) {
        this.fileCountMax = fileCountMax;
    }
}

