/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.rule.AnnotationComparator;
import org.apache.uima.ruta.rule.ComposedRuleElement;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementComparator;
import org.apache.uima.ruta.rule.RuleElementMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComposedRuleElementMatch
extends RuleElementMatch {
    private Map<RuleElement, List<RuleElementMatch>> innerMatches;

    public ComposedRuleElementMatch(RuleElement ruleElement, ComposedRuleElementMatch containerMatch) {
        super(ruleElement, containerMatch);
        this.baseConditionMatched = false;
        ComposedRuleElement cre = (ComposedRuleElement)ruleElement;
        this.innerMatches = new TreeMap<RuleElement, List<RuleElementMatch>>(new RuleElementComparator(cre));
        List<RuleElement> ruleElements = cre.getRuleElements();
        for (RuleElement eachRuleElement : ruleElements) {
            this.innerMatches.put(eachRuleElement, null);
        }
    }

    private void setInnerMatches(Map<RuleElement, List<RuleElementMatch>> innerMatches) {
        this.innerMatches = innerMatches;
    }

    public Map<RuleElement, List<RuleElementMatch>> getInnerMatches() {
        return this.innerMatches;
    }

    public void addInnerMatch(RuleElement ruleElement, RuleElementMatch ruleElementMatch) {
        this.addInnerMatch(ruleElement, ruleElementMatch, true);
    }

    public void addInnerMatch(RuleElement ruleElement, RuleElementMatch ruleElementMatch, boolean included) {
        List<RuleElementMatch> list = this.innerMatches.get(ruleElement);
        if (list == null) {
            list = new ArrayList<RuleElementMatch>();
            this.innerMatches.put(ruleElement, list);
        }
        list.add(ruleElementMatch);
        this.textsMatched.addAll(ruleElementMatch.getTextsMatched());
        this.evaluateInnerMatches(included);
    }

    public void evaluateInnerMatches(boolean included) {
        boolean allDone = true;
        Set<Map.Entry<RuleElement, List<RuleElementMatch>>> entrySet = this.innerMatches.entrySet();
        for (Map.Entry<RuleElement, List<RuleElementMatch>> entry : entrySet) {
            RuleElement element = entry.getKey();
            List<RuleElementMatch> value = entry.getValue();
            allDone &= element.getQuantifier().isOptional(element.getParent()) || value != null;
            if (value == null || value.isEmpty() || !included) continue;
            for (RuleElementMatch ruleElementMatch : value) {
                allDone &= ruleElementMatch.matched();
            }
        }
        this.baseConditionMatched = allDone;
    }

    @Override
    public ComposedRuleElementMatch copy() {
        ComposedRuleElementMatch copy = new ComposedRuleElementMatch(this.ruleElement, this.containerMatch);
        copy.setBaseConditionMatched(this.baseConditionMatched);
        copy.setConditions(this.conditions);
        copy.setConditionsMatched(this.conditionsMatched);
        copy.setTextsMatched(this.textsMatched);
        TreeMap<RuleElement, List<RuleElementMatch>> newMap = new TreeMap<RuleElement, List<RuleElementMatch>>(new RuleElementComparator((ComposedRuleElement)this.ruleElement));
        for (Map.Entry<RuleElement, List<RuleElementMatch>> entry : this.innerMatches.entrySet()) {
            List<RuleElementMatch> value = entry.getValue();
            if (value != null) {
                ArrayList<RuleElementMatch> newValue = new ArrayList<RuleElementMatch>();
                for (RuleElementMatch each : value) {
                    newValue.add(each.copy());
                }
                newMap.put(entry.getKey(), newValue);
                continue;
            }
            newMap.put(entry.getKey(), null);
        }
        copy.setInnerMatches(newMap);
        return copy;
    }

    public ComposedRuleElementMatch copy(ComposedRuleElementMatch extendedContainerMatch) {
        ComposedRuleElementMatch copy = new ComposedRuleElementMatch(this.ruleElement, this.containerMatch);
        copy.setBaseConditionMatched(this.baseConditionMatched);
        copy.setConditions(this.conditions);
        copy.setConditionsMatched(this.conditionsMatched);
        copy.setTextsMatched(this.textsMatched);
        TreeMap<RuleElement, List<RuleElementMatch>> newMap = new TreeMap<RuleElement, List<RuleElementMatch>>(new RuleElementComparator((ComposedRuleElement)this.ruleElement));
        for (Map.Entry<RuleElement, List<RuleElementMatch>> entry : this.innerMatches.entrySet()) {
            ArrayList<RuleElementMatch> newValue;
            RuleElement key = entry.getKey();
            List<RuleElementMatch> value = entry.getValue();
            if (key.equals(extendedContainerMatch.getRuleElement())) {
                extendedContainerMatch.setContainerMatch(copy);
                if (value == null) continue;
                newValue = new ArrayList();
                newValue.addAll(value);
                newValue.set(newValue.size() - 1, extendedContainerMatch);
                newMap.put(extendedContainerMatch.getRuleElement(), newValue);
                continue;
            }
            if (value != null) {
                newValue = new ArrayList<RuleElementMatch>();
                for (RuleElementMatch each : value) {
                    if (each instanceof ComposedRuleElementMatch) {
                        newValue.add(((ComposedRuleElementMatch)each).copy(extendedContainerMatch));
                        continue;
                    }
                    newValue.add(each.copy());
                }
                newMap.put(entry.getKey(), newValue);
                continue;
            }
            newMap.put(entry.getKey(), null);
        }
        copy.setInnerMatches(newMap);
        return copy;
    }

    public void update(ComposedRuleElementMatch extendedContainerMatch) {
        for (Map.Entry<RuleElement, List<RuleElementMatch>> entry : this.innerMatches.entrySet()) {
            RuleElement key = entry.getKey();
            List<RuleElementMatch> value = entry.getValue();
            if (key.equals(extendedContainerMatch.getRuleElement())) {
                extendedContainerMatch.setContainerMatch(this);
                if (value == null) continue;
                value.set(value.size() - 1, extendedContainerMatch);
                continue;
            }
            if (value == null) continue;
            for (RuleElementMatch each : value) {
                if (!(each instanceof ComposedRuleElementMatch)) continue;
                ((ComposedRuleElementMatch)each).update(extendedContainerMatch);
            }
        }
    }

    @Override
    public String toString() {
        return "CREM" + this.innerMatches.toString();
    }

    @Override
    public List<AnnotationFS> getTextsMatched() {
        TreeSet<AnnotationFS> set = new TreeSet<AnnotationFS>(new AnnotationComparator());
        Collection<List<RuleElementMatch>> values = this.innerMatches.values();
        for (List<RuleElementMatch> list : values) {
            if (list == null) continue;
            for (RuleElementMatch ruleElementMatch : list) {
                set.addAll(ruleElementMatch.getTextsMatched());
            }
        }
        return Arrays.asList(set.toArray(new AnnotationFS[0]));
    }

    public void setConditionInfo(List<EvaluatedCondition> evaluatedConditions) {
        this.conditions = evaluatedConditions;
        for (EvaluatedCondition each : this.conditions) {
            this.conditionsMatched &= each.isValue();
        }
    }
}

