/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.tools;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.util.FileUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class SGMLToXMIConverter {
    public static boolean DEBUG = true;

    static void convertSGMLAnnotationsToCASAnotations(String documentText, CAS cas) {
        StringBuffer textBuf = new StringBuffer(documentText);
        TypeSystem ts = cas.getTypeSystem();
        int annotations = 0;
        while (true) {
            int indexTagBegin = textBuf.indexOf("<");
            int indexTagEnd = textBuf.indexOf(">", indexTagBegin);
            if (indexTagBegin < 0 || indexTagEnd < 0) break;
            try {
                String name = textBuf.substring(indexTagBegin + 1, indexTagEnd);
                int lengthTag = indexTagEnd - indexTagBegin + 1;
                Type theType = ts.getType("org.apache.uima.ml.types." + name);
                if (theType != null) {
                    TextRulerToolkit.log("\tType known, creating Annotation: " + name);
                    int indexTagCloseBegin = textBuf.indexOf("<", indexTagEnd);
                    AnnotationFS fs = cas.createAnnotation(theType, indexTagBegin, indexTagCloseBegin - lengthTag);
                    cas.addFsToIndexes((FeatureStructure)fs);
                    ++annotations;
                }
            }
            catch (Exception e) {
                TextRulerPlugin.error(e);
            }
            textBuf.delete(indexTagBegin, indexTagEnd + 1);
        }
        cas.setDocumentText(textBuf.toString());
        if (annotations == 0) {
            TextRulerToolkit.log("NO ANNOTATIONS CREATED! IS THAT INTENDED ?");
        }
    }

    public static void convertFilesInFolder(String inFolder, String outFolder, String tmFileForEngine) {
        File in = new File(inFolder);
        File[] files = in.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !name.startsWith(".");
            }
        });
        outFolder = TextRulerToolkit.addTrailingSlashToPath(outFolder);
        AnalysisEngine ae = TextRulerToolkit.loadAnalysisEngine(TextRulerToolkit.getEngineDescriptorFromTMSourceFile((IPath)new Path(tmFileForEngine)));
        if (ae == null) {
            TextRulerToolkit.log("ERROR LOADING ANALYSIS ENGINE!");
            return;
        }
        for (File f : files) {
            try {
                String fileContents = FileUtils.file2String((File)f);
                CAS theCas = ae.newCAS();
                SGMLToXMIConverter.convertSGMLAnnotationsToCASAnotations(fileContents, theCas);
                TextRulerToolkit.writeCAStoXMIFile(theCas, outFolder + f.getName() + ".xmi");
                TextRulerToolkit.log("Saved to " + outFolder + f.getName() + ".xmi");
            }
            catch (Exception e) {
                TextRulerPlugin.error(e);
            }
        }
    }
}

