/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class MacroCondition
extends AbstractRutaCondition {
    private final String name;
    private final Map<String, String> definition;
    private final List<AbstractRutaCondition> conditions;
    private final Set<String> vars;
    private final List<IRutaExpression> arguments;

    public MacroCondition(String name, Map<String, String> definition, List<AbstractRutaCondition> conditions, Set<String> vars, List<IRutaExpression> arguments) {
        this.name = name;
        this.definition = definition;
        this.conditions = conditions;
        this.vars = vars;
        this.arguments = arguments;
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        boolean result = true;
        this.prepareEnvironment(context, stream);
        ArrayList<EvaluatedCondition> evals = new ArrayList<EvaluatedCondition>();
        for (AbstractRutaCondition each : this.conditions) {
            crowd.beginVisit(each, null);
            EvaluatedCondition eval = each.eval(context, stream, crowd);
            crowd.endVisit(each, null);
            result &= eval.isValue();
            evals.add(eval);
        }
        this.cleanupEnvironment(context, stream);
        return new EvaluatedCondition(this, result, evals);
    }

    private void prepareEnvironment(MatchContext context, RutaStream stream) {
        RutaBlock parent = context.getParent();
        RutaEnvironment environment = parent.getEnvironment();
        Set<Map.Entry<String, String>> entrySet = this.definition.entrySet();
        int index = 0;
        for (Map.Entry<String, String> entry : entrySet) {
            String name = entry.getKey();
            String type = entry.getValue();
            IRutaExpression expression = this.arguments.get(index);
            if (!this.vars.contains(name)) {
                environment.addVariable(name, type);
                stream.assignVariable(name, expression, context);
            } else {
                String var = environment.getVariableNameOfExpression(expression);
                environment.addAliasVariable(name, var);
            }
            ++index;
        }
    }

    private void cleanupEnvironment(MatchContext context, RutaStream stream) {
        RutaBlock parent = context.getParent();
        RutaEnvironment environment = parent.getEnvironment();
        Set<Map.Entry<String, String>> entrySet = this.definition.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String name = entry.getKey();
            if (!this.vars.contains(name)) {
                environment.removeVariable(name);
                continue;
            }
            environment.removeAliasVariable(name);
        }
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getDefinition() {
        return this.definition;
    }

    public List<AbstractRutaCondition> getActions() {
        return this.conditions;
    }

    public List<IRutaExpression> getArguments() {
        return this.arguments;
    }
}

