/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.AllFSs;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CasTypeSystemMapper;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.cas.impl.FsIndex_singletype;
import org.apache.uima.cas.impl.SlotKinds;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeImpl_array;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.Int2ObjHashMap;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.internal.util.Obj2IntIdentityHashMap;
import org.apache.uima.internal.util.Pair;
import org.apache.uima.internal.util.PositiveIntSet;
import org.apache.uima.internal.util.PositiveIntSet_impl;
import org.apache.uima.internal.util.function.Consumer2;
import org.apache.uima.jcas.cas.BooleanArray;
import org.apache.uima.jcas.cas.ByteArray;
import org.apache.uima.jcas.cas.CommonList;
import org.apache.uima.jcas.cas.DoubleArray;
import org.apache.uima.jcas.cas.EmptyList;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.FloatArray;
import org.apache.uima.jcas.cas.FloatList;
import org.apache.uima.jcas.cas.IntegerArray;
import org.apache.uima.jcas.cas.IntegerList;
import org.apache.uima.jcas.cas.LongArray;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.cas.NonEmptyFloatList;
import org.apache.uima.jcas.cas.NonEmptyIntegerList;
import org.apache.uima.jcas.cas.NonEmptyStringList;
import org.apache.uima.jcas.cas.ShortArray;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.cas.StringList;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.util.IntEntry;

public class CasCompare {
    private static final boolean IS_DEBUG_STOP_ON_MISCOMPARE = false;
    private static final boolean IS_MEAS_LIST_2_ARRAY = false;
    private static final String BLANKS_89 = Misc.blanks.substring(0, 89);
    private static boolean IS_SHOW_PROGRESS = false;
    private static final boolean IS_CANONICAL_EMPTY_LISTS = true;
    private static final CommonList removed_list_marker = new NonEmptyFSList();
    private final Int2ObjHashMap<ArrayList<CommonList>, ArrayList<CommonList>> map_e_to_a_list = new Int2ObjHashMap(ArrayList.class);
    private final PositiveIntSet non_linear_list_elements = new PositiveIntSet_impl();
    private final Obj2IntIdentityHashMap<CommonList> node_indexes = new Obj2IntIdentityHashMap<CommonList>(CommonList.class, removed_list_marker);
    private final PositiveIntSet list_successor_seen = new PositiveIntSet_impl();
    private final Map<TypeImpl, FeatLists> type2featLists = new HashMap<TypeImpl, FeatLists>();
    private final CASImpl c1;
    private final CASImpl c2;
    private final TypeSystemImpl ts1;
    private final TypeSystemImpl ts2;
    private boolean isCompareAll = false;
    private boolean isCompareIds = false;
    private Pair<TOP, TOP> leafErrorReported = null;
    private final Set<String> excludedRootNames = new HashSet<String>(0);
    private final Set<String> includedTypeNames = new HashSet<String>(0);
    private final Map<Pair<TOP, TOP>, Integer> prevCompare = new HashMap<Pair<TOP, TOP>, Integer>();
    private final Set<Pair<TOP, TOP>> prevReport = new HashSet<Pair<TOP, TOP>>();
    private final Prev prev1 = new Prev();
    private final Prev prev2 = new Prev();
    private boolean isSrcCas;
    private final StringBuilder mismatchSb = new StringBuilder();
    private boolean inSortContext = false;
    private boolean isSkipMismatch = false;
    private boolean isTypeMapping;
    private final CasTypeSystemMapper typeMapper;
    private ArrayList<TOP> c1FoundFSs;
    private ArrayList<TOP> c2FoundFSs;
    private final Map<ScsKey, String[]> stringCongruenceSets = new HashMap<ScsKey, String[]>();
    private boolean isUsingStringCongruenceSets = false;
    private int maxId1;
    private int maxId2;
    private int miscompare_index;
    private int s1maxLen = 0;
    private static int working_on;

    public static boolean compareCASes(CASImpl c1, CASImpl c2) {
        return new CasCompare(c1, c2).compareCASes();
    }

    public CasCompare(CASImpl c1, CASImpl c2) {
        this.c1 = c1;
        this.c2 = c2;
        this.ts1 = c1.getTypeSystemImpl();
        this.ts2 = c2.getTypeSystemImpl();
        this.typeMapper = this.ts1.getTypeSystemMapper(this.ts2);
        this.isTypeMapping = null != this.typeMapper;
    }

    public void compareAll(boolean v) {
        this.isCompareAll = v;
    }

    public void compareIds(boolean v) {
        this.isCompareIds = v;
    }

    public void applyToBoth(Consumer<CASImpl> c) {
        c.accept(this.c1);
        c.accept(this.c2);
    }

    public void applyToTypeFeature(String typeName, String featureBaseName, Consumer2<TOP, Feature> c) {
        this.applyToTypeFeature_inner(this.c1, typeName, featureBaseName, c);
        this.applyToTypeFeature_inner(this.c2, typeName, featureBaseName, c);
    }

    private void applyToTypeFeature_inner(CASImpl cas, String typeName, String featureBaseName, Consumer2<TOP, Feature> c) {
        TypeSystem ts = cas.getTypeSystem();
        Type type = ts.getType(typeName);
        Feature feat = type.getFeatureByBaseName(featureBaseName);
        cas.select(type).allViews().forEach(fs -> c.accept2((TOP)fs, feat));
    }

    public List<Runnable> type_feature_to_runnable(String typeName, String featureBaseName, BiFunction<TOP, Feature, Runnable> c) {
        ArrayList<Runnable> r = new ArrayList<Runnable>();
        working_on = 1;
        r.addAll(this.type_feature_to_runnable(this.c1, typeName, featureBaseName, c));
        working_on = 2;
        r.addAll(this.type_feature_to_runnable(this.c2, typeName, featureBaseName, c));
        return r;
    }

    private List<Runnable> type_feature_to_runnable(CASImpl cas, String typeName, String featureBaseName, BiFunction<TOP, Feature, Runnable> c) {
        TypeSystem ts = cas.getTypeSystem();
        Type type = ts.getType(typeName);
        Feature feat = type.getFeatureByBaseName(featureBaseName);
        return cas.select(type).allViews().map(fs -> (Runnable)c.apply((TOP)fs, feat)).collect(Collectors.toList());
    }

    public void canonicalizeString(String typeName, String featureBaseName, String[] items_to_change, String canonical_value) {
        this.applyToTypeFeature(typeName, featureBaseName, (fs, feat) -> {
            if (Misc.contains(items_to_change, fs.getStringValue((Feature)feat))) {
                fs.setStringValue((Feature)feat, canonical_value);
            }
        });
    }

    public List<Runnable> sortFSArray(String typeName, String featureBaseName) {
        return this.type_feature_to_runnable(typeName, featureBaseName, (fs, feat) -> this.sortFSArray((FSArray)fs.getFeatureValue((Feature)feat)));
    }

    public List<Runnable> sort_dedup_FSArray(String typeName, String featureBaseName) {
        return this.type_feature_to_runnable(typeName, featureBaseName, (fs, feat) -> this.sort_dedup_FSArray((TOP)fs, (Feature)feat));
    }

    public List<Runnable> sortStringArray(String typeName, String featureBaseName) {
        return this.type_feature_to_runnable(typeName, featureBaseName, (fs, feat) -> this.sortStringArray((StringArray)fs.getFeatureValue((Feature)feat)));
    }

    public void excludeRootTypesFromIndexes(Set<String> excluded_typeNames) {
        this.includedTypeNames.clear();
        this.excludedRootNames.addAll(excluded_typeNames);
    }

    public void excludeCollectionsTypesFromIndexes() {
        this.includedTypeNames.clear();
        this.excludedRootNames.addAll(Arrays.asList("uima.cas.BooleanArray", "uima.cas.ByteArray", "uima.cas.ShortArray", "uima.cas.IntegerArray", "uima.cas.LongArray", "uima.cas.FloatArray", "uima.cas.DoubleArray", "uima.cas.StringArray", "uima.cas.FSArray", "org.apache.uima.jcas.cas.FSArrayList", "org.apache.uima.jcas.cas.FSHashSet", "org.apache.uima.jcas.cas.IntegerArrayList", "org.apache.uima.jcas.cas.FSLinkedHashSet", "org.apache.uima.jcas.cas.Int2FS"));
    }

    public void excludeListTypesFromIndexes() {
        this.includedTypeNames.clear();
        this.excludedRootNames.addAll(Arrays.asList("uima.cas.NonEmptyFloatList", "uima.cas.NonEmptyIntegerList", "uima.cas.NonEmptyStringList"));
    }

    public void includeOnlyTheseTypesFromIndexes(List<String> includedTypeNames) {
        this.excludedRootNames.clear();
        this.includedTypeNames.addAll(includedTypeNames);
    }

    public void addStringCongruenceSet(String typeName, String featureBaseName, String[] set_of_strings_that_are_equivalent, int index) {
        TypeImpl t1 = this.ts1.getType(typeName);
        this.stringCongruenceSets.put(new ScsKey(t1, t1.getFeatureByBaseName(featureBaseName), index), set_of_strings_that_are_equivalent);
        this.isUsingStringCongruenceSets = true;
    }

    public static void showProgress() {
        IS_SHOW_PROGRESS = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareCASes() {
        boolean allOk = true;
        boolean savedIsTypeMapping = this.isTypeMapping;
        this.mismatchSb.setLength(0);
        try {
            Predicate<TOP> includeFilter;
            Predicate<TOP> predicate = includeFilter = this.isTypeMapping ? fs -> this.isTypeInTgt((TOP)fs) : null;
            if (IS_SHOW_PROGRESS) {
                System.out.println("Finding all FSs in cas 1");
            }
            this.c1FoundFSs = new AllFSs(this.c1, null, includeFilter, this.isTypeMapping ? this.typeMapper : null).getAllFSsAllViews_sofas_reachable().getAllFSs();
            if (IS_SHOW_PROGRESS) {
                System.out.println("Finding all FSs in cas 2");
            }
            this.c2FoundFSs = new AllFSs(this.c2, null, null, null).getAllFSsAllViews_sofas_reachable().getAllFSs();
            if (this.excludedRootNames.size() > 0) {
                System.out.println("Excluding Root Names with: " + Misc.ppList(Arrays.asList(this.excludedRootNames.toArray())));
                this.c1FoundFSs = this.c1FoundFSs.stream().filter(fs -> !this.excludedRootNames.contains(fs.getType().getName())).collect(Collectors.toCollection(ArrayList::new));
                this.c2FoundFSs = this.c2FoundFSs.stream().filter(fs -> !this.excludedRootNames.contains(fs.getType().getName())).collect(Collectors.toCollection(ArrayList::new));
            } else if (this.includedTypeNames.size() > 0) {
                System.out.println("Including only Root Names: " + Misc.ppList(Arrays.asList(this.includedTypeNames.toArray())));
                this.c1FoundFSs = this.c1FoundFSs.stream().filter(fs -> this.includedTypeNames.contains(fs.getType().getName())).collect(Collectors.toCollection(ArrayList::new));
                this.c2FoundFSs = this.c2FoundFSs.stream().filter(fs -> this.includedTypeNames.contains(fs.getType().getName())).collect(Collectors.toCollection(ArrayList::new));
            }
            int i1 = 0;
            int i2 = 0;
            this.maxId1 = this.c1.peekNextFsId();
            this.maxId2 = this.c2.peekNextFsId();
            this.convert_linear_lists_to_arrays(this.c1FoundFSs);
            this.convert_linear_lists_to_arrays(this.c2FoundFSs);
            int sz1 = this.c1FoundFSs.size();
            int sz2 = this.c2FoundFSs.size();
            this.isSrcCas = true;
            if (IS_SHOW_PROGRESS) {
                System.out.println("Sorting FSs in cas 1");
            }
            this.sort(this.c1FoundFSs);
            this.isSrcCas = false;
            if (IS_SHOW_PROGRESS) {
                System.out.println("Sorting FSs in cas 2");
            }
            this.sort(this.c2FoundFSs);
            this.prevReport.clear();
            int fsz = Math.max(sz1, sz2);
            int fsz100 = Math.max(1, fsz / 100);
            int prev_done = 0;
            if (IS_SHOW_PROGRESS) {
                System.out.format("Starting compare loop, for %,d FSs%n", Math.max(sz1, sz2));
            }
            while (i1 < sz1 && i2 < sz2) {
                boolean bl;
                int done;
                if (IS_SHOW_PROGRESS && (done = Math.max(i1, i2)) - prev_done >= fsz100) {
                    System.out.format("percent done: %d%n", Math.round((float)done * 100.0f / (float)fsz));
                    prev_done = done;
                }
                TOP fs1 = this.c1FoundFSs.get(i1);
                TOP fs2 = this.c2FoundFSs.get(i2);
                this.leafErrorReported = null;
                if (null == fs1) {
                    if (null != fs2) {
                        System.err.format("%,d Feature Structures in CAS2 with no matches in CAS2, e.g. %s%n", sz2 - i2, fs2.toString(2));
                        bl = !allOk;
                        return bl;
                    }
                    bl = allOk;
                    return bl;
                }
                if (null == fs2) {
                    System.err.format("%,d Feature Structures in CAS1 with no matches in CAS2, e.g. %s%n", sz1 - i1, fs1.toString(2));
                    bl = !allOk;
                    return bl;
                }
                if (fs1 instanceof EmptyList && !(fs2 instanceof EmptyList)) {
                    start = i1;
                    while (++i1 < sz1 && (fs1 = this.c1FoundFSs.get(i1)) instanceof EmptyList) {
                    }
                    System.out.println("CasCompare skipping " + (i1 - start) + " emptylist FSs in 1st CAS to realign.");
                } else if (fs2 instanceof EmptyList && !(fs1 instanceof EmptyList)) {
                    start = i2;
                    while (++i2 < sz2 && (fs2 = this.c2FoundFSs.get(i2)) instanceof EmptyList) {
                    }
                    System.out.println("CasCompare skipping " + (i2 - start) + " emptylist FSs in 2nd CAS to realign.");
                }
                this.clearPrevFss();
                this.prev1.prevCompareTop = fs1;
                this.prev2.prevCompareTop = fs2;
                if (this.isTypeMapping) {
                    boolean typeMissingIn2;
                    boolean typeMissingIn1 = this.typeMapper.mapTypeTgt2Src(fs2._getTypeImpl()) == null;
                    boolean bl2 = typeMissingIn2 = this.typeMapper.mapTypeSrc2Tgt(fs1._getTypeImpl()) == null;
                    if (!typeMissingIn1 && !typeMissingIn2) {
                        if (0 != this.compareFss(fs1, fs2, null, null)) {
                            this.mismatchFsDisplay();
                            if (!this.isCompareAll) {
                                boolean bl3 = false;
                                return bl3;
                            }
                            allOk = false;
                            int tc = fs1._getTypeImpl().compareTo(fs2._getTypeImpl());
                            if (tc < 0) {
                                System.out.print("skiping first to align types ");
                                while (tc < 0 && i1 < sz1) {
                                    tc = this.c1FoundFSs.get(++i1)._getTypeImpl().compareTo(fs2._getTypeImpl());
                                    System.out.print(".");
                                }
                                System.out.println("");
                            } else if (tc > 0) {
                                System.out.print("skiping second to align types ");
                                while (tc > 0 && i2 < sz2) {
                                    tc = fs1._getTypeImpl().compareTo(this.c2FoundFSs.get(++i2)._getTypeImpl());
                                    System.out.print(".");
                                }
                                System.out.println("");
                            }
                        }
                        ++i1;
                        ++i2;
                        continue;
                    }
                    if (typeMissingIn1 && typeMissingIn2) {
                        Misc.internalError();
                        ++i1;
                        ++i2;
                        continue;
                    }
                    if (typeMissingIn1) {
                        System.out.println("debug - type missing in 1, but test fails for refs");
                        ++i2;
                        continue;
                    }
                    if (!typeMissingIn2) continue;
                    Misc.internalError();
                    ++i1;
                    continue;
                }
                int rr = -1;
                try {
                    rr = this.compareFss(fs1, fs2, null, null);
                }
                catch (Throwable e) {
                    System.out.println("debug caught throwable");
                    e.printStackTrace();
                }
                if (0 != rr) {
                    this.mismatchFsDisplay();
                    if (!this.isCompareAll) {
                        boolean e = false;
                        return e;
                    }
                    allOk = false;
                    int tc = fs1._getTypeImpl().compareTo(fs2._getTypeImpl());
                    if (tc < 0) {
                        System.out.print("skiping first to align types ");
                        while (tc < 0 && i1 < sz1) {
                            tc = this.c1FoundFSs.get(++i1)._getTypeImpl().compareTo(fs2._getTypeImpl());
                            System.out.print(".");
                        }
                        System.out.println("");
                    } else if (tc > 0) {
                        System.out.print("skiping second to align types ");
                        while (tc > 0 && i2 < sz2) {
                            tc = fs1._getTypeImpl().compareTo(this.c2FoundFSs.get(++i2)._getTypeImpl());
                            System.out.print(".");
                        }
                        System.out.println("");
                    } else if (i1 + 1 < sz1) {
                        fs1 = this.c1FoundFSs.get(i1 + 1);
                        this.clearPrevFss();
                        this.prev1.prevCompareTop = fs1;
                        this.prev2.prevCompareTop = fs2;
                        if (0 == this.compareFss(fs1, fs2, null, null)) {
                            System.out.println("Skipping 1 to realign within same type " + fs1._getTypeImpl().getName());
                            ++i1;
                        }
                    }
                }
                ++i1;
                ++i2;
            }
            if (i1 == sz1 && i2 == sz2) {
                boolean fs1 = allOk;
                return fs1;
            }
            if (this.isTypeMapping) {
                if (i1 < sz1) {
                    System.err.format("%,d Feature Structures in CAS1 with no matches in CAS2, e.g. %s%n", sz1 - i1, this.c1FoundFSs.get(i1));
                    boolean fs1 = false;
                    return fs1;
                }
                while (i2 < sz2) {
                    TOP fs2 = this.c2FoundFSs.get(i2);
                    if (this.isTypeMapping && this.typeMapper.mapTypeTgt2Src(fs2._getTypeImpl()) != null) {
                        boolean bl = false;
                        return bl;
                    }
                    ++i2;
                }
                boolean bl = true;
                return bl;
            }
            if (i1 < sz1) {
                System.err.format("CAS1 had %,d additional Feature Structures, e.g.: %s%n", sz1 - i1, this.c1FoundFSs.get(i1));
            } else {
                System.err.format("CAS2 had %,d additional Feature Structures, e.g.: %s%n", sz2 - i2, this.c2FoundFSs.get(i2));
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.isTypeMapping = savedIsTypeMapping;
            this.clearPrevFss();
        }
    }

    public Runnable sortFSArray(FSArray<?> fsArray) {
        if (fsArray == null || fsArray.size() < 2) {
            return null;
        }
        TOP[] a = (TOP[])fsArray._getTheArray().clone();
        this.clearPrevFss();
        this.inSortContext = true;
        Arrays.sort(a, (afs1, afs2) -> this.compareRefs((TOP)afs1, (TOP)afs2, null, null));
        return () -> System.arraycopy(a, 0, fsArray._getTheArray(), 0, fsArray.size());
    }

    public Runnable sort_dedup_FSArray(TOP fs, Feature feat) {
        FSArray fsArray = (FSArray)fs.getFeatureValue(feat);
        if (fsArray == null || fsArray.size() < 2) {
            return null;
        }
        TOP[] a = (TOP[])fsArray._getTheArray().clone();
        this.clearPrevFss();
        this.inSortContext = true;
        Arrays.sort(a, (afs1, afs2) -> this.compareRefs((TOP)afs1, (TOP)afs2, null, null));
        ArrayList<TOP> dedup = new ArrayList<TOP>(a.length);
        TOP prev = null;
        for (TOP top : a) {
            if (top == prev) continue;
            prev = top;
            dedup.add(top);
        }
        FeatureStructure[] r = dedup.toArray(new TOP[dedup.size()]);
        if (r.length == a.length) {
            return () -> System.arraycopy(a, 0, fsArray._getTheArray(), 0, fsArray.size());
        }
        CASImpl cas = fs.getCASImpl();
        FSArray fsa = (FSArray)cas.createArray(fsArray._getTypeImpl(), r.length);
        if (IS_SHOW_PROGRESS) {
            System.out.format("Dedup found dup in cas %d for type/feature %s, removed %d%n", working_on, feat.getName(), a.length - r.length);
        }
        fsa.copyFromArray(r, 0, 0, r.length);
        return () -> fs.setFeatureValue(feat, fsa);
    }

    public Runnable sortStringArray(StringArray stringArray) {
        if (stringArray == null || stringArray.size() < 2) {
            return null;
        }
        Object[] a = (String[])stringArray._getTheArray().clone();
        this.inSortContext = true;
        Arrays.sort(a);
        return () -> CasCompare.lambda$sortStringArray$16((String[])a, stringArray);
    }

    private void convert_linear_lists_to_arrays(ArrayList<TOP> fss) {
        this.map_e_to_a_list.clear();
        this.non_linear_list_elements.clear();
        this.node_indexes.clear();
        int sz = fss.size();
        if (sz == 0) {
            return;
        }
        for (int i = 0; i < sz; ++i) {
            TOP fs = fss.get(i);
            if (!(fs instanceof CommonList)) continue;
            CommonList node = (CommonList)((Object)fs);
            if (node.isEmpty()) {
                fss.set(i, null);
                continue;
            }
            if (this.non_linear_list_elements.contains(node._id())) continue;
            if (null != this.map_e_to_a_list.get(node._id())) {
                this.node_indexes.put(node, i + 1);
                continue;
            }
            this.node_indexes.put(node, i + 1);
            if (node.isEmpty()) continue;
            ArrayList<CommonList> al = new ArrayList<CommonList>();
            al.add(node);
            this.map_e_to_a_list.put(node._id(), al);
            if (this.addSuccessors(node, al)) continue;
            this.move_to_non_linear(al);
        }
        CASImpl view = fss.get((int)0)._casView;
        TypeSystemImpl tsi = view.getTypeSystemImpl();
        Set processed = Collections.newSetFromMap(new IdentityHashMap());
        for (IntEntry<ArrayList<CommonList>> intEntry : this.map_e_to_a_list) {
            ArrayList<CommonList> e = intEntry.getValue();
            if (!processed.add(e)) continue;
            this.convert_to_array(e, fss, view, tsi);
        }
        this.map_e_to_a_list.clear();
        this.non_linear_list_elements.clear();
        this.node_indexes.clear();
    }

    private void convert_to_array(ArrayList<CommonList> al, ArrayList<TOP> fss, CASImpl view, TypeSystemImpl tsi) {
        CommonList e = al.get(0);
        if (e instanceof FSList) {
            assert (al.size() > 0);
            FSArray fsa = new FSArray(tsi.fsArrayType, view, al.size());
            int i = 0;
            for (CommonList n : al) {
                assert (!n.isEmpty());
                fsa.set(i++, ((NonEmptyFSList)n).getHead());
                fss.set(this.node_indexes.get(n) - 1, null);
            }
            fss.add(fsa);
        } else if (e instanceof IntegerList) {
            IntegerArray a = new IntegerArray(tsi.intArrayType, view, al.size());
            int i = 0;
            for (CommonList n : al) {
                a.set(i++, n instanceof EmptyList ? Integer.MIN_VALUE : ((NonEmptyIntegerList)n).getHead());
                fss.set(this.node_indexes.get(n) - 1, null);
            }
            fss.add(a);
        } else if (e instanceof FloatList) {
            FloatArray a = new FloatArray(tsi.floatArrayType, view, al.size());
            int i = 0;
            for (CommonList n : al) {
                a.set(i++, n instanceof EmptyList ? Float.MIN_VALUE : ((NonEmptyFloatList)n).getHead());
                fss.set(this.node_indexes.get(n) - 1, null);
            }
            fss.add(a);
        } else if (e instanceof StringList) {
            StringArray a = new StringArray(tsi.stringArrayType, view, al.size());
            int i = 0;
            for (CommonList n : al) {
                a.set(i++, n instanceof EmptyList ? null : ((NonEmptyStringList)n).getHead());
                fss.set(this.node_indexes.get(n) - 1, null);
            }
            fss.add(a);
        } else {
            Misc.internalError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addSuccessors(CommonList node, ArrayList<CommonList> al) {
        try {
            this.list_successor_seen.add(node._id());
            while (!node.isEmpty() && (node = node.getCommonTail()) != null && !node.isEmpty()) {
                if (!this.list_successor_seen.add(node._id())) {
                    boolean bl = false;
                    return bl;
                }
                ArrayList<CommonList> other = this.map_e_to_a_list.get(node._id());
                if (null != other) {
                    this.couple_array_lists(al, other, node);
                    boolean bl = true;
                    return bl;
                }
                al.add(node);
                this.map_e_to_a_list.put(node._id(), al);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.list_successor_seen.clear();
        }
    }

    private void couple_array_lists(ArrayList<CommonList> a1, ArrayList<CommonList> a2, CommonList commonNode) {
        int i;
        int sz2 = a2.size();
        for (i = 0; i < sz2 && commonNode != a2.get(i); ++i) {
        }
        if (i == sz2) {
            Misc.internalError();
        }
        while (i < sz2) {
            CommonList node = a2.get(i);
            this.map_e_to_a_list.put(node._id(), a1);
            a1.add(node);
            ++i;
        }
    }

    private void move_to_non_linear(ArrayList<CommonList> al) {
        for (CommonList e : al) {
            this.map_e_to_a_list.remove(e._id());
            this.non_linear_list_elements.add(e._id());
        }
    }

    private void clearPrevFss() {
        this.prevCompare.clear();
        this.prev1.clear();
        this.prev2.clear();
    }

    private int compareFss(TOP fs1, TOP fs2, TypeImpl callerTi, FeatureImpl callerFi) {
        if (fs1 == fs2) {
            return 0;
        }
        TypeImpl ti1 = fs1._getTypeImpl();
        TypeImpl ti2 = fs2._getTypeImpl();
        int r = 0;
        if (!this.inSortContext && this.isTypeMapping) {
            ti2 = this.typeMapper.mapTypeTgt2Src(ti2);
        }
        if ((r = ti1.compareTo(ti2)) != 0) {
            if (!this.inSortContext) {
                this.mismatchFs(fs1, fs2, "Different Types", callerTi, callerFi);
            }
            return r;
        }
        if (this.isCompareIds && !this.inSortContext && fs1._id < this.maxId1 && fs2._id < this.maxId2 && fs1._id != fs2._id) {
            this.mismatchFs(fs1, fs2, "IDs miscompare", callerTi, callerFi);
            return Integer.compare(fs1._id, fs2._id);
        }
        if (ti1.isArray()) {
            return this.compareFssArray(fs1, fs2, callerTi, callerFi);
        }
        FeatLists featLists = this.type2featLists.get(ti1);
        if (featLists == null) {
            featLists = this.computeFeatLists(ti1);
            this.type2featLists.put(ti1, featLists);
        }
        FeatureImpl[][] featureImplArray = featLists.featsByEase;
        int n = featureImplArray.length;
        for (int i = 0; i < n; ++i) {
            FeatureImpl[] featSet;
            for (FeatureImpl fi1 : featSet = featureImplArray[i]) {
                r = this.compareFeature(fs1, fs2, ti1, fi1);
                if (0 == r) continue;
                if (!this.inSortContext) {
                    // empty if block
                }
                return r;
            }
        }
        return 0;
    }

    private int compareFeature(TOP fs1, TOP fs2, TypeImpl ti1, FeatureImpl fi1) {
        FeatureImpl fi2;
        int r = 0;
        if (this.inSortContext && this.isTypeMapping && (this.isSrcCas && this.typeMapper.getTgtFeature(ti1, fi1) == null || !this.isSrcCas && this.typeMapper.getSrcFeature(ti1, fi1) == null)) {
            return 0;
        }
        FeatureImpl featureImpl = fi2 = !this.inSortContext && this.isTypeMapping ? this.typeMapper.getTgtFeature(ti1, fi1) : fi1;
        if (fi2 != null && 0 != (r = this.compareSlot(fs1, fs2, fi1, fi2, ti1))) {
            if (!this.inSortContext) {
                this.mismatchFs(fs1, fs2, fi1, (Feature)fi2);
            }
            return r;
        }
        return r;
    }

    private FeatLists computeFeatLists(TypeImpl ti) {
        ArrayList<FeatureImpl> easy = new ArrayList<FeatureImpl>();
        ArrayList<FeatureImpl> easyArrays = new ArrayList<FeatureImpl>();
        ArrayList<FeatureImpl> ref = new ArrayList<FeatureImpl>();
        ArrayList<FeatureImpl> refArrays = new ArrayList<FeatureImpl>();
        for (FeatureImpl fi : ti.getFeatureImpls()) {
            if (this.isTypeMapping && (this.isSrcCas && this.typeMapper.getTgtFeature(ti, fi) == null || !this.isSrcCas && this.typeMapper.getSrcFeature(ti, fi) == null)) continue;
            TypeImpl range = fi.getRangeImpl();
            if (range.isArray()) {
                TypeImpl_array ra = (TypeImpl_array)range;
                if (ra.getComponentType().isRefType) {
                    refArrays.add(fi);
                    continue;
                }
                easyArrays.add(fi);
                continue;
            }
            if (range.isRefType) {
                ref.add(fi);
                continue;
            }
            easy.add(fi);
        }
        return new FeatLists(easy, easyArrays, ref, refArrays);
    }

    private int compareFssArray(TOP fs1, TOP fs2, TypeImpl callerTi, FeatureImpl callerFi) {
        int len2;
        CommonArrayFS a1 = (CommonArrayFS)((Object)fs1);
        CommonArrayFS a2 = (CommonArrayFS)((Object)fs2);
        int len1 = a1.size();
        int r = Integer.compare(len1, len2 = a2.size());
        if (r != 0) {
            if (!this.inSortContext) {
                this.mismatchFs(fs1, fs2, callerTi, callerFi);
            }
            return r;
        }
        TypeImpl ti = ((FeatureStructureImplC)((Object)a1))._getTypeImpl();
        SlotKinds.SlotKind kind = ti.getComponentSlotKind();
        switch (kind) {
            case Slot_BooleanRef: {
                r = this.compareAllArrayElements(fs1, fs2, len1, i -> Boolean.compare(((BooleanArray)a1).get(i), ((BooleanArray)a2).get(i)), callerTi, callerFi);
                break;
            }
            case Slot_ByteRef: {
                r = this.compareAllArrayElements(fs1, fs2, len1, i -> Byte.compare(((ByteArray)a1).get(i), ((ByteArray)a2).get(i)), callerTi, callerFi);
                break;
            }
            case Slot_ShortRef: {
                r = this.compareAllArrayElements(fs1, fs2, len1, i -> Short.compare(((ShortArray)a1).get(i), ((ShortArray)a2).get(i)), callerTi, callerFi);
                break;
            }
            case Slot_Int: {
                r = this.compareAllArrayElements(fs1, fs2, len1, i -> Integer.compare(((IntegerArray)a1).get(i), ((IntegerArray)a2).get(i)), callerTi, callerFi);
                break;
            }
            case Slot_LongRef: {
                r = this.compareAllArrayElements(fs1, fs2, len1, i -> Long.compare(((LongArray)a1).get(i), ((LongArray)a2).get(i)), callerTi, callerFi);
                break;
            }
            case Slot_Float: {
                r = this.compareAllArrayElements(fs1, fs2, len1, i -> Integer.compare(CASImpl.float2int(((FloatArray)a1).get(i)), CASImpl.float2int(((FloatArray)a2).get(i))), callerTi, callerFi);
                break;
            }
            case Slot_DoubleRef: {
                r = this.compareAllArrayElements(fs1, fs2, len1, i -> Long.compare(CASImpl.double2long(((DoubleArray)a1).get(i)), CASImpl.double2long(((DoubleArray)a2).get(i))), callerTi, callerFi);
                break;
            }
            case Slot_HeapRef: {
                r = this.compareAllArrayElements(fs1, fs2, len1, i -> this.compareRefs((TOP)((FSArray)a1).get(i), (TOP)((FSArray)a2).get(i), callerTi, callerFi), callerTi, callerFi);
                break;
            }
            case Slot_StrRef: {
                r = this.compareAllArrayElements(fs1, fs2, len1, i -> this.compareStringsWithNull(((StringArray)a1).get(i), ((StringArray)a2).get(i), callerTi, callerFi, i), callerTi, callerFi);
                break;
            }
            default: {
                throw Misc.internalError();
            }
        }
        if (r == 0 || !this.inSortContext) {
            // empty if block
        }
        return r;
    }

    private int compareSlot(TOP fs1, TOP fs2, FeatureImpl fi1, FeatureImpl fi2, TypeImpl ti1) {
        SlotKinds.SlotKind kind = fi1.getSlotKind();
        switch (kind) {
            case Slot_Int: {
                return Integer.compare(fs1._getIntValueNc(fi1), fs2._getIntValueNc(fi2));
            }
            case Slot_Short: {
                return Short.compare(fs1._getShortValueNc(fi1), fs2._getShortValueNc(fi2));
            }
            case Slot_Boolean: {
                return Boolean.compare(fs1._getBooleanValueNc(fi1), fs2._getBooleanValueNc(fi2));
            }
            case Slot_Byte: {
                return Byte.compare(fs1._getByteValueNc(fi1), fs2._getByteValueNc(fi2));
            }
            case Slot_Float: {
                return Integer.compare(CASImpl.float2int(fs1._getFloatValueNc(fi1)), CASImpl.float2int(fs2._getFloatValueNc(fi2)));
            }
            case Slot_HeapRef: {
                return this.compareRefs(fs1._getFeatureValueNc(fi1), fs2._getFeatureValueNc(fi2), ti1, fi1);
            }
            case Slot_StrRef: {
                return this.compareStringsWithNull(fs1._getStringValueNc(fi1), fs2._getStringValueNc(fi2), ti1, fi1, -1);
            }
            case Slot_LongRef: {
                return Long.compare(fs1._getLongValueNc(fi1), fs2._getLongValueNc(fi2));
            }
            case Slot_DoubleRef: {
                return Long.compare(Double.doubleToRawLongBits(fs1._getDoubleValueNc(fi1)), Double.doubleToRawLongBits(fs2._getDoubleValueNc(fi2)));
            }
        }
        Misc.internalError();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int compareRefs(TOP rfs1, TOP rfs2, TypeImpl callerTi, FeatureImpl callerFi) {
        if (this.inSortContext && this.isTypeMapping) {
            if (this.isSrcCas) {
                if (rfs1 != null && this.typeMapper.mapTypeSrc2Tgt(rfs1._getTypeImpl()) == null) {
                    rfs1 = null;
                }
                if (rfs2 != null && this.typeMapper.mapTypeSrc2Tgt(rfs2._getTypeImpl()) == null) {
                    rfs2 = null;
                }
            } else {
                if (rfs1 != null && this.typeMapper.mapTypeTgt2Src(rfs1._getTypeImpl()) == null) {
                    rfs1 = null;
                }
                if (rfs2 != null && this.typeMapper.mapTypeTgt2Src(rfs2._getTypeImpl()) == null) {
                    rfs2 = null;
                }
            }
        }
        if (rfs1 == null) {
            if (rfs2 != null) {
                if (!this.inSortContext && this.isTypeMapping && this.typeMapper.mapTypeTgt2Src(rfs2._getTypeImpl()) == null) {
                    return 0;
                }
                if (!this.inSortContext) {
                    // empty if block
                }
                return -1;
            }
            return 0;
        }
        if (rfs2 == null) {
            if (!this.inSortContext && this.isTypeMapping && this.typeMapper.mapTypeSrc2Tgt(rfs1._getTypeImpl()) == null) {
                return 0;
            }
            if (!this.inSortContext) {
                // empty if block
            }
            return 1;
        }
        if (rfs1 == rfs2) {
            return 0;
        }
        Pair<TOP, TOP> refs = new Pair<TOP, TOP>(rfs1, rfs2);
        Integer prevComp = this.prevCompare.get(refs);
        if (prevComp != null) {
            int v = prevComp;
            if (v == 0) {
                v = this.compareRefResult(rfs1, rfs2);
                if (v != 0 && !this.inSortContext) {
                    this.mismatchFs(rfs1, rfs2, callerTi, callerFi);
                }
                return v;
            }
            if (!this.inSortContext) {
                // empty if block
            }
            return v;
        }
        this.prevCompare.put(refs, 0);
        if (this.prev1.prevCompareTop != null) {
            this.prev1.addTop();
            this.prev2.addTop();
        }
        this.prev1.add(rfs1);
        this.prev2.add(rfs2);
        assert (this.prev1.fsList.size() > 0);
        try {
            int v = this.compareFss(rfs1, rfs2, callerTi, callerFi);
            if (v != 0) {
                this.prevCompare.put(refs, v);
            }
            int n = v;
            return n;
        }
        finally {
            this.prev1.rmvLast(rfs1);
            this.prev2.rmvLast(rfs2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int compareRefResult(TOP rfs1, TOP rfs2) {
        if (!this.inSortContext && rfs1 instanceof EmptyList || this.prev1.size() <= 0) {
            return 0;
        }
        this.prev1.add(rfs1);
        this.prev2.add(rfs2);
        try {
            int r = this.prev1.compareCycleLen(this.prev2);
            if (r != 0) {
                if (!this.inSortContext) {
                    // empty if block
                }
                int n = r;
                return n;
            }
            if (this.prev1.cycleLen > 0) {
                int n = 0;
                return n;
            }
            int n = this.prev1.compareUsize(this.prev2);
            return n;
        }
        finally {
            this.prev1.rmvLast(rfs1);
            this.prev2.rmvLast(rfs2);
        }
    }

    private int compareAllArrayElements(TOP fs1, TOP fs2, int len, IntUnaryOperator c, TypeImpl callerTi, FeatureImpl callerFi) {
        int r = 0;
        for (int i = 0; i < len; ++i) {
            r = c.applyAsInt(i);
            if (r == 0) continue;
            if (!this.inSortContext) {
                this.miscompare_index = i;
                this.mismatchFs(fs1, fs2, "Comparing array of length " + len + ", miscompare on index " + i, callerTi, callerFi);
            }
            return r;
        }
        return 0;
    }

    private int compareStringsWithNull(String s1, String s2, TypeImpl t, FeatureImpl f, int index) {
        String[] scs;
        if (this.isUsingStringCongruenceSets && (scs = this.stringCongruenceSets.get(new ScsKey(t, f, index))) != null && Misc.contains(scs, s1) && Misc.contains(scs, s2)) {
            return 0;
        }
        if (null == s1) {
            return null == s2 ? 0 : -1;
        }
        if (null == s2) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    private void mismatchFsDisplay() {
        String s = this.mismatchSb.toString();
        System.err.println(s);
        this.mismatchSb.setLength(0);
    }

    private void mismatchFs(TOP fs1, TOP fs2, TypeImpl callerTi, FeatureImpl callerFi) {
        if (this.isSkipMismatch) {
            return;
        }
        Pair<TOP, TOP> pair = new Pair<TOP, TOP>(fs1, fs2);
        if (this.prevReport.contains(pair)) {
            if (this.leafErrorReported == null) {
                this.leafErrorReported = pair;
            }
            return;
        }
        this.prevReport.add(pair);
        if (this.leafErrorReported == null) {
            this.leafErrorReported = pair;
            this.mismatchSb.append(String.format("Mismatched Feature Structures refd from %s %s:%n %s%n %s%n", callerTi == null ? "null" : callerTi.getName(), callerFi == null ? "null" : callerFi.getName(), this.ps(fs1), this.ps(fs2)));
        } else {
            TOP ofs1 = (TOP)this.leafErrorReported.t;
            TOP ofs2 = (TOP)this.leafErrorReported.u;
            String s1 = String.format("  from: %s:%d, %s:%d", fs1.getType().getShortName(), fs1._id, fs2.getType().getShortName(), fs2._id);
            this.s1maxLen = Math.max(s1.length() + 4, this.s1maxLen);
            this.mismatchSb.append(String.format("%-" + this.s1maxLen + "s   original mismatch: %s:%d, %s, %d%n", s1, ofs1.getType().getShortName(), ofs1._id, ofs2.getType().getShortName(), ofs2._id));
        }
    }

    private void mismatchFs(TOP fs1, TOP fs2, Feature fi, Feature fi2) {
        if (this.isSkipMismatch) {
            return;
        }
        Pair<TOP, TOP> pair = new Pair<TOP, TOP>(fs1, fs2);
        if (this.prevReport.contains(pair)) {
            if (this.leafErrorReported == null) {
                this.leafErrorReported = pair;
            }
            return;
        }
        this.prevReport.add(pair);
        if (this.leafErrorReported == null) {
            this.leafErrorReported = pair;
            String mapmsg = fi.equals(fi2) ? "" : "which mapped to target feature " + fi2.getShortName() + " ";
            this.mismatchSb.append(String.format("Mismatched Feature Structures in feature %s %s%n %s%n %s%n", fi.getShortName(), mapmsg, this.ps(fs1), this.ps(fs2)));
        } else {
            TOP ofs1 = (TOP)this.leafErrorReported.t;
            TOP ofs2 = (TOP)this.leafErrorReported.u;
            String s1 = String.format("  from: %s:%d, %s:%d", fs1.getType().getShortName(), fs1._id, fs2.getType().getShortName(), fs2._id);
            this.s1maxLen = Math.max(s1.length() + 4, this.s1maxLen);
            this.mismatchSb.append(String.format("%-" + this.s1maxLen + "s   original mismatch: %s:%d, %s, %d%n", s1, ofs1.getType().getShortName(), ofs1._id, ofs2.getType().getShortName(), ofs2._id));
        }
    }

    private void mismatchFs(TOP fs1, TOP fs2, String msg, TypeImpl callerTi, FeatureImpl callerFi) {
        if (this.isSkipMismatch) {
            return;
        }
        Pair<TOP, TOP> pair = new Pair<TOP, TOP>(fs1, fs2);
        if (this.prevReport.contains(pair)) {
            if (this.leafErrorReported == null) {
                this.leafErrorReported = pair;
            }
            return;
        }
        this.prevReport.add(pair);
        if (this.leafErrorReported == null) {
            this.leafErrorReported = pair;
            this.mismatchSb.append(String.format("Mismatched Feature Structures refd from %s %s, %s%n %s%n %s%n", callerTi == null ? "null" : callerTi.getName(), callerFi == null ? "null" : callerFi.getName(), msg, this.ps(fs1), this.ps(fs2)));
        } else {
            TOP ofs1 = (TOP)this.leafErrorReported.t;
            TOP ofs2 = (TOP)this.leafErrorReported.u;
            String s1 = String.format("  from: %s:%d, %s:%d", fs1.getType().getShortName(), fs1._id, fs2.getType().getShortName(), fs2._id);
            this.s1maxLen = Math.max(s1.length() + 4, this.s1maxLen);
            this.mismatchSb.append(String.format("%-" + this.s1maxLen + "s   original mismatch: %s:%d, %s, %d%n", s1, ofs1.getType().getShortName(), ofs1._id, ofs2.getType().getShortName(), ofs2._id));
        }
    }

    private void sort(List<TOP> fss) {
        this.inSortContext = true;
        this.clearPrevFss();
        try {
            fss.sort((afs1, afs2) -> this.sortCompare((TOP)afs1, (TOP)afs2));
        }
        finally {
            this.inSortContext = false;
        }
    }

    private int sortCompare(TOP scFs1, TOP scFs2) {
        if (scFs1 == null) {
            return scFs2 == null ? 0 : 1;
        }
        if (scFs2 == null) {
            return -1;
        }
        this.prev1.clear();
        this.prev2.clear();
        this.prev1.prevCompareTop = scFs1;
        this.prev2.prevCompareTop = scFs2;
        int r = this.compareFss(scFs1, scFs2, null, null);
        this.prev1.prevCompareTop = null;
        this.prev2.prevCompareTop = null;
        if (r == 0) {
            r = Integer.compare(scFs1._id, scFs2._id);
        }
        return r;
    }

    private boolean isTypeInTgt(TOP fs) {
        return !this.isTypeMapping || null != this.typeMapper.mapTypeSrc2Tgt(fs._getTypeImpl());
    }

    private String ps(TOP fs) {
        StringBuilder sb = new StringBuilder();
        fs.prettyPrintShort(sb);
        return sb.toString();
    }

    public static StringBuilder compareNumberOfFSsByType(CAS cas1, CAS cas2) {
        boolean isSame;
        if (IS_SHOW_PROGRESS) {
            System.out.println("comparing the number of FSs by type");
        }
        CASImpl ci1 = (CASImpl)cas1;
        CASImpl ci2 = (CASImpl)cas2;
        Iterator il1 = ci1.indexRepository.streamNonEmptyIndexes(TOP.class).collect(Collectors.toList()).iterator();
        Iterator il2 = ci2.indexRepository.streamNonEmptyIndexes(TOP.class).collect(Collectors.toList()).iterator();
        StringBuilder sb = new StringBuilder();
        StringBuilder sba = new StringBuilder();
        boolean bl = isSame = il1.hasNext() || il2.hasNext();
        while (il1.hasNext() || il2.hasNext()) {
            FsIndex_singletype idx;
            sb.setLength(0);
            String ts1 = null;
            String ts2 = null;
            int sz1 = 0;
            int sz2 = 0;
            if (il1.hasNext()) {
                idx = (FsIndex_singletype)il1.next();
                ts1 = idx.getType().getName();
                sz1 = idx.size();
                sb.append(String.format("%-83s %,5d", ts1, sz1));
            } else {
                isSame = false;
                sb.append(BLANKS_89);
            }
            if (il2.hasNext()) {
                idx = (FsIndex_singletype)il2.next();
                ts2 = idx.getType().getName();
                sz2 = idx.size();
                String m = ts2.equals(ts1) && sz2 == sz1 ? "same" : ts2;
                sb.append(String.format(" %,5d %s", sz2, m));
            } else {
                isSame = false;
            }
            sba.append((CharSequence)sb).append('\n');
            if (!isSame) continue;
            isSame = ts1.equals(ts2) && sz1 == sz2;
        }
        if (isSame) {
            sba.setLength(0);
            sba.append("Same number of types");
        } else {
            sba.append("\nDifferent numbers of types");
        }
        return sba.append('\n');
    }

    private static /* synthetic */ void lambda$sortStringArray$16(String[] a, StringArray stringArray) {
        System.arraycopy(a, 0, stringArray._getTheArray(), 0, stringArray.size());
    }

    private static class Prev {
        private final ArrayList<TOP> fsList = new ArrayList();
        private int cycleLen = -1;
        private int cycleStart = -1;
        TOP prevCompareTop;

        private Prev() {
        }

        void clear() {
            this.fsList.clear();
            this.cycleLen = -1;
            this.cycleStart = -1;
            this.prevCompareTop = null;
        }

        int compareCycleLen(Prev other) {
            return Integer.compare(this.cycleLen, other.cycleLen);
        }

        int compareUsize(Prev other) {
            return Integer.compare(this.usize(), other.usize());
        }

        void rmvLast(TOP fs) {
            int toBeRemoved = this.fsList.size() - 1;
            if (toBeRemoved == -1) {
                System.out.println("debug stop wrong call to rmvLast");
            }
            if (toBeRemoved == this.usize()) {
                if (this.cycleLen < 0) {
                    System.out.println("debug cycleLen");
                    throw Misc.internalError();
                }
                assert (this.cycleLen >= 0);
                assert (this.cycleStart >= 0);
                this.cycleLen = -1;
                this.cycleStart = -1;
            }
            if (toBeRemoved >= 0) {
                this.fsList.remove(toBeRemoved);
            }
        }

        void addTop() {
            this.fsList.add(this.prevCompareTop);
            this.prevCompareTop = null;
        }

        void add(TOP fs) {
            int i;
            if (this.cycleLen < 0 && (i = this.fsList.lastIndexOf(fs)) >= 0) {
                this.cycleLen = this.fsList.size() - i;
                this.cycleStart = i;
            }
            this.fsList.add(fs);
        }

        int size() {
            return this.fsList.size();
        }

        int usize() {
            return this.cycleStart + this.cycleLen;
        }
    }

    private static class ScsKey {
        final TypeImpl type;
        final FeatureImpl feature;
        final int index;

        ScsKey(TypeImpl type, FeatureImpl feature, int index) {
            this.type = type;
            this.feature = feature;
            this.index = index;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.feature == null ? 0 : this.feature.hashCode());
            result = 31 * result + this.index;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ScsKey other = (ScsKey)obj;
            if (this.feature == null ? other.feature != null : !this.feature.equals(other.feature)) {
                return false;
            }
            if (this.index != other.index) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }

    private static class FeatLists {
        final FeatureImpl[][] featsByEase = new FeatureImpl[4][];

        FeatLists(List<FeatureImpl> easy, List<FeatureImpl> easyArrays, List<FeatureImpl> refs, List<FeatureImpl> refArrays) {
            this.featsByEase[0] = easy.toArray(new FeatureImpl[easy.size()]);
            this.featsByEase[1] = easyArrays.toArray(new FeatureImpl[easyArrays.size()]);
            this.featsByEase[2] = refs.toArray(new FeatureImpl[refs.size()]);
            this.featsByEase[3] = refArrays.toArray(new FeatureImpl[refArrays.size()]);
        }
    }
}

