/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.xpath;

import aQute.lib.converter.Converter;
import aQute.lib.xml.XML;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathParser {
    static final DocumentBuilderFactory dbf = XML.newDocumentBuilderFactory();
    static final XPathFactory xpf = XPathFactory.newInstance();
    final XPath xp;
    final Document doc;
    private static final MethodType defaultConstructor = MethodType.methodType(Void.TYPE);

    public XPathParser(File file) throws Exception {
        this.doc = dbf.newDocumentBuilder().parse(file);
        this.xp = xpf.newXPath();
    }

    public <X> void parse(String what, Class<X> type, List<X> map) throws XPathExpressionException, Exception {
        NodeList proxies = (NodeList)this.xp.evaluate(what, this.doc, XPathConstants.NODESET);
        for (int i = 0; i < proxies.getLength(); ++i) {
            Node node = proxies.item(i);
            X dto = XPathParser.newInstance(type);
            this.parse(node, dto);
            map.add(dto);
        }
    }

    private static <T> T newInstance(Class<T> rawClass) throws Exception {
        try {
            return (T)MethodHandles.publicLookup().findConstructor(rawClass, defaultConstructor).invoke();
        }
        catch (Error | Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public <X> void parse(Node node, X dto) throws Exception {
        for (Field f : dto.getClass().getFields()) {
            String value;
            if (Modifier.isStatic(f.getModifiers()) || (value = this.xp.evaluate(f.getName(), node)) == null || value.isEmpty()) continue;
            value = this.processValue(value);
            if (f.getType().isAnnotation()) {
                value = value.toUpperCase();
            }
            Object o = Converter.cnv(f.getGenericType(), (Object)value);
            try {
                MethodHandles.publicLookup().unreflectSetter(f).invoke(dto, o);
            }
            catch (Error | Exception e) {
                throw e;
            }
            catch (Throwable e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    protected String processValue(String value) {
        return value;
    }

    public String parse(String expression) throws Exception {
        return this.xp.evaluate(expression, this.doc);
    }
}

