/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.help.instructions;

import aQute.bnd.help.SyntaxAnnotation;
import aQute.bnd.osgi.Jar;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface LauncherInstructions {
    @SyntaxAnnotation(lead="Options for the export of an executable", example="rejar=STORE,strip=*:OSGI-OPT/*")
    public Executable executable();

    @SyntaxAnnotation(lead="Options for the launch", example="-runoptions eager")
    public Set<RunOption> runoptions();

    public static enum RunOption {
        eager;

    }

    @ProviderType
    public static interface Executable {
        @SyntaxAnnotation(lead="Re-jar the -runpath and -runbundles to the given compression. If not set, bundles are not touched. This should not change the signatures", example="rejar=STORE")
        public Optional<Jar.Compression> rejar();

        @SyntaxAnnotation(lead="Strips files from embedded JARs. The syntax JARPATHMATCH ':' RESOURCEPATHMATCH, both globs.", example="*:OSGI-OPT/*")
        public List<String> strip();

        @SyntaxAnnotation(lead="A pattern to form the location for the bundle. This pattern is processed by the macro processor. @bsn is the bsn, and @version is the version, and @name is the file name. If no pattern is given, the file name is used to make a unique name in the /jar directory. If multiple bundles end up with the same name then the last one wins.The expansion may not contain file separators like /.If the storage area is not cleaned, use the example pattern", example="location='${@bsn}-${version;=;${@version}}.jar'")
        public String location();
    }
}

