/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.codehaus.groovy.classgen.asm.util.TypeUtil;
import org.codehaus.groovy.vmplugin.VMPlugin;
import org.codehaus.groovy.vmplugin.VMPluginFactory;

public class ReflectionUtils {
    private static final Set<String> IGNORED_PACKAGES = new HashSet<String>();
    private static final VMPlugin VM_PLUGIN = VMPluginFactory.getPlugin();
    private static final ClassContextHelper HELPER;

    public static boolean isCallingClassReflectionAvailable() {
        return true;
    }

    public static Class getCallingClass() {
        return ReflectionUtils.getCallingClass(1);
    }

    public static Class getCallingClass(int matchLevel) {
        return ReflectionUtils.getCallingClass(matchLevel, Collections.emptySet());
    }

    public static Class getCallingClass(int matchLevel, Collection<String> extraIgnoredPackages) {
        Class[] classContext = HELPER.getClassContext();
        int depth = 0;
        try {
            Class c;
            while (ReflectionUtils.classShouldBeIgnored(c = classContext[depth++], extraIgnoredPackages) || c != null && matchLevel-- > 0 && depth < classContext.length) {
            }
            return c;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static List<Method> getDeclaredMethods(Class<?> type, String name, Class<?> ... parameterTypes) {
        return ReflectionUtils.doGetMethods(type, name, parameterTypes, Class::getDeclaredMethods);
    }

    public static List<Method> getMethods(Class<?> type, String name, Class<?> ... parameterTypes) {
        return ReflectionUtils.doGetMethods(type, name, parameterTypes, Class::getMethods);
    }

    private static List<Method> doGetMethods(Class<?> type, String name, Class<?>[] parameterTypes, Function<? super Class<?>, ? extends Method[]> f) {
        LinkedList<Method> methodList = new LinkedList<Method>();
        block0: for (Method m : f.apply(type)) {
            Class<?>[] methodParameterTypes;
            if (!m.getName().equals(name) || (methodParameterTypes = m.getParameterTypes()).length != parameterTypes.length) continue;
            int n = methodParameterTypes.length;
            for (int i = 0; i < n; ++i) {
                Class methodParameterType;
                Class parameterType = TypeUtil.autoboxType(parameterTypes[i]);
                if (null == parameterType || !(methodParameterType = TypeUtil.autoboxType(methodParameterTypes[i])).isAssignableFrom(parameterType)) continue block0;
            }
            methodList.add(m);
        }
        return methodList;
    }

    public static boolean checkCanSetAccessible(AccessibleObject accessibleObject, Class<?> caller) {
        return VM_PLUGIN.checkCanSetAccessible(accessibleObject, caller);
    }

    public static boolean checkAccessible(Class<?> callerClass, Class<?> declaringClass, int memberModifiers, boolean allowIllegalAccess) {
        return VM_PLUGIN.checkAccessible(callerClass, declaringClass, memberModifiers, allowIllegalAccess);
    }

    public static boolean trySetAccessible(AccessibleObject ao) {
        try {
            return VM_PLUGIN.trySetAccessible(ao);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Optional<AccessibleObject> makeAccessibleInPrivilegedAction(AccessibleObject ao) {
        return AccessController.doPrivileged(() -> ReflectionUtils.makeAccessible(ao));
    }

    public static Optional<AccessibleObject> makeAccessible(AccessibleObject ao) {
        AccessibleObject[] result = ReflectionUtils.makeAccessible(new AccessibleObject[]{ao});
        return Optional.ofNullable(0 == result.length ? null : result[0]);
    }

    public static AccessibleObject[] makeAccessible(AccessibleObject[] aoa) {
        try {
            AccessibleObject.setAccessible(aoa, true);
            return aoa;
        }
        catch (Throwable outer) {
            ArrayList<AccessibleObject> ret = new ArrayList<AccessibleObject>(aoa.length);
            for (AccessibleObject ao : aoa) {
                boolean accessible = ReflectionUtils.trySetAccessible(ao);
                if (!accessible) continue;
                ret.add(ao);
            }
            return ret.toArray((AccessibleObject[])Array.newInstance(aoa.getClass().getComponentType(), 0));
        }
    }

    private static boolean classShouldBeIgnored(Class c, Collection<String> extraIgnoredPackages) {
        return c != null && (c.isSynthetic() || c.getPackage() != null && (IGNORED_PACKAGES.contains(c.getPackage().getName()) || extraIgnoredPackages.contains(c.getPackage().getName())));
    }

    static {
        IGNORED_PACKAGES.add("groovy.lang");
        IGNORED_PACKAGES.add("org.codehaus.groovy.reflection");
        IGNORED_PACKAGES.add("org.codehaus.groovy.runtime.callsite");
        IGNORED_PACKAGES.add("org.codehaus.groovy.runtime.metaclass");
        IGNORED_PACKAGES.add("org.codehaus.groovy.runtime");
        IGNORED_PACKAGES.add("sun.reflect");
        IGNORED_PACKAGES.add("java.security");
        IGNORED_PACKAGES.add("java.lang.invoke");
        IGNORED_PACKAGES.add("org.codehaus.groovy.vmplugin.v5");
        IGNORED_PACKAGES.add("org.codehaus.groovy.vmplugin.v6");
        IGNORED_PACKAGES.add("org.codehaus.groovy.vmplugin.v7");
        IGNORED_PACKAGES.add("org.codehaus.groovy.vmplugin.v8");
        IGNORED_PACKAGES.add("org.codehaus.groovy.vmplugin.v9");
        HELPER = new ClassContextHelper();
    }

    private static class ClassContextHelper
    extends SecurityManager {
        private ClassContextHelper() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

