/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 */


import org.apache.unomi.api.services.EventService

import java.util.logging.Logger

@Action(id = "updateAddressGroovyAction",
        description = "A test Groovy Action",
        actionExecutor = "groovy:UpdateAddressAction",
        hidden = false,
        systemTags = ["tag1", "tag2"],
        parameters = [@Parameter(id = "param1", type = "string", multivalued = false), @Parameter(id = "param2", type = "string", multivalued =
                false)])
def execute() {
    Logger logger = Logger.getLogger("")
    logger.info("Groovy action to update adress for event type: " + event.getEventType())
    event.profile.properties.address = event.getProperty("address")
    EventService.PROFILE_UPDATED
}