/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.bundle.shell;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.cellar.bundle.shell.BundleCommandSupport;
import org.apache.karaf.cellar.core.CellarSupport;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="cluster", name="bundle-block", description="Change the blocking policy for a bundle")
@Service
public class BlockCommand
extends BundleCommandSupport {
    @Option(name="-in", description="Update the inbound direction", required=false, multiValued=false)
    boolean in = false;
    @Option(name="-out", description="Update the outbound direction", required=false, multiValued=false)
    boolean out = false;
    @Option(name="-whitelist", description="Allow the feature by updating the whitelist (false by default)", required=false, multiValued=false)
    boolean whitelist = false;
    @Option(name="-blacklist", description="Block the feature by updating the blacklist (true by default)", required=false, multiValued=false)
    boolean blacklist = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object doExecute() throws Exception {
        Group group = this.groupManager.findGroupByName(this.groupName);
        if (group == null) {
            System.err.println("Cluster group " + this.groupName + " doesn't exist");
            return null;
        }
        ArrayList<String> patterns = new ArrayList<String>();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            Map<String, BundleCommandSupport.ExtendedBundleState> bundles = this.gatherBundles(false);
            List<String> selectedBundles = this.selector(bundles);
            for (String selectedBundle : selectedBundles) {
                patterns.add(bundles.get(selectedBundle).getLocation());
            }
            if (patterns.isEmpty() && this.ids != null) {
                for (String id : this.ids) {
                    patterns.add(id);
                }
            }
            CellarSupport support = new CellarSupport();
            support.setClusterManager(this.clusterManager);
            support.setGroupManager(this.groupManager);
            support.setConfigurationAdmin(this.configurationAdmin);
            if (!this.in && !this.out) {
                this.in = true;
                this.out = true;
            }
            if (!this.whitelist && !this.blacklist) {
                this.whitelist = true;
                this.blacklist = true;
            }
            if (patterns.isEmpty()) {
                Set list;
                if (this.in) {
                    System.out.println("INBOUND:");
                    if (this.whitelist) {
                        System.out.print("\twhitelist: ");
                        list = support.getListEntries("whitelist", this.groupName, "bundle", EventType.INBOUND);
                        System.out.println(list.toString());
                    }
                    if (this.blacklist) {
                        System.out.print("\tblacklist: ");
                        list = support.getListEntries("blacklist", this.groupName, "bundle", EventType.INBOUND);
                        System.out.println(list.toString());
                    }
                }
                if (this.out) {
                    System.out.println("OUTBOUND:");
                    if (this.whitelist) {
                        System.out.print("\twhitelist: ");
                        list = support.getListEntries("whitelist", this.groupName, "bundle", EventType.OUTBOUND);
                        System.out.println(list.toString());
                    }
                    if (this.blacklist) {
                        System.out.print("\tblacklist: ");
                        list = support.getListEntries("blacklist", this.groupName, "bundle", EventType.OUTBOUND);
                        System.out.println(list.toString());
                    }
                }
            } else {
                for (String pattern : patterns) {
                    System.out.println("Updating blocking policy for " + pattern);
                    if (this.in) {
                        if (this.whitelist) {
                            System.out.println("\tinbound whitelist ...");
                            support.switchListEntry("whitelist", this.groupName, "bundle", EventType.INBOUND, pattern);
                        }
                        if (this.blacklist) {
                            System.out.println("\tinbound blacklist ...");
                            support.switchListEntry("blacklist", this.groupName, "bundle", EventType.INBOUND, pattern);
                        }
                    }
                    if (!this.out) continue;
                    if (this.whitelist) {
                        System.out.println("\toutbound whitelist ...");
                        support.switchListEntry("whitelist", this.groupName, "bundle", EventType.OUTBOUND, pattern);
                    }
                    if (!this.blacklist) continue;
                    System.out.println("\toutbound blacklist ...");
                    support.switchListEntry("blacklist", this.groupName, "bundle", EventType.OUTBOUND, pattern);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return null;
    }
}

