/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.conditions;

import java.util.Map;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionESQueryBuilder;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionESQueryBuilderDispatcher;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class GeoLocationByPointSessionConditionESQueryBuilder
implements ConditionESQueryBuilder {
    public QueryBuilder buildQuery(Condition condition, Map<String, Object> context, ConditionESQueryBuilderDispatcher dispatcher) {
        String name;
        String type = (String)condition.getParameter("type");
        String string = name = condition.getParameter("name") == null ? "location" : (String)condition.getParameter("name");
        if ("circle".equals(type)) {
            Double circleLatitude = ((Number)condition.getParameter("circleLatitude")).doubleValue();
            Double circleLongitude = ((Number)condition.getParameter("circleLongitude")).doubleValue();
            String distance = condition.getParameter("distance").toString();
            if (circleLatitude != null && circleLongitude != null && distance != null) {
                return QueryBuilders.geoDistanceQuery((String)name).point(circleLatitude.doubleValue(), circleLongitude.doubleValue()).distance(distance);
            }
        } else if ("rectangle".equals(type)) {
            Double rectLatitudeNE = (Double)condition.getParameter("rectLatitudeNE");
            Double rectLongitudeNE = (Double)condition.getParameter("rectLongitudeNE");
            Double rectLatitudeSW = (Double)condition.getParameter("rectLatitudeSW");
            Double rectLongitudeSW = (Double)condition.getParameter("rectLongitudeSW");
            if (rectLatitudeNE != null && rectLongitudeNE != null && rectLatitudeSW != null && rectLongitudeSW != null) {
                return QueryBuilders.geoBoundingBoxQuery((String)name).setCorners(rectLatitudeNE.doubleValue(), rectLongitudeNE.doubleValue(), rectLatitudeSW.doubleValue(), rectLongitudeSW.doubleValue());
            }
        }
        return null;
    }
}

