/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.util.Objects;
import javax.money.AbstractContextBuilder;
import javax.money.CurrencyUnit;
import javax.money.RoundingContext;

public final class RoundingContextBuilder
extends AbstractContextBuilder<RoundingContextBuilder, RoundingContext> {
    private RoundingContextBuilder(String provider, String roundingId) {
        Objects.requireNonNull(provider);
        this.set("provider", provider);
        Objects.requireNonNull(roundingId);
        this.set("roundingName", roundingId);
    }

    private RoundingContextBuilder(RoundingContext roundingContext) {
        this.importContext(roundingContext);
    }

    public RoundingContextBuilder setCurrency(CurrencyUnit currencyUnit) {
        Objects.requireNonNull(currencyUnit);
        return (RoundingContextBuilder)this.set(CurrencyUnit.class, currencyUnit);
    }

    @Override
    public RoundingContext build() {
        return new RoundingContext(this);
    }

    public static RoundingContextBuilder of(String provider, String roundingId) {
        return new RoundingContextBuilder(provider, roundingId);
    }

    public static RoundingContextBuilder of(RoundingContext roundingContext) {
        return new RoundingContextBuilder(roundingContext);
    }
}

