/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.migration.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.karaf.shell.api.console.Session;
import org.apache.unomi.shell.migration.service.MigrationConfig;
import org.apache.unomi.shell.migration.service.MigrationConfigProperty;
import org.jline.reader.LineReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationContext {
    private static final Logger logger = LoggerFactory.getLogger(MigrationContext.class);
    private static final Path MIGRATION_FS_HISTORY_FILE = Paths.get(System.getProperty("karaf.data"), "migration", "history.json");
    private final Session session;
    private final MigrationConfig migrationConfig;
    private final ObjectMapper objectMapper;
    private CloseableHttpClient httpClient;
    private Map<String, MigrationStepState> history = new HashMap<String, MigrationStepState>();
    private Map<String, String> userConfig = new HashMap<String, String>();

    protected MigrationContext(Session session, MigrationConfig migrationConfig) {
        this.session = session;
        this.migrationConfig = migrationConfig;
        this.objectMapper = new ObjectMapper();
    }

    protected void tryRecoverFromHistory() throws IOException {
        if (Files.exists(MIGRATION_FS_HISTORY_FILE, new LinkOption[0])) {
            if (this.getConfigBoolean("recoverFromHistory")) {
                this.history = (Map)this.objectMapper.readValue(MIGRATION_FS_HISTORY_FILE.toFile(), (TypeReference)new TypeReference<Map<String, MigrationStepState>>(){});
            } else {
                this.cleanHistory();
            }
        }
    }

    public void performMigrationStep(String stepKey, MigrationStep step) throws Exception {
        if (step == null || stepKey == null) {
            throw new IllegalArgumentException("Migration step and/or key cannot be null");
        }
        MigrationStepState stepState = this.history.get(stepKey);
        if (stepState != MigrationStepState.COMPLETED) {
            this.updateHistoryStep(stepKey, MigrationStepState.STARTED);
            step.execute();
            this.updateHistoryStep(stepKey, MigrationStepState.COMPLETED);
        } else {
            this.printMessage("Migration step: " + stepKey + " already completed in previous run");
        }
    }

    protected void cleanHistory() throws IOException {
        Files.deleteIfExists(MIGRATION_FS_HISTORY_FILE);
    }

    public String askUserWithDefaultAnswer(String msg, String defaultAnswer) throws IOException {
        String answer = this.promptMessageToUser(msg);
        if (StringUtils.isBlank((CharSequence)answer)) {
            return defaultAnswer;
        }
        return answer;
    }

    public String askUserWithAuthorizedAnswer(String msg, List<String> authorizedAnswer) throws IOException {
        String answer;
        while (!authorizedAnswer.contains((answer = this.promptMessageToUser(msg)).toLowerCase())) {
        }
        return answer;
    }

    public String promptMessageToUser(String msg) {
        if (this.session == null) {
            throw new IllegalStateException("Cannot prompt message: " + msg + " to user. (In case you are using the migration tool out of Karaf shell context, please check the migration configuration: org.apache.unomi.migration.cfg)");
        }
        LineReader reader = (LineReader)this.session.get(".jline.reader");
        return reader.readLine(msg, null);
    }

    public void printMessage(String msg) {
        if (this.session == null) {
            logger.info(msg);
        } else {
            PrintStream writer = this.session.getConsole();
            writer.printf("%s: %s%n", new Date(), msg);
        }
    }

    public void printException(String msg, Throwable t) {
        if (this.session == null) {
            logger.error(msg, t);
        } else {
            PrintStream writer = this.session.getConsole();
            writer.println(msg);
            t.printStackTrace(writer);
        }
    }

    public void printException(String msg) {
        if (this.session == null) {
            logger.error(msg);
        } else {
            PrintStream writer = this.session.getConsole();
            writer.println(msg);
        }
    }

    public String getConfigString(String name) throws IOException {
        if ("esAddress".equals(name)) {
            String esAddresses = this.getConfigString("esAddresses");
            boolean sslEnabled = this.getConfigBoolean("esSSLEnabled");
            return (sslEnabled ? "https://" : "http://") + esAddresses.split(",")[0].trim();
        }
        if (this.migrationConfig.getConfig().containsKey(name)) {
            return this.migrationConfig.getConfig().get(name);
        }
        if (this.userConfig.containsKey(name)) {
            return this.userConfig.get(name);
        }
        if (MigrationConfig.configProperties.containsKey(name)) {
            MigrationConfigProperty migrateConfigProperty = MigrationConfig.configProperties.get(name);
            String answer = this.askUserWithDefaultAnswer(migrateConfigProperty.getDescription(), migrateConfigProperty.getDefaultValue());
            this.userConfig.put(name, answer);
            return answer;
        }
        return null;
    }

    public boolean getConfigBoolean(String name) throws IOException {
        if (this.migrationConfig.getConfig().containsKey(name)) {
            return Boolean.parseBoolean(this.migrationConfig.getConfig().get(name));
        }
        if (this.userConfig.containsKey(name)) {
            return Boolean.parseBoolean(this.userConfig.get(name));
        }
        if (MigrationConfig.configProperties.containsKey(name)) {
            MigrationConfigProperty migrateConfigProperty = MigrationConfig.configProperties.get(name);
            boolean answer = this.askUserWithAuthorizedAnswer(migrateConfigProperty.getDescription(), Arrays.asList("yes", "no")).equalsIgnoreCase("yes");
            this.userConfig.put(name, answer ? "true" : "false");
            return answer;
        }
        return false;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    private void updateHistoryStep(String stepKey, MigrationStepState stepState) throws IOException {
        this.printMessage("Migration step: " + stepKey + " reach: " + (Object)((Object)stepState));
        this.history.put(stepKey, stepState);
        this.objectMapper.writeValue(MIGRATION_FS_HISTORY_FILE.toFile(), this.history);
    }

    protected void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public static interface MigrationStep {
        public void execute() throws Exception;
    }

    private static enum MigrationStepState {
        STARTED,
        COMPLETED;

    }
}

