/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.BitSet;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.osgi.framework.BundleContext;

public class FilePersistenceManager
implements PersistenceManager {
    public static final String DEFAULT_CONFIG_DIR = "config";
    public static final String DEFAULT_PERSISTENCE_MANAGER_NAME = "file";
    private static final String FILE_EXT = ".config";
    private static final String TMP_EXT = ".tmp";
    private static final BitSet VALID_PATH_CHARS;
    private final AccessControlContext acc;
    private final File location;
    private final boolean isWin;

    private static boolean equalsNameWithPrefixPlusOneDigit(String name, String prefix) {
        if (name.length() != prefix.length() + 1) {
            return false;
        }
        if (!name.startsWith(prefix)) {
            return false;
        }
        char charAfterPrefix = name.charAt(prefix.length());
        return charAfterPrefix > '0' && charAfterPrefix < '9';
    }

    private static boolean isWinReservedName(String name) {
        String upperCaseName = name.toUpperCase();
        if ("CON".equals(upperCaseName)) {
            return true;
        }
        if ("PRN".equals(upperCaseName)) {
            return true;
        }
        if ("AUX".equals(upperCaseName)) {
            return true;
        }
        if ("CLOCK$".equals(upperCaseName)) {
            return true;
        }
        if ("NUL".equals(upperCaseName)) {
            return true;
        }
        if (FilePersistenceManager.equalsNameWithPrefixPlusOneDigit(upperCaseName, "COM")) {
            return true;
        }
        return FilePersistenceManager.equalsNameWithPrefixPlusOneDigit(upperCaseName, "LPT");
    }

    public FilePersistenceManager(String location) {
        this(null, location);
    }

    public FilePersistenceManager(BundleContext bundleContext, String location) {
        File locationFile;
        String osName = System.getProperty("os.name");
        this.isWin = osName != null && osName.startsWith("Windows");
        this.acc = System.getSecurityManager() != null ? AccessController.getContext() : null;
        if (location == null && bundleContext != null && (locationFile = bundleContext.getDataFile(DEFAULT_CONFIG_DIR)) != null) {
            location = locationFile.getAbsolutePath();
        }
        if (location == null) {
            location = System.getProperty("user.dir") + "/config";
        }
        if (!(locationFile = new File(location)).isAbsolute()) {
            File bundleLocationFile;
            if (bundleContext != null && (bundleLocationFile = bundleContext.getDataFile(locationFile.getPath())) != null) {
                locationFile = bundleLocationFile;
            }
            locationFile = locationFile.getAbsoluteFile();
        }
        if (!locationFile.isDirectory()) {
            if (locationFile.exists()) {
                throw new IllegalArgumentException(location + " is not a directory");
            }
            if (!locationFile.mkdirs()) {
                throw new IllegalArgumentException("Cannot create directory " + location);
            }
        }
        this.location = locationFile;
    }

    String encodePid(String pid) {
        int first;
        pid = pid.replace('.', File.separatorChar);
        if (File.separatorChar != '/') {
            pid = pid.replace('/', File.separatorChar);
        }
        for (first = 0; first < pid.length() && VALID_PATH_CHARS.get(pid.charAt(first)); ++first) {
        }
        if (first < pid.length()) {
            StringBuilder buf = new StringBuilder(pid.substring(0, first));
            for (int i = first; i < pid.length(); ++i) {
                char c = pid.charAt(i);
                if (VALID_PATH_CHARS.get(c)) {
                    buf.append(c);
                    continue;
                }
                this.appendEncoded(buf, c);
            }
            pid = buf.toString();
        }
        if (this.isWin) {
            StringTokenizer segments = new StringTokenizer(pid, File.separator, true);
            StringBuilder pidBuffer = new StringBuilder(pid.length());
            while (segments.hasMoreTokens()) {
                String segment = segments.nextToken();
                if (FilePersistenceManager.isWinReservedName(segment)) {
                    this.appendEncoded(pidBuffer, segment.charAt(0));
                    pidBuffer.append(segment.substring(1));
                    continue;
                }
                pidBuffer.append(segment);
            }
            pid = pidBuffer.toString();
        }
        return pid;
    }

    private void appendEncoded(StringBuilder buf, char c) {
        String val = "000" + Integer.toHexString(c);
        buf.append('%');
        buf.append(val.substring(val.length() - 4));
    }

    public File getLocation() {
        return this.location;
    }

    @Override
    public Enumeration getDictionaries() {
        return new DictionaryEnumeration();
    }

    @Override
    public void delete(String pid) {
        if (System.getSecurityManager() != null) {
            this._privilegedDelete(pid);
        } else {
            this._delete(pid);
        }
    }

    private void _privilegedDelete(final String pid) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                FilePersistenceManager.this._delete(pid);
                return null;
            }
        }, this.acc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _delete(String pid) {
        FilePersistenceManager filePersistenceManager = this;
        synchronized (filePersistenceManager) {
            this.getFile(pid).delete();
        }
    }

    @Override
    public boolean exists(String pid) {
        if (System.getSecurityManager() != null) {
            return this._privilegedExists(pid);
        }
        return this._exists(pid);
    }

    private boolean _privilegedExists(final String pid) {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return FilePersistenceManager.this._exists(pid) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _exists(String pid) {
        FilePersistenceManager filePersistenceManager = this;
        synchronized (filePersistenceManager) {
            return this.getFile(pid).isFile();
        }
    }

    @Override
    public Dictionary load(String pid) throws IOException {
        File cfgFile = this.getFile(pid);
        if (System.getSecurityManager() != null) {
            return this._privilegedLoad(cfgFile);
        }
        return this._load(cfgFile);
    }

    private Dictionary _privilegedLoad(final File cfgFile) throws IOException {
        try {
            Dictionary result = AccessController.doPrivileged(new PrivilegedExceptionAction<Dictionary>(){

                @Override
                public Dictionary run() throws IOException {
                    return FilePersistenceManager.this._load(cfgFile);
                }
            });
            return result;
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Dictionary _load(File cfgFile) throws IOException {
        FilePersistenceManager filePersistenceManager = this;
        synchronized (filePersistenceManager) {
            Dictionary dictionary;
            block11: {
                FileInputStream ins = null;
                try {
                    ins = new FileInputStream(cfgFile);
                    dictionary = ConfigurationHandler.read(ins);
                    if (ins == null) break block11;
                }
                catch (Throwable throwable) {
                    if (ins != null) {
                        try {
                            ((InputStream)ins).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    ((InputStream)ins).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return dictionary;
        }
    }

    @Override
    public void store(String pid, Dictionary props) throws IOException {
        if (System.getSecurityManager() != null) {
            this._privilegedStore(pid, props);
        } else {
            this._store(pid, props);
        }
    }

    private void _privilegedStore(final String pid, final Dictionary props) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException {
                    FilePersistenceManager.this._store(pid, props);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _store(String pid, Dictionary props) throws IOException {
        File tmpFile = null;
        try {
            File cfgFile = this.getFile(pid);
            File cfgDir = cfgFile.getParentFile();
            cfgDir.mkdirs();
            tmpFile = File.createTempFile(cfgFile.getName(), TMP_EXT, cfgDir);
            try (FileOutputStream out = new FileOutputStream(tmpFile);){
                ConfigurationHandler.write(out, props);
            }
            FilePersistenceManager filePersistenceManager = this;
            synchronized (filePersistenceManager) {
                if (cfgFile.exists() && !cfgFile.delete()) {
                    throw new IOException("Cannot remove old file '" + cfgFile + "'; changes in '" + tmpFile + "' cannot be persisted at this time");
                }
                if (!tmpFile.renameTo(cfgFile)) {
                    throw new IOException("Failed to rename configuration file from '" + tmpFile + "' to '" + cfgFile);
                }
                tmpFile = null;
            }
        }
        finally {
            if (tmpFile != null && tmpFile.exists()) {
                tmpFile.delete();
            }
        }
    }

    File getFile(String pid) {
        return new File(this.location, this.encodePid(pid) + FILE_EXT);
    }

    static {
        int i;
        VALID_PATH_CHARS = new BitSet();
        for (i = 97; i <= 122; ++i) {
            VALID_PATH_CHARS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            VALID_PATH_CHARS.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            VALID_PATH_CHARS.set(i);
        }
        VALID_PATH_CHARS.set(File.separatorChar);
        VALID_PATH_CHARS.set(32);
        VALID_PATH_CHARS.set(45);
        VALID_PATH_CHARS.set(95);
    }

    class DictionaryEnumeration
    implements Enumeration {
        private Stack<File> dirStack = new Stack();
        private File[] fileList = null;
        private int idx = 0;
        private Dictionary next;

        DictionaryEnumeration() {
            this.dirStack.push(FilePersistenceManager.this.getLocation());
            this.next = this.seek();
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Dictionary toReturn = this.next;
            this.next = this.seek();
            return toReturn;
        }

        private Dictionary seek() {
            if (System.getSecurityManager() != null) {
                return this._privilegedSeek();
            }
            return this._seek();
        }

        protected Dictionary _privilegedSeek() {
            Dictionary result = AccessController.doPrivileged(new PrivilegedAction<Dictionary>(){

                @Override
                public Dictionary run() {
                    return DictionaryEnumeration.this._seek();
                }
            });
            return result;
        }

        protected Dictionary _seek() {
            while (this.fileList != null && this.idx < this.fileList.length || !this.dirStack.isEmpty()) {
                File cfgFile;
                if (this.fileList == null || this.idx >= this.fileList.length) {
                    File dir = this.dirStack.pop();
                    this.fileList = dir.listFiles();
                    this.idx = 0;
                    continue;
                }
                if ((cfgFile = this.fileList[this.idx++]).isFile() && !cfgFile.getName().endsWith(FilePersistenceManager.TMP_EXT)) {
                    try {
                        Dictionary dict = FilePersistenceManager.this._load(cfgFile);
                        if (dict.get("service.pid") != null && !cfgFile.equals(FilePersistenceManager.this.getFile((String)dict.get("service.pid")))) continue;
                        return dict;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
                if (!cfgFile.isDirectory()) continue;
                this.dirStack.push(cfgFile);
            }
            return null;
        }
    }
}

