/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedEndpointMBean;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.JsonSchemaHelper;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed Endpoint")
public class ManagedEndpoint
implements ManagedInstance,
ManagedEndpointMBean {
    private final Endpoint endpoint;

    public ManagedEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void init(ManagementStrategy strategy) {
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getCamelId() {
        return this.endpoint.getCamelContext().getName();
    }

    @Override
    public String getCamelManagementName() {
        return this.endpoint.getCamelContext().getManagementName();
    }

    @Override
    public String getEndpointUri() {
        return this.endpoint.getEndpointUri();
    }

    @Override
    public boolean isSingleton() {
        return this.endpoint.isSingleton();
    }

    @Override
    public String getState() {
        if (this.endpoint instanceof StatefulService) {
            ServiceStatus status = ((StatefulService)((Object)this.endpoint)).getStatus();
            return status.name();
        }
        return ServiceStatus.Started.name();
    }

    @Override
    public String informationJson() {
        return this.endpoint.getCamelContext().explainEndpointJson(this.getEndpointUri(), true);
    }

    @Override
    public TabularData explain(boolean allOptions) {
        try {
            String json = this.endpoint.getCamelContext().explainEndpointJson(this.getEndpointUri(), allOptions);
            List<Map<String, String>> rows = JsonSchemaHelper.parseJsonSchema("properties", json, true);
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.explainEndpointTabularType());
            for (Map<String, String> row : rows) {
                String name = row.get("name");
                String kind = row.get("kind");
                String group = row.get("group") != null ? row.get("group") : "";
                String label = row.get("label") != null ? row.get("label") : "";
                String type = row.get("type");
                String javaType = row.get("javaType");
                String deprecated = row.get("deprecated") != null ? row.get("deprecated") : "";
                String secret = row.get("secret") != null ? row.get("secret") : "";
                String value = row.get("value") != null ? row.get("value") : "";
                String defaultValue = row.get("defaultValue") != null ? row.get("defaultValue") : "";
                String description = row.get("description") != null ? row.get("description") : "";
                CompositeType ct = CamelOpenMBeanTypes.explainEndpointsCompositeType();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"option", "kind", "group", "label", "type", "java type", "deprecated", "secret", "value", "default value", "description"}, new Object[]{name, kind, group, label, type, javaType, deprecated, secret, value, defaultValue, description});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public Endpoint getInstance() {
        return this.endpoint;
    }
}

