/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.ParsedMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTerms;

public abstract class ParsedSignificantTerms
extends ParsedMultiBucketAggregation<ParsedBucket>
implements SignificantTerms {
    private Map<String, ParsedBucket> bucketMap;
    protected long subsetSize;
    protected long supersetSize;

    protected long getSubsetSize() {
        return this.subsetSize;
    }

    protected long getSupersetSize() {
        return this.supersetSize;
    }

    @Override
    public List<? extends SignificantTerms.Bucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public SignificantTerms.Bucket getBucketByKey(String term) {
        if (this.bucketMap == null) {
            this.bucketMap = this.buckets.stream().collect(Collectors.toMap(MultiBucketsAggregation.Bucket::getKeyAsString, Function.identity()));
        }
        return this.bucketMap.get(term);
    }

    @Override
    public Iterator<SignificantTerms.Bucket> iterator() {
        return this.buckets.stream().map(bucket -> bucket).collect(Collectors.toList()).iterator();
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.subsetSize);
        builder.field("bg_count", this.supersetSize);
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (SignificantTerms.Bucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    static <T extends ParsedSignificantTerms> T parseSignificantTermsXContent(CheckedSupplier<T, IOException> aggregationSupplier, String name) throws IOException {
        ParsedSignificantTerms aggregation = (ParsedSignificantTerms)aggregationSupplier.get();
        aggregation.setName(name);
        for (ParsedBucket bucket : aggregation.buckets) {
            bucket.subsetSize = aggregation.subsetSize;
            bucket.supersetSize = aggregation.supersetSize;
        }
        return (T)aggregation;
    }

    static void declareParsedSignificantTermsFields(ObjectParser<? extends ParsedSignificantTerms, Void> objectParser, CheckedFunction<XContentParser, ParsedBucket, IOException> bucketParser) {
        ParsedSignificantTerms.declareMultiBucketAggregationFields(objectParser, bucketParser::apply, bucketParser::apply);
        objectParser.declareLong((parsedTerms, value) -> {
            parsedTerms.subsetSize = value;
        }, Aggregation.CommonFields.DOC_COUNT);
        objectParser.declareLong((parsedTerms, value) -> {
            parsedTerms.supersetSize = value;
        }, new ParseField("bg_count", new String[0]));
    }

    public static abstract class ParsedBucket
    extends ParsedMultiBucketAggregation.ParsedBucket
    implements SignificantTerms.Bucket {
        protected long subsetDf;
        protected long subsetSize;
        protected long supersetDf;
        protected long supersetSize;
        protected double score;

        @Override
        public long getDocCount() {
            return this.getSubsetDf();
        }

        @Override
        public long getSubsetDf() {
            return this.subsetDf;
        }

        @Override
        public long getSupersetDf() {
            return this.supersetDf;
        }

        @Override
        public double getSignificanceScore() {
            return this.score;
        }

        @Override
        public long getSupersetSize() {
            return this.supersetSize;
        }

        @Override
        public long getSubsetSize() {
            return this.subsetSize;
        }

        @Override
        public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.keyToXContent(builder);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
            builder.field("score", this.getSignificanceScore());
            builder.field("bg_count", this.getSupersetDf());
            this.getAggregations().toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        @Override
        protected abstract XContentBuilder keyToXContent(XContentBuilder var1) throws IOException;

        static <B extends ParsedBucket> B parseSignificantTermsBucketXContent(XContentParser parser, B bucket, CheckedBiConsumer<XContentParser, B, IOException> keyConsumer) throws IOException {
            XContentParser.Token token;
            ArrayList aggregations = new ArrayList();
            String currentFieldName = parser.currentName();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (Aggregation.CommonFields.KEY_AS_STRING.getPreferredName().equals(currentFieldName)) {
                        bucket.setKeyAsString(parser.text());
                        continue;
                    }
                    if (Aggregation.CommonFields.KEY.getPreferredName().equals(currentFieldName)) {
                        keyConsumer.accept(parser, bucket);
                        continue;
                    }
                    if (Aggregation.CommonFields.DOC_COUNT.getPreferredName().equals(currentFieldName)) {
                        long value;
                        bucket.subsetDf = value = parser.longValue();
                        bucket.setDocCount(value);
                        continue;
                    }
                    if ("score".equals(currentFieldName)) {
                        bucket.score = parser.doubleValue();
                        continue;
                    }
                    if (!"bg_count".equals(currentFieldName)) continue;
                    bucket.supersetDf = parser.longValue();
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                XContentParserUtils.parseTypedKeysObject(parser, "#", Aggregation.class, aggregations::add);
            }
            bucket.setAggregations(new Aggregations(aggregations));
            return bucket;
        }
    }
}

