/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.util.repository;

import aQute.bnd.service.RepositoryPlugin;
import aQute.lib.io.IO;
import aQute.libg.reporter.slf4j.Slf4jReporter;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.Map;
import org.osgi.util.promise.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadListenerPromise {
    private static final Logger logger = LoggerFactory.getLogger(DownloadListenerPromise.class);
    private final String task;
    private File linked;

    public DownloadListenerPromise(Reporter r, String task, Promise<File> promise, Map<String, String> attrs, RepositoryPlugin.DownloadListener ... downloadListeners) {
        Reporter reporter = Slf4jReporter.getAlternative(DownloadListenerPromise.class, r);
        this.task = task;
        logger.debug("{}: starting", (Object)task);
        promise.thenAccept(file -> {
            if (file == null) {
                throw new FileNotFoundException(task);
            }
            logger.debug("{}: success {}", (Object)this, file);
            if (this.linked != null) {
                IO.createSymbolicLinkOrCopy(this.linked, file);
            }
            for (RepositoryPlugin.DownloadListener dl : downloadListeners) {
                try {
                    dl.success((File)file, attrs);
                }
                catch (Throwable e) {
                    reporter.warning("%s: Success callback failed to %s: %s", this, dl, e);
                }
            }
        }).onFailure(failure -> {
            logger.debug("{}: failure", (Object)this, failure);
            String reason = failure.toString();
            for (RepositoryPlugin.DownloadListener dl : downloadListeners) {
                try {
                    dl.failure(null, reason);
                }
                catch (Throwable e) {
                    reporter.warning("%s: Fail callback failed to %s: %s", this, dl, e);
                }
            }
        });
    }

    public DownloadListenerPromise(Reporter r, String task, Promise<File> promise, RepositoryPlugin.DownloadListener ... downloadListeners) {
        this(r, task, promise, Collections.emptyMap(), downloadListeners);
    }

    public String toString() {
        return this.task;
    }

    public void linkTo(File linked) {
        this.linked = linked;
    }
}

