/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ControlledShutdownResponse;

public class ControlledShutdownRequest
extends AbstractRequest {
    private static final String BROKER_ID_KEY_NAME = "broker_id";
    private int brokerId;

    private ControlledShutdownRequest(int brokerId, short version) {
        super(version);
        this.brokerId = brokerId;
    }

    public ControlledShutdownRequest(Struct struct, short version) {
        super(version);
        this.brokerId = struct.getInt(BROKER_ID_KEY_NAME);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                throw new IllegalArgumentException("Version 0 is not supported. It is only supported by the Scala request class for controlled shutdown");
            }
            case 1: {
                return new ControlledShutdownResponse(Errors.forException(e), Collections.emptySet());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.CONTROLLED_SHUTDOWN_KEY.latestVersion()));
    }

    public int brokerId() {
        return this.brokerId;
    }

    public static ControlledShutdownRequest parse(ByteBuffer buffer, short version) {
        return new ControlledShutdownRequest(ApiKeys.CONTROLLED_SHUTDOWN_KEY.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.CONTROLLED_SHUTDOWN_KEY.requestSchema(this.version()));
        struct.set(BROKER_ID_KEY_NAME, (Object)this.brokerId);
        return struct;
    }

    public static class Builder
    extends AbstractRequest.Builder<ControlledShutdownRequest> {
        private final int brokerId;

        public Builder(int brokerId) {
            super(ApiKeys.CONTROLLED_SHUTDOWN_KEY);
            this.brokerId = brokerId;
        }

        @Override
        public ControlledShutdownRequest build(short version) {
            return new ControlledShutdownRequest(this.brokerId, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=ControlledShutdownRequest").append(", brokerId=").append(this.brokerId).append(")");
            return bld.toString();
        }
    }
}

