/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Consent;
import org.apache.unomi.api.ConsentStatus;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.SystemPropertiesItem;

public class Profile
extends Item
implements SystemPropertiesItem {
    public static final String ITEM_TYPE = "profile";
    private static final long serialVersionUID = -7409439322939712238L;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Map<String, Object> systemProperties = new HashMap<String, Object>();
    private Set<String> segments = new HashSet<String>();
    private Map<String, Integer> scores;
    @Deprecated
    private String mergedWith;
    private Map<String, Consent> consents = new LinkedHashMap<String, Consent>();

    public Profile() {
    }

    public Profile(String profileId) {
        super(profileId);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Object getNestedProperty(String name) {
        if (!name.contains(".")) {
            return this.getProperty(name);
        }
        Map properties = this.properties;
        String[] propertyPath = StringUtils.substringBeforeLast((String)name, (String)".").split("\\.");
        String propertyName = StringUtils.substringAfterLast((String)name, (String)".");
        for (String property : propertyPath) {
            if ((properties = (Map)properties.get(property)) != null) continue;
            return null;
        }
        return properties.get(propertyName);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public Map<String, Object> getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Map<String, Object> systemProperties) {
        this.systemProperties = systemProperties;
    }

    public Object setSystemProperty(String key, Object value) {
        if (this.systemProperties == null) {
            this.systemProperties = new LinkedHashMap<String, Object>();
        }
        return this.systemProperties.put(key, value);
    }

    @Override
    @XmlTransient
    public String getScope() {
        return "systemscope";
    }

    public Set<String> getSegments() {
        return this.segments;
    }

    public void setSegments(Set<String> segments) {
        this.segments = segments;
    }

    @Deprecated
    public String getMergedWith() {
        return this.mergedWith;
    }

    @Deprecated
    public void setMergedWith(String mergedWith) {
        this.mergedWith = mergedWith;
    }

    public Map<String, Integer> getScores() {
        return this.scores;
    }

    public void setScores(Map<String, Integer> scores) {
        this.scores = scores;
    }

    public Map<String, Consent> getConsents() {
        return this.consents;
    }

    @XmlTransient
    public boolean isAnonymousProfile() {
        Boolean anonymous = (Boolean)this.getSystemProperties().get("isAnonymousProfile");
        return anonymous != null && anonymous != false;
    }

    @XmlTransient
    public boolean setConsent(Consent consent) {
        if (ConsentStatus.REVOKED.equals((Object)consent.getStatus())) {
            if (consent.getScope() != null) {
                if (this.consents.containsKey(consent.getScope() + "/" + consent.getTypeIdentifier())) {
                    this.consents.remove(consent.getScope() + "/" + consent.getTypeIdentifier());
                    return true;
                }
            } else if (this.consents.containsKey(consent.getTypeIdentifier())) {
                this.consents.remove(consent.getTypeIdentifier());
                return true;
            }
            return false;
        }
        if (consent.getScope() != null) {
            this.consents.put(consent.getScope() + "/" + consent.getTypeIdentifier(), consent);
        } else {
            this.consents.put(consent.getTypeIdentifier(), consent);
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Profile{");
        sb.append("properties=").append(this.properties);
        sb.append(", systemProperties=").append(this.systemProperties);
        sb.append(", segments=").append(this.segments);
        sb.append(", scores=").append(this.scores);
        sb.append(", consents=").append(this.consents);
        sb.append(", itemId='").append(this.itemId).append('\'');
        sb.append(", itemType='").append(this.itemType).append('\'');
        sb.append(", scope='").append(this.scope).append('\'');
        sb.append(", version=").append(this.version);
        sb.append('}');
        return sb.toString();
    }
}

