/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.web.commands;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.Col;
import org.apache.karaf.shell.support.table.ShellTable;
import org.apache.karaf.web.WebBundle;
import org.apache.karaf.web.WebContainerService;

@Command(scope="web", name="list", description="Lists details for war bundles.")
@Service
public class List
implements Action {
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;
    @Reference
    private WebContainerService webContainerService;

    public void setWebContainerService(WebContainerService webContainerService) {
        this.webContainerService = webContainerService;
    }

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column(new Col("ID"));
        table.column(new Col("State"));
        table.column(new Col("Web-State"));
        table.column(new Col("Level"));
        table.column(new Col("Web-ContextPath"));
        table.column(new Col("Name"));
        java.util.List<WebBundle> webBundles = this.webContainerService.list();
        if (webBundles != null && !webBundles.isEmpty()) {
            for (WebBundle webBundle : webBundles) {
                table.addRow().addContent(new Object[]{webBundle.getBundleId(), webBundle.getState(), webBundle.getWebState(), webBundle.getLevel(), webBundle.getContextPath(), webBundle.getName()});
            }
        }
        table.print(System.out, !this.noFormat);
        return null;
    }
}

