package org.apache.dvsl;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.tools.ant.Task;

import org.apache.velocity.runtime.log.LogSystem;

/**
 * Implementation of a logger to output messages via an Ant Task's log
 * method.  Velocity log levels are mapped to corresponding log levels
 * defined in Ant's logging API.  The end result is messages will only
 * be output if Ant log level is high enough.
 *
 * @author    <a href="mailto:billb@progress.com">Bill Burton</a>
 * @version   $Id: AntLogSystem.java 538000 2007-05-14 21:59:05Z cbrisson $
 * @deprecated Use AntLogChute instead.
 */
public class AntLogSystem extends AntLogChute implements LogSystem
{
    public AntLogSystem(Task task) {
        super(task);
    }

    /**
     * <p>
     * Log Velocity messages through the Ant Task log method.  The mapping of logging
     * levels from Velocity to Ant is as follows:
     * </p>
     *
     * <blockquote><pre>
     * Velocity Level      --&gt;  Ant Level
     * LogSystem.DEBUG_ID  --&gt;  Project.MSG_DEBUG
     * LogSystem.INFO_ID   --&gt;  Project.MSG_VERBOSE
     * LogSystem.WARN_ID   --&gt;  Project.MSG_WARN
     * LogSystem.ERROR_ID  --&gt;  Project.MSG_ERR
     * </pre></blockquote>
     *
     * @param level    severity level
     * @param message  complete error message
     * @see   org.apache.velocity.runtime.log.LogSystem
     * @see   org.apache.tools.ant.Task#log(String, int)
     * @deprecated use AntLogChute
     */
    public void logVelocityMessage( int level, String message )
    {
        log(level,message);
    }
}
