/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketTesterHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(WicketTesterHelper.class);

    public static List<ComponentData> getComponentData(Page page) {
        final ArrayList<ComponentData> data = new ArrayList<ComponentData>();
        if (page != null) {
            page.visitChildren(new IVisitor<Component, Void>(){

                public void component(Component component, IVisit<Void> visit) {
                    ComponentData object = new ComponentData();
                    String name = component.getClass().getName();
                    if (name.indexOf("$") > 0) {
                        name = component.getClass().getSuperclass().getName();
                    }
                    name = Strings.lastPathComponent((String)name, (char)':');
                    object.path = component.getPageRelativePath();
                    object.type = name;
                    object.isVisible = component.isVisible();
                    object.isEnabled = component.isEnabled();
                    try {
                        object.value = component.getDefaultModelObjectAsString();
                    }
                    catch (Exception e) {
                        object.value = e.getMessage();
                    }
                    data.add(object);
                }
            });
        }
        return data;
    }

    public static void assertEquals(Collection<?> expects, Collection<?> actuals) {
        if (actuals.size() != expects.size() || !expects.containsAll(actuals) || !actuals.containsAll(expects)) {
            WicketTesterHelper.failWithVerboseMessage(expects, actuals);
        }
    }

    public static void failWithVerboseMessage(Collection<?> expects, Collection<?> actuals) {
        Assert.fail((String)("\nexpect (" + expects.size() + "):\n" + WicketTesterHelper.asLined(expects) + "\nbut was (" + actuals.size() + "):\n" + WicketTesterHelper.asLined(actuals)));
    }

    public static String asLined(Collection<?> objects) {
        StringBuilder lined = new StringBuilder();
        Iterator<?> iter = objects.iterator();
        while (iter.hasNext()) {
            String objectString = iter.next().toString();
            lined.append("   ");
            lined.append(objectString);
            if (!iter.hasNext()) continue;
            lined.append('\n');
        }
        return lined.toString();
    }

    public static AjaxEventBehavior findAjaxEventBehavior(Component component, String event) {
        List<AjaxEventBehavior> behaviors = WicketTesterHelper.findAjaxEventBehaviors(component, event);
        AjaxEventBehavior behavior = null;
        if (behaviors != null && !behaviors.isEmpty()) {
            behavior = behaviors.get(0);
        }
        return behavior;
    }

    public static List<AjaxEventBehavior> findAjaxEventBehaviors(Component component, String event) {
        String[] eventNames;
        Args.notEmpty((CharSequence)event, (String)"event");
        ArrayList<AjaxEventBehavior> behaviors = new ArrayList<AjaxEventBehavior>();
        for (String eventName : eventNames = Strings.split((String)event, (char)' ')) {
            if (eventName.startsWith("on")) {
                String shortName = eventName.substring(2);
                LOGGER.warn("Since version 6.0.0 Wicket uses JavaScript event registration so there is no need of the leading 'on' in the event name '{}'. Please use just '{}'. Wicket 8.x won't manipulate the provided event names so the leading 'on' may break your application.", (Object)eventName, (Object)shortName);
                eventName = shortName;
            }
            for (Behavior behavior : component.getBehaviors()) {
                String[] behaviorEventNames;
                if (!(behavior instanceof AjaxEventBehavior)) continue;
                String behaviorEvent = ((AjaxEventBehavior)behavior).getEvent();
                for (String behaviorEventName : behaviorEventNames = Strings.split((String)behaviorEvent, (char)' ')) {
                    if (behaviorEventName.startsWith("on")) {
                        behaviorEventName = behaviorEventName.substring(2);
                    }
                    if (!eventName.equalsIgnoreCase(behaviorEventName)) continue;
                    behaviors.add((AjaxEventBehavior)behavior);
                }
            }
        }
        return behaviors;
    }

    public static Behavior findBehavior(Component component, Class<? extends Behavior> behaviorClass) {
        Iterator<? extends Behavior> i$ = component.getBehaviors(behaviorClass).iterator();
        if (i$.hasNext()) {
            Behavior behavior = i$.next();
            return behavior;
        }
        return null;
    }

    public static class ComponentData
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        public String path;
        public String type;
        public String value;
        public boolean isVisible;
        public boolean isEnabled;
    }
}

