/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import junit.framework.AssertionFailedError;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.feedback.ExactLevelFeedbackMessageFilter;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessagesModel;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ValidationErrorFeedback;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.tester.BaseWicketTester;
import org.apache.wicket.util.tester.DiffUtil;
import org.apache.wicket.util.tester.Result;
import org.apache.wicket.util.tester.WicketTesterHelper;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketTester
extends BaseWicketTester {
    private static final Logger log = LoggerFactory.getLogger(WicketTester.class);

    public WicketTester() {
    }

    public WicketTester(Class<? extends Page> homePage) {
        super(homePage);
    }

    public WicketTester(WebApplication application) {
        super(application);
    }

    public WicketTester(WebApplication application, String path) {
        super(application, path);
    }

    public WicketTester(WebApplication application, ServletContext servletCtx) {
        super(application, servletCtx);
    }

    public WicketTester(WebApplication application, boolean init) {
        super(application, init);
    }

    public WicketTester(WebApplication application, ServletContext servletCtx, boolean init) {
        super(application, servletCtx, init);
    }

    public void assertAjaxLocation() {
        String ajaxLocation;
        if (null != this.getLastResponse().getHeader("Location")) {
            Assert.fail((String)"Location header should *not* be present when using Ajax");
        }
        if (null == (ajaxLocation = this.getLastResponse().getHeader("Ajax-Location"))) {
            throw new AssertionFailedError("Ajax-Location header should be present when using Ajax");
        }
        int statusCode = this.getLastResponse().getStatus();
        if (statusCode != 200) {
            throw new AssertionFailedError("Expected HTTP status code to be 200 (OK)");
        }
    }

    public void assertComponent(String path, Class<? extends Component> expectedComponentClass) {
        this.assertResult(this.isComponent(path, expectedComponentClass));
    }

    public void assertComponentOnAjaxResponse(Component component) {
        Result result = this.isComponentOnAjaxResponse(component);
        this.assertResult(result);
    }

    public void assertComponentOnAjaxResponse(String componentPath) {
        Component component = this.getComponentFromLastRenderedPage(componentPath, false);
        this.assertComponentOnAjaxResponse(component);
    }

    public void assertContains(String pattern) {
        this.assertResult(this.ifContains(pattern));
    }

    public void assertContainsNot(String pattern) {
        this.assertResult(this.ifContainsNot(pattern));
    }

    public void assertMarkupVariation(Component component, String expectedVariation) {
        Result result = Result.PASS;
        IMarkupFragment markup = this.getMarkupFragment(component);
        String actualVariation = markup.getMarkupResourceStream().getVariation();
        if (!Objects.equal((Object)expectedVariation, (Object)actualVariation)) {
            result = Result.fail(String.format("Wrong variation for component '%s'. Actual: '%s', expected: '%s'", component.getPageRelativePath(), actualVariation, expectedVariation));
        }
        this.assertResult(result);
    }

    public void assertMarkupStyle(Component component, String expectedStyle) {
        Result result = Result.PASS;
        IMarkupFragment markup = this.getMarkupFragment(component);
        String actualStyle = markup.getMarkupResourceStream().getStyle();
        if (!Objects.equal((Object)expectedStyle, (Object)actualStyle)) {
            result = Result.fail(String.format("Wrong style for component '%s'. Actual: '%s', expected: '%s'", component.getPageRelativePath(), actualStyle, expectedStyle));
        }
        this.assertResult(result);
    }

    public void assertMarkupLocale(Component component, Locale expectedLocale) {
        Result result = Result.PASS;
        IMarkupFragment markup = this.getMarkupFragment(component);
        Locale actualLocale = markup.getMarkupResourceStream().getLocale();
        if (!Objects.equal((Object)expectedLocale, (Object)actualLocale)) {
            result = Result.fail(String.format("Wrong locale for component '%s'. Actual: '%s', expected: '%s'", component.getPageRelativePath(), actualLocale, expectedLocale));
        }
        this.assertResult(result);
    }

    private IMarkupFragment getMarkupFragment(Component component) {
        IMarkupFragment markup = null;
        if (component instanceof MarkupContainer) {
            markup = ((MarkupContainer)component).getAssociatedMarkup();
        }
        if (markup == null) {
            markup = component.getMarkup();
        }
        if (markup == null) {
            throw new AssertionFailedError(String.format("Cannot find the markup of component: %s", component.getPageRelativePath()));
        }
        return markup;
    }

    public void assertErrorMessages(Serializable ... expectedErrorMessages) {
        this.assertFeedbackMessages(new ExactLevelFeedbackMessageFilter(400), expectedErrorMessages);
    }

    public void assertInfoMessages(Serializable ... expectedInfoMessages) {
        this.assertFeedbackMessages(new ExactLevelFeedbackMessageFilter(200), expectedInfoMessages);
    }

    public void assertFeedbackMessages(IFeedbackMessageFilter filter, Serializable ... expectedMessages) {
        List<FeedbackMessage> feedbackMessages = this.getFeedbackMessages(filter);
        List<Serializable> actualMessages = this.getActualFeedbackMessages(feedbackMessages);
        WicketTesterHelper.assertEquals(Arrays.asList(expectedMessages), actualMessages);
    }

    public void assertComponentFeedbackMessage(Component component, String key, IModel<?> model, IFeedbackMessageFilter filter) {
        Args.notNull((Object)key, (String)"key");
        String expectedMessage = this.getApplication().getResourceSettings().getLocalizer().getString(key, component, model);
        List<FeedbackMessage> feedbackMessages = this.getFeedbackMessages(filter);
        List<Serializable> actualMessages = this.getActualFeedbackMessages(feedbackMessages);
        Assert.assertTrue((String)String.format("Feedback message with key '%s' cannot be found in %s", key, actualMessages), (boolean)actualMessages.contains(expectedMessage));
    }

    private List<Serializable> getActualFeedbackMessages(List<FeedbackMessage> feedbackMessages) {
        ArrayList<Serializable> actualMessages = new ArrayList<Serializable>();
        for (FeedbackMessage feedbackMessage : feedbackMessages) {
            Serializable message = feedbackMessage.getMessage();
            if (message instanceof ValidationErrorFeedback) {
                actualMessages.add((Serializable)((Object)message.toString()));
                continue;
            }
            actualMessages.add(message);
        }
        return actualMessages;
    }

    public void assertFeedback(String path, Serializable ... messages) {
        FeedbackPanel fbp = (FeedbackPanel)this.getComponentFromLastRenderedPage(path);
        FeedbackMessagesModel model = fbp.getFeedbackMessagesModel();
        List renderedMessages = (List)model.getObject();
        if (renderedMessages == null) {
            Assert.fail((String)String.format("feedback panel at path [%s] returned null messages", path));
        }
        if (messages.length != renderedMessages.size()) {
            Assert.fail((String)String.format("you expected '%d' messages for the feedback panel [%s], but there were actually '%d'", messages.length, path, renderedMessages.size()));
        }
        for (int i = 0; i < messages.length && i < renderedMessages.size(); ++i) {
            Serializable expected = messages[i];
            boolean found = false;
            for (FeedbackMessage actual : renderedMessages) {
                if (!Objects.equal((Object)expected, (Object)actual.getMessage())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.assertResult(Result.fail("Missing expected feedback message: " + expected));
        }
    }

    public void assertInvisible(String path) {
        this.assertResult(this.isInvisible(path));
    }

    public void assertLabel(String path, String expectedLabelText) {
        Label label = (Label)this.getComponentFromLastRenderedPage(path);
        Assert.assertEquals((Object)expectedLabelText, (Object)label.getDefaultModelObjectAsString());
    }

    public void assertModelValue(String path, Object expectedValue) {
        Component component = this.getComponentFromLastRenderedPage(path);
        Assert.assertEquals((Object)expectedValue, (Object)component.getDefaultModelObject());
    }

    @Override
    public void assertListView(String path, List<?> expectedList) {
        ListView listView = (ListView)this.getComponentFromLastRenderedPage(path);
        WicketTesterHelper.assertEquals(expectedList, listView.getList());
    }

    public void assertNoErrorMessage() {
        this.assertNoFeedbackMessage(400);
    }

    public void assertNoInfoMessage() {
        this.assertNoFeedbackMessage(200);
    }

    public void assertNoFeedbackMessage(int level) {
        Result result = this.hasNoFeedbackMessage(level);
        Assert.assertFalse((String)result.getMessage(), (boolean)result.wasFailed());
    }

    public void assertRenderedPage(Class<? extends Page> expectedRenderedPageClass) {
        this.assertResult(this.isRenderedPage(expectedRenderedPageClass));
    }

    @Override
    public void assertResultPage(Class<?> clazz, String filename) throws Exception {
        String document = this.getLastResponseAsString();
        DiffUtil.validatePage(document, clazz, filename, true);
    }

    public void assertResultPage(String expectedDocument) throws Exception {
        String document = this.getLastResponseAsString();
        Assert.assertEquals((Object)expectedDocument, (Object)document);
    }

    public void assertVisible(String path) {
        this.assertResult(this.isVisible(path));
    }

    public void assertEnabled(String path) {
        this.assertResult(this.isEnabled(path));
    }

    public void assertDisabled(String path) {
        this.assertResult(this.isDisabled(path));
    }

    public void assertRequired(String path) {
        this.assertResult(this.isRequired(path));
    }

    public void assertNotRequired(String path) {
        this.assertResult(this.isNotRequired(path));
    }

    private void assertResult(Result result) {
        if (result.wasFailed()) {
            throw new AssertionFailedError(result.getMessage());
        }
    }

    public void assertUsability(Component component) {
        this.checkUsability(component, true);
    }

    public void clickLink(Component link) {
        this.clickLink(link.getPageRelativePath());
    }

    public void assertBookmarkablePageLink(String id, Class<? extends WebPage> pageClass, PageParameters parameters) {
        BookmarkablePageLink pageLink;
        try {
            pageLink = (BookmarkablePageLink)this.getComponentFromLastRenderedPage(id);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Component with id:" + id + " is not a BookmarkablePageLink");
        }
        Assert.assertEquals((String)("BookmarkablePageLink: " + id + " is pointing to the wrong page"), pageClass, pageLink.getPageClass());
        Assert.assertEquals((String)("One or more of the parameters associated with the BookmarkablePageLink: " + id + " do not match"), (Object)parameters, (Object)pageLink.getPageParameters());
    }

    public <T extends Page> void executeTest(Class<?> testClass, Class<T> pageClass, String filename) throws Exception {
        log.info("=== " + pageClass.getName() + " ===");
        this.startPage(pageClass);
        this.assertRenderedPage(pageClass);
        this.assertResultPage(testClass, filename);
    }

    public void executeTest(Class<?> testClass, Page page, String filename) throws Exception {
        log.info("=== " + page.getClass().getName() + " ===");
        this.startPage(page);
        this.assertRenderedPage(page.getClass());
        this.assertResultPage(testClass, filename);
    }

    public void executeTest(Class<?> testClass, Component component, String filename) throws Exception {
        log.info("=== " + component.getClass().getName() + " ===");
        this.startComponentInPage(component);
        this.assertResultPage(testClass, filename);
    }

    public <T extends Page> void executeTest(Class<?> testClass, Class<T> pageClass, PageParameters parameters, String filename) throws Exception {
        log.info("=== " + pageClass.getName() + " ===");
        this.startPage(pageClass, parameters);
        this.assertRenderedPage(pageClass);
        this.assertResultPage(testClass, filename);
    }

    public void executeListener(Class<?> testClass, Component component, String filename) throws Exception {
        Assert.assertNotNull((Object)component);
        log.info("=== " + testClass.getName() + " : " + component.getPageRelativePath() + " ===");
        this.executeListener(component);
        this.assertResultPage(testClass, filename);
    }

    public void executeBehavior(Class<?> testClass, AbstractAjaxBehavior behavior, String filename) throws Exception {
        Assert.assertNotNull((Object)behavior);
        log.info("=== " + testClass.getName() + " : " + behavior.toString() + " ===");
        this.executeBehavior(behavior);
        this.assertResultPage(testClass, filename);
    }

    public void assertRedirectUrl(String expectedRedirectUrl) {
        String actualRedirectUrl = this.getLastResponse().getRedirectLocation();
        Assert.assertEquals((Object)expectedRedirectUrl, (Object)actualRedirectUrl);
    }

    public static String getBasedir() {
        String basedir = System.getProperty("basedir");
        basedir = basedir != null ? basedir + "/" : "";
        return basedir;
    }
}

