/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head.filter;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.head.AbstractJavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.IWrappedHeaderItem;
import org.apache.wicket.markup.head.JavaScriptContentHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.DecoratingHeaderResponse;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;

public class JavaScriptDeferHeaderResponse
extends DecoratingHeaderResponse {
    public JavaScriptDeferHeaderResponse(IHeaderResponse response) {
        super(response);
    }

    @Override
    public void render(HeaderItem item) {
        if (RequestCycle.get().find(AjaxRequestTarget.class).isEmpty()) {
            while (item instanceof IWrappedHeaderItem) {
                item = ((IWrappedHeaderItem)((Object)item)).getWrapped();
            }
            if (item instanceof AbstractJavaScriptReferenceHeaderItem) {
                ((AbstractJavaScriptReferenceHeaderItem)item).setDefer(true);
            } else if (item instanceof JavaScriptContentHeaderItem) {
                item = new NativeOnDomContentLoadedHeaderItem(((JavaScriptContentHeaderItem)item).getJavaScript());
            } else if (item instanceof OnDomReadyHeaderItem) {
                item = new NativeOnDomContentLoadedHeaderItem(((OnDomReadyHeaderItem)item).getJavaScript());
            } else if (item instanceof OnLoadHeaderItem) {
                item = new NativeOnLoadHeaderItem(((OnLoadHeaderItem)item).getJavaScript());
            }
        }
        super.render(item);
    }

    private static class NativeOnLoadHeaderItem
    extends OnLoadHeaderItem {
        private static final long serialVersionUID = 1L;

        public NativeOnLoadHeaderItem(CharSequence javaScript) {
            super(javaScript);
        }

        @Override
        public void render(Response response) {
            CharSequence js = this.getJavaScript();
            if (!Strings.isEmpty(js)) {
                JavaScriptUtils.writeJavaScript(response, "window.addEventListener('load', function() { " + js + "; });");
            }
        }
    }

    private static class NativeOnDomContentLoadedHeaderItem
    extends OnDomReadyHeaderItem {
        private static final long serialVersionUID = 1L;

        public NativeOnDomContentLoadedHeaderItem(CharSequence javaScript) {
            super(javaScript);
        }

        @Override
        public void render(Response response) {
            CharSequence js = this.getJavaScript();
            if (!Strings.isEmpty(js)) {
                JavaScriptUtils.writeJavaScript(response, "document.addEventListener('DOMContentLoaded', function() { " + js + "; });");
            }
        }
    }
}

