/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.breadcrumb;

import org.apache.wicket.extensions.breadcrumb.IBreadCrumbModel;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbParticipant;
import org.apache.wicket.markup.html.link.Link;

public abstract class BreadCrumbLink
extends Link<Void> {
    private static final long serialVersionUID = 1L;
    private final IBreadCrumbModel breadCrumbModel;

    public BreadCrumbLink(String id, IBreadCrumbModel breadCrumbModel) {
        super(id);
        this.breadCrumbModel = breadCrumbModel;
    }

    public void onClick() {
        IBreadCrumbParticipant active = this.breadCrumbModel.getActive();
        if (active == null) {
            throw new IllegalStateException("The model has no active bread crumb. Before using " + this + ", you have to have at least one bread crumb in the model");
        }
        IBreadCrumbParticipant participant = this.getParticipant(active.getComponent().getId());
        this.addStateChange();
        this.breadCrumbModel.setActive(participant);
    }

    protected abstract IBreadCrumbParticipant getParticipant(String var1);
}

