/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message.extended;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.message.AddResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;

public class AddNoDResponse
extends AddResponseImpl {
    public static final String EXTENSION_OID = "1.3.6.1.4.1.1466.20036";
    private static final byte[] EMPTY_RESPONSE = new byte[0];
    public static final AddNoDResponse UNAVAILABLE = new AddNoDResponse(ResultCodeEnum.UNAVAILABLE);
    public static final AddNoDResponse PROTOCOLERROR = new AddNoDResponse(ResultCodeEnum.PROTOCOL_ERROR);
    public static final AddNoDResponse STRONGAUTHREQUIRED = new AddNoDResponse(ResultCodeEnum.STRONG_AUTH_REQUIRED);

    private AddNoDResponse(ResultCodeEnum rcode) {
        switch (rcode) {
            case UNAVAILABLE: {
                break;
            }
            case PROTOCOL_ERROR: {
                break;
            }
            case STRONG_AUTH_REQUIRED: {
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04166, (Object[])new Object[]{ResultCodeEnum.UNAVAILABLE, ResultCodeEnum.PROTOCOL_ERROR, ResultCodeEnum.STRONG_AUTH_REQUIRED}));
            }
        }
        super.getLdapResult().setDiagnosticMessage(rcode.toString() + ": The server will disconnect!");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(rcode);
    }

    public byte[] getResponse() {
        return EMPTY_RESPONSE;
    }

    public String getResponseName() {
        return EXTENSION_OID;
    }
}

