/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsnComparator
extends LdapComparator<Object> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(CsnComparator.class);

    public CsnComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(Object csnObj1, Object csnObj2) {
        LOG.debug("comparing CSN objects '{}' with '{}'", csnObj1, csnObj2);
        if (csnObj1 == csnObj2) {
            return 0;
        }
        if (csnObj1 == null) {
            return csnObj2 == null ? 0 : -1;
        }
        if (csnObj2 == null) {
            return 1;
        }
        String csnStr1 = null;
        String csnStr2 = null;
        csnStr1 = csnObj1 instanceof StringValue ? ((StringValue)csnObj1).getValue() : csnObj1.toString();
        csnStr2 = csnObj2 instanceof StringValue ? ((StringValue)csnObj2).getValue() : csnObj2.toString();
        return csnStr1.compareTo(csnStr2);
    }
}

