/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.registries.helper;

import java.util.List;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.registries.Registries;
import org.apache.directory.api.ldap.model.schema.syntaxCheckers.OctetStringSyntaxChecker;

public class LdapSyntaxHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToRegistries(LdapSyntax ldapSyntax, List<Throwable> errors, Registries registries) throws LdapException {
        if (registries != null) {
            try {
                ldapSyntax.unlock();
                SyntaxChecker syntaxChecker = null;
                try {
                    syntaxChecker = (SyntaxChecker)registries.getSyntaxCheckerRegistry().lookup(ldapSyntax.getOid());
                }
                catch (LdapException ne) {
                    syntaxChecker = new OctetStringSyntaxChecker(ldapSyntax.getOid());
                }
                if (syntaxChecker != null) {
                    registries.addReference(ldapSyntax, syntaxChecker);
                    ldapSyntax.setSyntaxChecker(syntaxChecker);
                }
            }
            finally {
                ldapSyntax.lock();
            }
        }
    }

    public static void removeFromRegistries(LdapSyntax ldapSyntax, List<Throwable> errors, Registries registries) throws LdapException {
        if (registries != null && ldapSyntax.getSyntaxChecker() != null) {
            registries.delReference(ldapSyntax, ldapSyntax.getSyntaxChecker());
        }
    }
}

