/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.PasswordLookup;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.IOUtils;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jose.util.Resource;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class JWKSet {
    public static final String MIME_TYPE = "application/jwk-set+json; charset=UTF-8";
    private final List<JWK> keys = new LinkedList<JWK>();
    private final Map<String, Object> customMembers = new HashMap<String, Object>();

    public JWKSet() {
    }

    public JWKSet(JWK key2) {
        if (key2 == null) {
            throw new IllegalArgumentException("The JWK must not be null");
        }
        this.keys.add(key2);
    }

    public JWKSet(List<JWK> keys2) {
        if (keys2 == null) {
            throw new IllegalArgumentException("The JWK list must not be null");
        }
        this.keys.addAll(keys2);
    }

    public JWKSet(List<JWK> keys2, Map<String, Object> customMembers) {
        if (keys2 == null) {
            throw new IllegalArgumentException("The JWK list must not be null");
        }
        this.keys.addAll(keys2);
        this.customMembers.putAll(customMembers);
    }

    public List<JWK> getKeys() {
        return this.keys;
    }

    public JWK getKeyByKeyId(String kid) {
        for (JWK key2 : this.getKeys()) {
            if (key2.getKeyID() == null || !key2.getKeyID().equals(kid)) continue;
            return key2;
        }
        return null;
    }

    public Map<String, Object> getAdditionalMembers() {
        return this.customMembers;
    }

    public JWKSet toPublicJWKSet() {
        LinkedList<JWK> publicKeyList = new LinkedList<JWK>();
        for (JWK key2 : this.keys) {
            JWK publicKey = key2.toPublicJWK();
            if (publicKey == null) continue;
            publicKeyList.add(publicKey);
        }
        return new JWKSet(publicKeyList, this.customMembers);
    }

    public JSONObject toJSONObject() {
        return this.toJSONObject(true);
    }

    public JSONObject toJSONObject(boolean publicKeysOnly) {
        JSONObject o = new JSONObject(this.customMembers);
        JSONArray a = new JSONArray();
        for (JWK key2 : this.keys) {
            if (publicKeysOnly) {
                JWK publicKey = key2.toPublicJWK();
                if (publicKey == null) continue;
                a.add((Object)publicKey.toJSONObject());
                continue;
            }
            a.add((Object)key2.toJSONObject());
        }
        o.put((Object)"keys", (Object)a);
        return o;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    public static JWKSet parse(String s2) throws ParseException {
        return JWKSet.parse(JSONObjectUtils.parse(s2));
    }

    public static JWKSet parse(JSONObject json) throws ParseException {
        JSONArray keyArray = JSONObjectUtils.getJSONArray(json, "keys");
        LinkedList<JWK> keys2 = new LinkedList<JWK>();
        int i2 = 0;
        while (i2 < keyArray.size()) {
            if (!(keyArray.get(i2) instanceof JSONObject)) {
                throw new ParseException("The \"keys\" JSON array must contain JSON objects only", 0);
            }
            JSONObject keyJSON = (JSONObject)keyArray.get(i2);
            try {
                keys2.add(JWK.parse(keyJSON));
            }
            catch (ParseException e) {
                throw new ParseException("Invalid JWK at position " + i2 + ": " + e.getMessage(), 0);
            }
            ++i2;
        }
        JWKSet jwkSet = new JWKSet(keys2);
        for (Map.Entry entry : json.entrySet()) {
            if (entry.getKey() == null || ((String)entry.getKey()).equals("keys")) continue;
            jwkSet.getAdditionalMembers().put((String)entry.getKey(), entry.getValue());
        }
        return jwkSet;
    }

    public static JWKSet load(File file2) throws IOException, ParseException {
        return JWKSet.parse(IOUtils.readFileToString(file2, Charset.forName("UTF-8")));
    }

    public static JWKSet load(URL url, int connectTimeout, int readTimeout, int sizeLimit) throws IOException, ParseException {
        DefaultResourceRetriever resourceRetriever = new DefaultResourceRetriever(connectTimeout, readTimeout, sizeLimit);
        Resource resource2 = resourceRetriever.retrieveResource(url);
        return JWKSet.parse(resource2.getContent());
    }

    public static JWKSet load(URL url) throws IOException, ParseException {
        return JWKSet.load(url, 0, 0, 0);
    }

    public static JWKSet load(KeyStore keyStore, PasswordLookup pwLookup) throws KeyStoreException {
        char[] keyPassword;
        String keyAlias;
        LinkedList<JWK> jwks = new LinkedList<JWK>();
        Enumeration<String> keyAliases = keyStore.aliases();
        while (keyAliases.hasMoreElements()) {
            ECKey ecJWK;
            keyAlias = keyAliases.nextElement();
            keyPassword = pwLookup == null ? "".toCharArray() : pwLookup.lookupPassword(keyAlias);
            Certificate cert = keyStore.getCertificate(keyAlias);
            if (cert == null) continue;
            if (cert.getPublicKey() instanceof RSAPublicKey) {
                RSAKey rsaJWK;
                try {
                    rsaJWK = RSAKey.load(keyStore, keyAlias, keyPassword);
                }
                catch (JOSEException jOSEException) {
                    continue;
                }
                if (rsaJWK == null) continue;
                jwks.add(rsaJWK);
                continue;
            }
            if (!(cert.getPublicKey() instanceof ECPublicKey)) continue;
            try {
                ecJWK = ECKey.load(keyStore, keyAlias, keyPassword);
            }
            catch (JOSEException jOSEException) {
                continue;
            }
            if (ecJWK == null) continue;
            jwks.add(ecJWK);
        }
        keyAliases = keyStore.aliases();
        while (keyAliases.hasMoreElements()) {
            OctetSequenceKey octJWK;
            keyAlias = keyAliases.nextElement();
            keyPassword = pwLookup == null ? "".toCharArray() : pwLookup.lookupPassword(keyAlias);
            try {
                octJWK = OctetSequenceKey.load(keyStore, keyAlias, keyPassword);
            }
            catch (JOSEException jOSEException) {
                continue;
            }
            if (octJWK == null) continue;
            jwks.add(octJWK);
        }
        return new JWKSet(jwks);
    }
}

