/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util;

public final class Chars {
    public static final boolean[] ALPHA = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    public static final boolean[] ALPHA_LOWER_CASE = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    public static final boolean[] ALPHA_UPPER_CASE = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    public static final boolean[] ALPHA_DIGIT = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    public static final boolean[] CHAR = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    public static final boolean[] DIGIT = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    public static final boolean[] HEX = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};

    public static boolean isCharASCII(char[] chars2, int index2, char car) {
        if (chars2 == null || chars2.length == 0 || index2 < 0 || index2 >= chars2.length) {
            return false;
        }
        return chars2[index2] == car;
    }

    public static boolean isCharASCII(String string2, int index2, char car) {
        if (string2 == null) {
            return false;
        }
        int length2 = string2.length();
        if (length2 == 0 || index2 < 0 || index2 >= length2) {
            return false;
        }
        return string2.charAt(index2) == car;
    }

    public static boolean isICharASCII(String string2, int index2, char car) {
        if (string2 == null) {
            return false;
        }
        int length2 = string2.length();
        if (length2 == 0 || index2 < 0 || index2 >= length2) {
            return false;
        }
        return ((string2.charAt(index2) | 0x20) & car) == car;
    }

    public static boolean isICharASCII(byte[] bytes2, int index2, char car) {
        if (bytes2 == null) {
            return false;
        }
        int length2 = bytes2.length;
        if (length2 == 0 || index2 < 0 || index2 >= length2) {
            return false;
        }
        return ((bytes2[index2] | 0x20) & car) == car;
    }

    public static boolean isAlpha(byte c) {
        return c > 0 && c <= 127 && ALPHA[c];
    }

    public static boolean isAlpha(char c) {
        return c > '\u0000' && c <= '\u007f' && ALPHA[c];
    }

    public static boolean isAlphaASCII(byte[] bytes2, int index2) {
        if (bytes2 == null || bytes2.length == 0 || index2 < 0 || index2 >= bytes2.length) {
            return false;
        }
        byte c = bytes2[index2];
        return (c | 0x7F) == 127 && ALPHA[c];
    }

    public static boolean isAlphaASCII(char[] chars2, int index2) {
        if (chars2 == null || chars2.length == 0 || index2 < 0 || index2 >= chars2.length) {
            return false;
        }
        char c = chars2[index2];
        return c <= '\u007f' && ALPHA[c];
    }

    public static boolean isAlphaASCII(String string2, int index2) {
        if (string2 == null) {
            return false;
        }
        int length2 = string2.length();
        if (length2 == 0 || index2 < 0 || index2 >= length2) {
            return false;
        }
        char c = string2.charAt(index2);
        return c <= '\u007f' && ALPHA[c];
    }

    public static boolean isAlphaLowercaseASCII(String string2, int index2) {
        if (string2 == null) {
            return false;
        }
        int length2 = string2.length();
        if (length2 == 0 || index2 < 0 || index2 >= length2) {
            return false;
        }
        char c = string2.charAt(index2);
        return c <= '\u007f' && ALPHA_LOWER_CASE[c];
    }

    public static boolean isAlphaUppercaseASCII(String string2, int index2) {
        if (string2 == null) {
            return false;
        }
        int length2 = string2.length();
        if (length2 == 0 || index2 < 0 || index2 >= length2) {
            return false;
        }
        char c = string2.charAt(index2);
        return c <= '\u007f' && ALPHA_UPPER_CASE[c];
    }

    public static boolean isAlphaDigit(String string2, int index2) {
        if (string2 == null) {
            return false;
        }
        int length2 = string2.length();
        if (length2 == 0 || index2 < 0 || index2 >= length2) {
            return false;
        }
        char c = string2.charAt(index2);
        return c <= '\u007f' && ALPHA_DIGIT[c];
    }

    public static boolean isAlphaDigitMinus(byte[] bytes2, int index2) {
        if (bytes2 == null || bytes2.length == 0 || index2 < 0 || index2 >= bytes2.length) {
            return false;
        }
        byte c = bytes2[index2];
        return (c | 0x7F) == 127 && CHAR[c];
    }

    public static boolean isAlphaDigitMinus(char[] chars2, int index2) {
        if (chars2 == null || chars2.length == 0 || index2 < 0 || index2 >= chars2.length) {
            return false;
        }
        char c = chars2[index2];
        return c <= '\u007f' && CHAR[c];
    }

    public static boolean isAlphaDigitMinus(String string2, int index2) {
        if (string2 == null) {
            return false;
        }
        int length2 = string2.length();
        if (length2 == 0 || index2 < 0 || index2 >= length2) {
            return false;
        }
        char c = string2.charAt(index2);
        return c <= '\u007f' && CHAR[c];
    }

    public static boolean isBit(String string2, int index2) {
        if (string2 == null) {
            return false;
        }
        int length2 = string2.length();
        if (length2 == 0 || index2 < 0 || index2 >= length2) {
            return false;
        }
        char c = string2.charAt(index2);
        return c == '0' || c == '1';
    }

    public static boolean isDigit(byte[] bytes2) {
        if (bytes2 == null || bytes2.length == 0) {
            return false;
        }
        return (bytes2[0] | 0x7F) == 127 && DIGIT[bytes2[0]];
    }

    public static boolean isDigit(char car) {
        return car >= '0' && car <= '9';
    }

    public static boolean isDigit(byte car) {
        return car >= 48 && car <= 57;
    }

    public static boolean isDigit(byte[] bytes2, int index2) {
        if (bytes2 == null || bytes2.length == 0 || index2 < 0 || index2 >= bytes2.length) {
            return false;
        }
        return (bytes2[index2] | 0x7F) == 127 && DIGIT[bytes2[index2]];
    }

    public static boolean isDigit(char[] chars2, int index2) {
        if (chars2 == null || chars2.length == 0 || index2 < 0 || index2 >= chars2.length) {
            return false;
        }
        return chars2[index2] <= '\u007f' && DIGIT[chars2[index2]];
    }

    public static boolean isDigit(String string2, int index2) {
        if (string2 == null) {
            return false;
        }
        int length2 = string2.length();
        if (length2 == 0 || index2 < 0 || index2 >= length2) {
            return false;
        }
        char c = string2.charAt(index2);
        return c <= '\u007f' && DIGIT[c];
    }

    public static boolean isDigit(char[] chars2) {
        if (chars2 == null || chars2.length == 0) {
            return false;
        }
        return chars2[0] <= '\u007f' && DIGIT[chars2[0]];
    }

    public static boolean isHex(byte b) {
        return (b | 0x7F) == 127 || HEX[b];
    }

    public static boolean isHex(byte[] bytes2, int index2) {
        if (bytes2 == null || bytes2.length == 0 || index2 < 0 || index2 >= bytes2.length) {
            return false;
        }
        byte c = bytes2[index2];
        return (c | 0x7F) == 127 && HEX[c];
    }

    public static boolean isHex(char[] chars2, int index2) {
        if (chars2 == null || chars2.length == 0 || index2 < 0 || index2 >= chars2.length) {
            return false;
        }
        char c = chars2[index2];
        return c <= '\u007f' && HEX[c];
    }

    public static boolean isHex(String string2, int index2) {
        if (string2 == null) {
            return false;
        }
        int length2 = string2.length();
        if (length2 == 0 || index2 < 0 || index2 >= length2) {
            return false;
        }
        char c = string2.charAt(index2);
        return c <= '\u007f' && HEX[c];
    }
}

