/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util;

import javax.naming.InvalidNameException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.util.Chars;
import org.apache.directory.api.util.Strings;

public class Hex {
    public static final byte[] HEX_VALUE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte getHexValue(char high, char low) {
        if (high > '\u007f' || low > '\u007f' || high < '\u0000' | low < '\u0000') {
            return -1;
        }
        return (byte)(HEX_VALUE[high] << 4 | HEX_VALUE[low]);
    }

    public static byte getHexValue(byte high, byte low) {
        if ((high & 0x7F) != high || (low & 0x7F) != low) {
            return -1;
        }
        return (byte)(HEX_VALUE[high] << 4 | HEX_VALUE[low]);
    }

    public static byte getHexValue(char c) {
        if (c > '\u007f' || c < '\u0000') {
            return -1;
        }
        return HEX_VALUE[c];
    }

    public static String decodeHexString(String str) throws InvalidNameException {
        if (str == null || str.length() == 0) {
            throw new InvalidNameException(I18n.err((I18n)I18n.ERR_04431, (Object[])new Object[0]));
        }
        char[] chars2 = str.toCharArray();
        if (chars2[0] != '#') {
            throw new InvalidNameException(I18n.err((I18n)I18n.ERR_04432, (Object[])new Object[]{str}));
        }
        byte[] decoded = new byte[chars2.length - 1 >> 1];
        int ii = 1;
        int jj = 0;
        while (ii < chars2.length) {
            int ch = (HEX_VALUE[chars2[ii]] << 4) + HEX_VALUE[chars2[ii + 1]];
            decoded[jj] = (byte)ch;
            ii += 2;
            ++jj;
        }
        return Strings.utf8ToString(decoded);
    }

    public static byte[] convertEscapedHex(String str) throws InvalidNameException {
        if (str == null) {
            throw new InvalidNameException(I18n.err((I18n)I18n.ERR_04433, (Object[])new Object[0]));
        }
        int length2 = str.length();
        if (length2 == 0) {
            throw new InvalidNameException(I18n.err((I18n)I18n.ERR_04434, (Object[])new Object[0]));
        }
        byte[] buf = new byte[str.length() / 3];
        int pos2 = 0;
        for (int i2 = 0; i2 < length2; ++i2) {
            char c = str.charAt(i2);
            if (c == '\\') {
                if (!Chars.isHex(str, i2 + 1) || !Chars.isHex(str, i2 + 2)) continue;
                byte value2 = (byte)((HEX_VALUE[str.charAt(i2 + 1)] << 4) + HEX_VALUE[str.charAt(i2 + 2)]);
                i2 += 2;
                buf[pos2++] = value2;
                continue;
            }
            throw new InvalidNameException(I18n.err((I18n)I18n.ERR_04435, (Object[])new Object[0]));
        }
        return buf;
    }

    public static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i2 = 0; i2 < l; ++i2) {
            out[j++] = HEX_CHAR[(0xF0 & data[i2]) >>> 4];
            out[j++] = HEX_CHAR[0xF & data[i2]];
        }
        return out;
    }
}

