/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.checksum;

import java.util.zip.CRC32;
import org.apache.directory.server.kerberos.shared.crypto.checksum.ChecksumEngine;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.shared.kerberos.crypto.checksum.ChecksumType;

class Crc32Checksum
implements ChecksumEngine {
    Crc32Checksum() {
    }

    @Override
    public ChecksumType checksumType() {
        return ChecksumType.CRC32;
    }

    @Override
    public byte[] calculateChecksum(byte[] data, byte[] key2, KeyUsage usage) {
        CRC32 crc322 = new CRC32();
        crc322.update(data);
        return this.int2octet((int)crc322.getValue());
    }

    private byte[] int2octet(int value2) {
        byte[] bytes2 = new byte[4];
        int i2 = 0;
        int shift2 = 24;
        while (i2 < 4) {
            bytes2[i2] = (byte)(0xFF & value2 >> shift2);
            ++i2;
            shift2 -= 8;
        }
        return bytes2;
    }
}

