/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

import java.security.SecureRandom;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.server.kerberos.shared.crypto.encryption.NFold;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptedData;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;

public abstract class EncryptionEngine {
    private static final SecureRandom random = new SecureRandom();

    protected abstract byte[] getDecryptedData(EncryptionKey var1, EncryptedData var2, KeyUsage var3) throws KerberosException;

    protected abstract EncryptedData getEncryptedData(EncryptionKey var1, byte[] var2, KeyUsage var3);

    protected abstract EncryptionType getEncryptionType();

    protected abstract int getConfounderLength();

    protected abstract int getChecksumLength();

    protected abstract byte[] encrypt(byte[] var1, byte[] var2);

    protected abstract byte[] decrypt(byte[] var1, byte[] var2);

    protected abstract byte[] calculateIntegrity(byte[] var1, byte[] var2, KeyUsage var3);

    protected byte[] deriveRandom(byte[] key2, byte[] usage, int n, int k) {
        byte[] nFoldedUsage = NFold.nFold(n, usage);
        int kBytes = k / 8;
        byte[] result2 = new byte[kBytes];
        byte[] fillingKey = this.encrypt(nFoldedUsage, key2);
        int pos2 = 0;
        for (int i2 = 0; i2 < kBytes; ++i2) {
            if (pos2 < fillingKey.length) {
                result2[i2] = fillingKey[pos2];
                ++pos2;
                continue;
            }
            fillingKey = this.encrypt(fillingKey, key2);
            pos2 = 0;
            result2[i2] = fillingKey[pos2];
            ++pos2;
        }
        return result2;
    }

    protected byte[] getRandomBytes(int size2) {
        byte[] bytes2 = new byte[size2];
        random.nextBytes(bytes2);
        return bytes2;
    }

    protected byte[] padString(byte[] encodedString) {
        int x = encodedString.length < 8 ? encodedString.length : encodedString.length % 8;
        if (x == 0) {
            return encodedString;
        }
        byte[] paddedByteArray = new byte[8 - x + encodedString.length];
        for (int y = paddedByteArray.length - 1; y > encodedString.length - 1; --y) {
            paddedByteArray[y] = 0;
        }
        System.arraycopy(encodedString, 0, paddedByteArray, 0, encodedString.length);
        return paddedByteArray;
    }

    protected byte[] concatenateBytes(byte[] array1, byte[] array2) {
        int l1 = array1.length;
        int l2 = array2.length;
        byte[] concatenatedBytes = new byte[l1 + l2];
        System.arraycopy(array1, 0, concatenatedBytes, 0, l1);
        System.arraycopy(array2, 0, concatenatedBytes, l1, l2);
        return concatenatedBytes;
    }

    protected byte[] removeLeadingBytes(byte[] array, int confounder, int checksum) {
        byte[] lessBytes = new byte[array.length - confounder - checksum];
        int j = 0;
        for (int i2 = confounder + checksum; i2 < array.length; ++i2) {
            lessBytes[j] = array[i2];
            ++j;
        }
        return lessBytes;
    }

    protected byte[] removeTrailingBytes(byte[] array, int confounder, int checksum) {
        byte[] lessBytes = new byte[array.length - confounder - checksum];
        int j = 0;
        for (int i2 = 0; i2 < array.length - confounder - checksum; ++i2) {
            lessBytes[j] = array[i2];
            ++j;
        }
        return lessBytes;
    }

    protected int getBit(byte[] data, int pos2) {
        int posByte = pos2 / 8;
        int posBit = pos2 % 8;
        byte valByte = data[posByte];
        int valInt = valByte >> 8 - (posBit + 1) & 1;
        return valInt;
    }

    protected void setBit(byte[] data, int pos2, int val) {
        byte newByte;
        int posByte = pos2 / 8;
        int posBit = pos2 % 8;
        byte oldByte = data[posByte];
        oldByte = (byte)(65407 >> posBit & oldByte & 0xFF);
        data[posByte] = newByte = (byte)(val << 8 - (posBit + 1) | oldByte);
    }

    protected byte[] getUsageKc(KeyUsage usage) {
        return this.getUsage(usage.getOrdinal(), (byte)-103);
    }

    protected byte[] getUsageKe(KeyUsage usage) {
        return this.getUsage(usage.getOrdinal(), (byte)-86);
    }

    protected byte[] getUsageKi(KeyUsage usage) {
        return this.getUsage(usage.getOrdinal(), (byte)85);
    }

    private byte[] getUsage(int usage, byte constant) {
        byte[] bytes2 = new byte[]{(byte)(usage >>> 24 & 0xFF), (byte)(usage >> 16 & 0xFF), (byte)(usage >> 8 & 0xFF), (byte)(usage & 0xFF), constant};
        return bytes2;
    }
}

