/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

public class NFold {
    public static byte[] nFold(int n, byte[] data) {
        int k = data.length * 8;
        int lcm2 = NFold.getLcm(n, k);
        int replicate = lcm2 / k;
        byte[] sumBytes = new byte[lcm2 / 8];
        for (int i2 = 0; i2 < replicate; ++i2) {
            int rotation = 13 * i2;
            byte[] temp = NFold.rotateRight(data, data.length * 8, rotation);
            for (int j = 0; j < temp.length; ++j) {
                sumBytes[j + i2 * temp.length] = temp[j];
            }
        }
        byte[] sum2 = new byte[n / 8];
        byte[] nfold = new byte[n / 8];
        for (int m = 0; m < lcm2 / n; ++m) {
            for (int o = 0; o < n / 8; ++o) {
                sum2[o] = sumBytes[o + m * n / 8];
            }
            nfold = NFold.sum(nfold, sum2, nfold.length * 8);
        }
        return nfold;
    }

    protected static int getLcm(int n1, int n2) {
        int product2 = n1 * n2;
        do {
            if (n1 >= n2) continue;
            int temp = n1;
            n1 = n2;
            n2 = temp;
        } while ((n1 %= n2) != 0);
        return product2 / n2;
    }

    private static byte[] rotateRight(byte[] in, int len, int step2) {
        int numOfBytes = (len - 1) / 8 + 1;
        byte[] out = new byte[numOfBytes];
        for (int i2 = 0; i2 < len; ++i2) {
            int val = NFold.getBit(in, i2);
            NFold.setBit(out, (i2 + step2) % len, val);
        }
        return out;
    }

    protected static byte[] sum(byte[] n1, byte[] n2, int len) {
        int numOfBytes = (len - 1) / 8 + 1;
        byte[] out = new byte[numOfBytes];
        int carry = 0;
        for (int i2 = len - 1; i2 > -1; --i2) {
            int n2b;
            int n1b = NFold.getBit(n1, i2);
            int sum2 = n1b + (n2b = NFold.getBit(n2, i2)) + carry;
            if (sum2 == 0 || sum2 == 1) {
                NFold.setBit(out, i2, sum2);
                carry = 0;
                continue;
            }
            if (sum2 == 2) {
                carry = 1;
                continue;
            }
            if (sum2 != 3) continue;
            NFold.setBit(out, i2, 1);
            carry = 1;
        }
        if (carry == 1) {
            byte[] carryArray = new byte[n1.length];
            carryArray[carryArray.length - 1] = 1;
            out = NFold.sum(out, carryArray, n1.length * 8);
        }
        return out;
    }

    private static int getBit(byte[] data, int pos2) {
        int posByte = pos2 / 8;
        int posBit = pos2 % 8;
        byte valByte = data[posByte];
        int valInt = valByte >> 8 - (posBit + 1) & 1;
        return valInt;
    }

    private static void setBit(byte[] data, int pos2, int val) {
        byte newByte;
        int posByte = pos2 / 8;
        int posBit = pos2 % 8;
        byte oldByte = data[posByte];
        oldByte = (byte)(65407 >> posBit & oldByte & 0xFF);
        data[posByte] = newByte = (byte)(val << 8 - (posBit + 1) | oldByte);
    }
}

