/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.keytab;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.keytab.KeytabDecoder;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEncoder;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;

public class Keytab {
    public static final byte[] VERSION_0X501_BYTES = new byte[]{5, 1};
    public static final short VERSION_0X501 = 1281;
    public static final byte[] VERSION_0X502_BYTES = new byte[]{5, 2};
    public static final short VERSION_0X502 = 1282;
    private byte[] keytabVersion = VERSION_0X502_BYTES;
    private List<KeytabEntry> entries = new ArrayList<KeytabEntry>();

    public static Keytab read(File file2) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(Keytab.getBytesFromFile(file2));
        return Keytab.readKeytab(buffer);
    }

    public static Keytab getInstance() {
        return new Keytab();
    }

    public void write(File file2) throws IOException {
        KeytabEncoder writer = new KeytabEncoder();
        ByteBuffer buffer = writer.write(this.keytabVersion, this.entries);
        this.writeFile(buffer, file2);
    }

    public void setEntries(List<KeytabEntry> entries2) {
        this.entries = entries2;
    }

    public void setKeytabVersion(byte[] keytabVersion) {
        this.keytabVersion = keytabVersion;
    }

    public List<KeytabEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public byte[] getKeytabVersion() {
        return this.keytabVersion;
    }

    static Keytab read(byte[] bytes2) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes2);
        return Keytab.readKeytab(buffer);
    }

    ByteBuffer write() {
        KeytabEncoder writer = new KeytabEncoder();
        return writer.write(this.keytabVersion, this.entries);
    }

    private static Keytab readKeytab(ByteBuffer buffer) {
        KeytabDecoder reader = new KeytabDecoder();
        byte[] keytabVersion = reader.getKeytabVersion(buffer);
        List<KeytabEntry> entries2 = reader.getKeytabEntries(buffer);
        Keytab keytab = new Keytab();
        keytab.setKeytabVersion(keytabVersion);
        keytab.setEntries(entries2);
        return keytab;
    }

    protected static byte[] getBytesFromFile(File file2) throws IOException {
        int offset2;
        FileInputStream is = new FileInputStream(file2);
        long length2 = file2.length();
        if (length2 > Integer.MAX_VALUE) {
            ((InputStream)is).close();
            throw new IOException(I18n.err(I18n.ERR_618, file2.getName()));
        }
        byte[] bytes2 = new byte[(int)length2];
        int numRead = 0;
        for (offset2 = 0; offset2 < bytes2.length && (numRead = ((InputStream)is).read(bytes2, offset2, bytes2.length - offset2)) >= 0; offset2 += numRead) {
        }
        if (offset2 < bytes2.length) {
            ((InputStream)is).close();
            throw new IOException(I18n.err(I18n.ERR_619, file2.getName()));
        }
        ((InputStream)is).close();
        return bytes2;
    }

    protected void writeFile(ByteBuffer buffer, File file2) throws IOException {
        FileChannel wChannel = new FileOutputStream(file2, false).getChannel();
        wChannel.write(buffer);
        wChannel.close();
    }
}

