/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class BatchScanResultCache
implements ScanResultCache {
    private final int batch;
    private Cell lastCell;
    private boolean lastResultPartial;
    private final Deque<Result> partialResults = new ArrayDeque<Result>();
    private int numCellsOfPartialResults;
    private int numberOfCompleteRows;

    public BatchScanResultCache(int batch) {
        this.batch = batch;
    }

    private void recordLastResult(Result result2) {
        this.lastCell = result2.rawCells()[result2.rawCells().length - 1];
        this.lastResultPartial = result2.mayHaveMoreCellsInRow();
    }

    private Result createCompletedResult() throws IOException {
        ++this.numberOfCompleteRows;
        Result result2 = Result.createCompleteResult(this.partialResults);
        this.partialResults.clear();
        this.numCellsOfPartialResults = 0;
        return result2;
    }

    private Result regroupResults(Result result2) {
        this.partialResults.addLast(result2);
        this.numCellsOfPartialResults += result2.size();
        if (this.numCellsOfPartialResults < this.batch) {
            return null;
        }
        Cell[] cells = new Cell[this.batch];
        int cellCount = 0;
        boolean stale = false;
        while (true) {
            Result r = this.partialResults.pollFirst();
            stale = stale || r.isStale();
            int newCellCount = cellCount + r.size();
            if (newCellCount > this.batch) {
                int len = this.batch - cellCount;
                System.arraycopy(r.rawCells(), 0, cells, cellCount, len);
                Cell[] remainingCells = new Cell[r.size() - len];
                System.arraycopy(r.rawCells(), len, remainingCells, 0, r.size() - len);
                this.partialResults.addFirst(Result.create(remainingCells, r.getExists(), r.isStale(), r.mayHaveMoreCellsInRow()));
                break;
            }
            System.arraycopy(r.rawCells(), 0, cells, cellCount, r.size());
            if (newCellCount == this.batch) break;
            cellCount = newCellCount;
        }
        this.numCellsOfPartialResults -= this.batch;
        return Result.create(cells, null, stale, result2.mayHaveMoreCellsInRow() || !this.partialResults.isEmpty());
    }

    @Override
    public Result[] addAndGet(Result[] results, boolean isHeartbeatMessage) throws IOException {
        if (results.length == 0) {
            if (!isHeartbeatMessage) {
                if (!this.partialResults.isEmpty()) {
                    return new Result[]{this.createCompletedResult()};
                }
                if (this.lastResultPartial) {
                    ++this.numberOfCompleteRows;
                }
            }
            return EMPTY_RESULT_ARRAY;
        }
        ArrayList<Result> regroupedResults = new ArrayList<Result>();
        for (Result result2 : results) {
            Result regroupedResult;
            if ((result2 = ConnectionUtils.filterCells(result2, this.lastCell)) == null) continue;
            if (!this.partialResults.isEmpty()) {
                if (!Bytes.equals(this.partialResults.peek().getRow(), result2.getRow())) {
                    regroupedResults.add(this.createCompletedResult());
                }
            } else if (this.lastResultPartial && !CellUtil.matchingRows(this.lastCell, result2.getRow())) {
                ++this.numberOfCompleteRows;
            }
            if (!this.partialResults.isEmpty() && !Bytes.equals(this.partialResults.peek().getRow(), result2.getRow())) {
                regroupedResults.add(this.createCompletedResult());
            }
            if ((regroupedResult = this.regroupResults(result2)) != null) {
                if (!regroupedResult.mayHaveMoreCellsInRow()) {
                    ++this.numberOfCompleteRows;
                }
                regroupedResults.add(regroupedResult);
                this.recordLastResult(regroupedResult);
            }
            if (result2.mayHaveMoreCellsInRow() || this.partialResults.isEmpty()) continue;
            regroupedResults.add(this.createCompletedResult());
        }
        return regroupedResults.toArray(new Result[0]);
    }

    @Override
    public void clear() {
        this.partialResults.clear();
        this.numCellsOfPartialResults = 0;
    }

    @Override
    public int numberOfCompleteRows() {
        return this.numberOfCompleteRows;
    }
}

