/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.aes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Properties;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.CipherProvider;
import org.apache.hadoop.hbase.io.crypto.Context;
import org.apache.hadoop.hbase.io.crypto.Decryptor;
import org.apache.hadoop.hbase.io.crypto.Encryptor;
import org.apache.hadoop.hbase.io.crypto.aes.CommonsCryptoAESDecryptor;
import org.apache.hadoop.hbase.io.crypto.aes.CommonsCryptoAESEncryptor;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CommonsCryptoAES
extends Cipher {
    private static final Logger LOG = LoggerFactory.getLogger(CommonsCryptoAES.class);
    public static final String CIPHER_MODE_KEY = "hbase.crypto.commons.mode";
    public static final String CIPHER_CLASSES_KEY = "hbase.crypto.commons.cipher.classes";
    public static final String CIPHER_JCE_PROVIDER_KEY = "hbase.crypto.commons.cipher.jce.provider";
    private final String cipherMode;
    private Properties props;
    private final String rngAlgorithm;
    private SecureRandom rng;

    public CommonsCryptoAES(CipherProvider provider) {
        super(provider);
        this.cipherMode = provider.getConf().get(CIPHER_MODE_KEY, "AES/CTR/NoPadding");
        this.props = CommonsCryptoAES.readCryptoProps(provider.getConf());
        this.rngAlgorithm = provider.getConf().get("hbase.crypto.algorithm.rng", "SHA1PRNG");
        String rngProvider = provider.getConf().get("hbase.crypto.algorithm.rng.provider");
        try {
            this.rng = rngProvider != null ? SecureRandom.getInstance(this.rngAlgorithm, rngProvider) : SecureRandom.getInstance(this.rngAlgorithm);
        }
        catch (GeneralSecurityException e) {
            LOG.warn("Could not instantiate specified RNG, falling back to default", e);
            this.rng = new SecureRandom();
        }
    }

    private static Properties readCryptoProps(Configuration conf) {
        Properties props = new Properties();
        props.setProperty("commons.crypto.cipher.classes", conf.get(CIPHER_CLASSES_KEY, ""));
        props.setProperty("commons.crypto.cipher.jce.provider", conf.get(CIPHER_JCE_PROVIDER_KEY, ""));
        return props;
    }

    @Override
    public String getName() {
        return "AES";
    }

    @Override
    public int getKeyLength() {
        return 16;
    }

    @Override
    public int getIvLength() {
        return 16;
    }

    @Override
    public Key getRandomKey() {
        byte[] keyBytes = new byte[this.getKeyLength()];
        this.rng.nextBytes(keyBytes);
        return new SecretKeySpec(keyBytes, this.getName());
    }

    @Override
    public Encryptor getEncryptor() {
        return new CommonsCryptoAESEncryptor(this.cipherMode, this.props, this.rng);
    }

    @Override
    public Decryptor getDecryptor() {
        return new CommonsCryptoAESDecryptor(this.cipherMode, this.props);
    }

    @Override
    public OutputStream createEncryptionStream(OutputStream out, Context context, byte[] iv) throws IOException {
        Preconditions.checkNotNull(context);
        Preconditions.checkState(context.getKey() != null, "Context does not have a key");
        Preconditions.checkNotNull(iv);
        Encryptor e = this.getEncryptor();
        e.setKey(context.getKey());
        e.setIv(iv);
        return e.createEncryptionStream(out);
    }

    @Override
    public OutputStream createEncryptionStream(OutputStream out, Encryptor encryptor) throws IOException {
        return encryptor.createEncryptionStream(out);
    }

    @Override
    public InputStream createDecryptionStream(InputStream in, Context context, byte[] iv) throws IOException {
        Preconditions.checkNotNull(context);
        Preconditions.checkState(context.getKey() != null, "Context does not have a key");
        Preconditions.checkNotNull(iv);
        Decryptor d = this.getDecryptor();
        d.setKey(context.getKey());
        d.setIv(iv);
        return d.createDecryptionStream(in);
    }

    @Override
    public InputStream createDecryptionStream(InputStream in, Decryptor decryptor) throws IOException {
        Preconditions.checkNotNull(decryptor);
        return decryptor.createDecryptionStream(in);
    }

    SecureRandom getRNG() {
        return this.rng;
    }
}

