/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.net.InetSocketAddress;
import java.util.Objects;
import org.apache.hadoop.hbase.security.User;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class ConnectionId {
    private static final int PRIME = 16777619;
    final User ticket;
    final String serviceName;
    final InetSocketAddress address;

    public ConnectionId(User ticket, String serviceName, InetSocketAddress address2) {
        this.address = address2;
        this.ticket = ticket;
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public User getTicket() {
        return this.ticket;
    }

    public String toString() {
        return this.address.toString() + "/" + this.serviceName + "/" + this.ticket;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionId) {
            ConnectionId id2 = (ConnectionId)obj;
            return this.address.equals(id2.address) && (this.ticket != null && this.ticket.equals(id2.ticket) || this.ticket == id2.ticket) && Objects.equals(this.serviceName, id2.serviceName);
        }
        return false;
    }

    public int hashCode() {
        return ConnectionId.hashCode(this.ticket, this.serviceName, this.address);
    }

    public static int hashCode(User ticket, String serviceName, InetSocketAddress address2) {
        return address2.hashCode() + 16777619 * (16777619 * serviceName.hashCode() ^ (ticket == null ? 0 : ticket.hashCode()));
    }
}

