/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.BufferCallBeforeInitHandler;
import org.apache.hadoop.hbase.ipc.Call;
import org.apache.hadoop.hbase.ipc.CallEvent;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.ipc.FallbackDisallowedException;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcDuplexHandler;
import org.apache.hadoop.hbase.ipc.RpcConnection;
import org.apache.hadoop.hbase.security.NettyHBaseRpcConnectionHeaderHandler;
import org.apache.hadoop.hbase.security.NettyHBaseSaslRpcClientHandler;
import org.apache.hadoop.hbase.security.SaslChallengeDecoder;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.io.netty.bootstrap.Bootstrap;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufOutputStream;
import org.apache.hbase.thirdparty.io.netty.buffer.Unpooled;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelFutureListener;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOption;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoop;
import org.apache.hbase.thirdparty.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.hbase.thirdparty.io.netty.handler.timeout.IdleStateHandler;
import org.apache.hbase.thirdparty.io.netty.handler.timeout.ReadTimeoutHandler;
import org.apache.hbase.thirdparty.io.netty.util.ReferenceCountUtil;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.Future;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.FutureListener;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.GenericFutureListener;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.Promise;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class NettyRpcConnection
extends RpcConnection {
    private static final Logger LOG = LoggerFactory.getLogger(NettyRpcConnection.class);
    private static final ScheduledExecutorService RELOGIN_EXECUTOR = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("Relogin-pool-%d").setDaemon(true).setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build());
    private final NettyRpcClient rpcClient;
    private final EventLoop eventLoop;
    private ByteBuf connectionHeaderPreamble;
    private ByteBuf connectionHeaderWithLength;
    private volatile Channel channel;
    private boolean reloginInProgress;

    NettyRpcConnection(NettyRpcClient rpcClient, ConnectionId remoteId) throws IOException {
        super(rpcClient.conf, AbstractRpcClient.WHEEL_TIMER, remoteId, rpcClient.clusterId, rpcClient.userProvider.isHBaseSecurityEnabled(), rpcClient.codec, rpcClient.compressor);
        this.rpcClient = rpcClient;
        this.eventLoop = rpcClient.group.next();
        byte[] connectionHeaderPreamble = this.getConnectionHeaderPreamble();
        this.connectionHeaderPreamble = Unpooled.directBuffer(connectionHeaderPreamble.length).writeBytes(connectionHeaderPreamble);
        RPCProtos.ConnectionHeader header = this.getConnectionHeader();
        this.connectionHeaderWithLength = Unpooled.directBuffer(4 + header.getSerializedSize());
        this.connectionHeaderWithLength.writeInt(header.getSerializedSize());
        header.writeTo(new ByteBufOutputStream(this.connectionHeaderWithLength));
    }

    @Override
    protected void callTimeout(Call call2) {
        IPCUtil.execute(this.eventLoop, () -> {
            if (this.channel != null) {
                this.channel.pipeline().fireUserEventTriggered(new CallEvent(CallEvent.Type.TIMEOUT, call2));
            }
        });
    }

    @Override
    public boolean isActive() {
        return this.channel != null;
    }

    private void shutdown0() {
        assert (this.eventLoop.inEventLoop());
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    @Override
    public void shutdown() {
        IPCUtil.execute(this.eventLoop, this::shutdown0);
    }

    @Override
    public void cleanupConnection() {
        IPCUtil.execute(this.eventLoop, () -> {
            if (this.connectionHeaderPreamble != null) {
                ReferenceCountUtil.safeRelease(this.connectionHeaderPreamble);
                this.connectionHeaderPreamble = null;
            }
            if (this.connectionHeaderWithLength != null) {
                ReferenceCountUtil.safeRelease(this.connectionHeaderWithLength);
                this.connectionHeaderWithLength = null;
            }
        });
    }

    private void established(Channel ch) throws IOException {
        assert (this.eventLoop.inEventLoop());
        ChannelPipeline p2 = ch.pipeline();
        String addBeforeHandler = p2.context(BufferCallBeforeInitHandler.class).name();
        p2.addBefore(addBeforeHandler, null, new IdleStateHandler(0L, this.rpcClient.minIdleTimeBeforeClose, 0L, TimeUnit.MILLISECONDS));
        p2.addBefore(addBeforeHandler, null, new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4));
        p2.addBefore(addBeforeHandler, null, new NettyRpcDuplexHandler(this, this.rpcClient.cellBlockBuilder, this.codec, this.compressor));
        p2.fireUserEventTriggered(BufferCallBeforeInitHandler.BufferCallEvent.success());
    }

    private void scheduleRelogin(Throwable error2) {
        assert (this.eventLoop.inEventLoop());
        if (error2 instanceof FallbackDisallowedException) {
            return;
        }
        if (!this.provider.canRetry()) {
            LOG.trace("SASL Provider does not support retries");
            return;
        }
        if (this.reloginInProgress) {
            return;
        }
        this.reloginInProgress = true;
        RELOGIN_EXECUTOR.schedule(() -> {
            try {
                this.provider.relogin();
            }
            catch (IOException e) {
                LOG.warn("Relogin failed", e);
            }
            this.eventLoop.execute(() -> {
                this.reloginInProgress = false;
            });
        }, (long)ThreadLocalRandom.current().nextInt(this.reloginMaxBackoff), TimeUnit.MILLISECONDS);
    }

    private void failInit(Channel ch, IOException e) {
        assert (this.eventLoop.inEventLoop());
        ch.pipeline().fireUserEventTriggered(BufferCallBeforeInitHandler.BufferCallEvent.fail(e));
        this.shutdown0();
    }

    private void saslNegotiate(final Channel ch) {
        NettyHBaseSaslRpcClientHandler saslHandler;
        assert (this.eventLoop.inEventLoop());
        UserGroupInformation ticket = this.provider.getRealUser(this.remoteId.getTicket());
        if (ticket == null) {
            this.failInit(ch, new FatalConnectionException("ticket/user is null"));
            return;
        }
        Promise<Boolean> saslPromise = ch.eventLoop().newPromise();
        try {
            saslHandler = new NettyHBaseSaslRpcClientHandler(saslPromise, ticket, this.provider, (Token<? extends TokenIdentifier>)this.token, this.serverAddress, this.securityInfo, this.rpcClient.fallbackAllowed, this.rpcClient.conf);
        }
        catch (IOException e) {
            this.failInit(ch, e);
            return;
        }
        ch.pipeline().addFirst(new SaslChallengeDecoder(), saslHandler);
        saslPromise.addListener((GenericFutureListener<Future<Boolean>>)new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (future.isSuccess()) {
                    ChannelPipeline p2 = ch.pipeline();
                    p2.remove(SaslChallengeDecoder.class);
                    p2.remove(NettyHBaseSaslRpcClientHandler.class);
                    if (saslHandler.isNeedProcessConnectionHeader()) {
                        Promise<Boolean> connectionHeaderPromise = ch.eventLoop().newPromise();
                        NettyHBaseRpcConnectionHeaderHandler chHandler = new NettyHBaseRpcConnectionHeaderHandler(connectionHeaderPromise, NettyRpcConnection.this.conf, NettyRpcConnection.this.connectionHeaderWithLength);
                        p2.addFirst(new ReadTimeoutHandler(20000L, TimeUnit.MILLISECONDS));
                        p2.addLast(chHandler);
                        connectionHeaderPromise.addListener((GenericFutureListener<Future<Boolean>>)new FutureListener<Boolean>(){

                            @Override
                            public void operationComplete(Future<Boolean> future) throws Exception {
                                if (future.isSuccess()) {
                                    ChannelPipeline p2 = ch.pipeline();
                                    p2.remove(ReadTimeoutHandler.class);
                                    p2.remove(NettyHBaseRpcConnectionHeaderHandler.class);
                                    NettyRpcConnection.this.established(ch);
                                } else {
                                    Throwable error2 = future.cause();
                                    NettyRpcConnection.this.scheduleRelogin(error2);
                                    NettyRpcConnection.this.failInit(ch, IPCUtil.toIOE(error2));
                                }
                            }
                        });
                    } else {
                        ch.write(NettyRpcConnection.this.connectionHeaderWithLength.retainedDuplicate());
                        NettyRpcConnection.this.established(ch);
                    }
                } else {
                    Throwable error2 = future.cause();
                    NettyRpcConnection.this.scheduleRelogin(error2);
                    NettyRpcConnection.this.failInit(ch, IPCUtil.toIOE(error2));
                }
            }
        });
    }

    private void connect() {
        assert (this.eventLoop.inEventLoop());
        LOG.trace("Connecting to {}", (Object)this.remoteId.address);
        this.channel = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoop)).channel(this.rpcClient.channelClass)).option(ChannelOption.TCP_NODELAY, this.rpcClient.isTcpNoDelay())).option(ChannelOption.SO_KEEPALIVE, this.rpcClient.tcpKeepAlive)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.rpcClient.connectTO)).handler(new BufferCallBeforeInitHandler())).localAddress(this.rpcClient.localAddr)).remoteAddress(this.remoteId.address).connect().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                Channel ch = future.channel();
                if (!future.isSuccess()) {
                    NettyRpcConnection.this.failInit(ch, IPCUtil.toIOE(future.cause()));
                    ((NettyRpcConnection)NettyRpcConnection.this).rpcClient.failedServers.addToFailedServers(NettyRpcConnection.this.remoteId.address, future.cause());
                    return;
                }
                ch.writeAndFlush(NettyRpcConnection.this.connectionHeaderPreamble.retainedDuplicate());
                if (NettyRpcConnection.this.useSasl) {
                    NettyRpcConnection.this.saslNegotiate(ch);
                } else {
                    ch.write(NettyRpcConnection.this.connectionHeaderWithLength.retainedDuplicate());
                    NettyRpcConnection.this.established(ch);
                }
            }
        }).channel();
    }

    private void sendRequest0(final Call call2, HBaseRpcController hrc) throws IOException {
        assert (this.eventLoop.inEventLoop());
        if (this.reloginInProgress) {
            throw new IOException("Can not send request because relogin is in progress.");
        }
        hrc.notifyOnCancel(new RpcCallback<Object>(){

            @Override
            public void run(Object parameter) {
                IPCUtil.setCancelled(call2);
                if (NettyRpcConnection.this.channel != null) {
                    NettyRpcConnection.this.channel.pipeline().fireUserEventTriggered(new CallEvent(CallEvent.Type.CANCELLED, call2));
                }
            }
        }, new HBaseRpcController.CancellationCallback(){

            @Override
            public void run(boolean cancelled) throws IOException {
                if (cancelled) {
                    IPCUtil.setCancelled(call2);
                } else {
                    if (NettyRpcConnection.this.channel == null) {
                        NettyRpcConnection.this.connect();
                    }
                    NettyRpcConnection.this.scheduleTimeoutTask(call2);
                    NettyRpcConnection.this.channel.writeAndFlush(call2).addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (!future.isSuccess()) {
                                call2.setException(IPCUtil.toIOE(future.cause()));
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public void sendRequest(Call call2, HBaseRpcController hrc) {
        IPCUtil.execute(this.eventLoop, () -> {
            try {
                this.sendRequest0(call2, hrc);
            }
            catch (Exception e) {
                call2.setException(IPCUtil.toIOE(e));
            }
        });
    }
}

