/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.metrics.MetricsInfoImpl;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.hbase.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class Interns {
    private static LoadingCache<String, ConcurrentHashMap<String, MetricsInfo>> infoCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build(new CacheLoader<String, ConcurrentHashMap<String, MetricsInfo>>(){

        @Override
        public ConcurrentHashMap<String, MetricsInfo> load(String key2) {
            return new ConcurrentHashMap<String, MetricsInfo>();
        }
    });
    private static LoadingCache<MetricsInfo, ConcurrentHashMap<String, MetricsTag>> tagCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build(new CacheLoader<MetricsInfo, ConcurrentHashMap<String, MetricsTag>>(){

        @Override
        public ConcurrentHashMap<String, MetricsTag> load(MetricsInfo key2) {
            return new ConcurrentHashMap<String, MetricsTag>();
        }
    });

    private Interns() {
    }

    public static MetricsInfo info(String name2, String description) {
        Map map = infoCache.getUnchecked(name2);
        MetricsInfo info = (MetricsInfo)map.get(description);
        if (info == null) {
            info = new MetricsInfoImpl(name2, description);
            map.put(description, info);
        }
        return info;
    }

    public static MetricsTag tag(MetricsInfo info, String value2) {
        Map map = tagCache.getUnchecked(info);
        MetricsTag tag2 = (MetricsTag)map.get(value2);
        if (tag2 == null) {
            tag2 = new MetricsTag(info, value2);
            map.put(value2, tag2);
        }
        return tag2;
    }

    public static MetricsTag tag(String name2, String description, String value2) {
        return Interns.tag(Interns.info(name2, description), value2);
    }
}

