/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfigBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ReplicationPeerConfig {
    private String clusterKey;
    private String replicationEndpointImpl;
    private final Map<byte[], byte[]> peerData;
    private final Map<String, String> configuration;
    private Map<TableName, ? extends Collection<String>> tableCFsMap = null;
    private Set<String> namespaces = null;
    private boolean replicateAllUserTables = true;
    private Map<TableName, ? extends Collection<String>> excludeTableCFsMap = null;
    private Set<String> excludeNamespaces = null;
    private long bandwidth = 0L;
    private final boolean serial;

    private ReplicationPeerConfig(ReplicationPeerConfigBuilderImpl builder) {
        this.clusterKey = builder.clusterKey;
        this.replicationEndpointImpl = builder.replicationEndpointImpl;
        this.peerData = Collections.unmodifiableMap(builder.peerData);
        this.configuration = Collections.unmodifiableMap(builder.configuration);
        this.tableCFsMap = builder.tableCFsMap != null ? this.unmodifiableTableCFsMap(builder.tableCFsMap) : null;
        this.namespaces = builder.namespaces != null ? Collections.unmodifiableSet(builder.namespaces) : null;
        this.replicateAllUserTables = builder.replicateAllUserTables;
        this.excludeTableCFsMap = builder.excludeTableCFsMap != null ? this.unmodifiableTableCFsMap(builder.excludeTableCFsMap) : null;
        this.excludeNamespaces = builder.excludeNamespaces != null ? Collections.unmodifiableSet(builder.excludeNamespaces) : null;
        this.bandwidth = builder.bandwidth;
        this.serial = builder.serial;
    }

    private Map<TableName, List<String>> unmodifiableTableCFsMap(Map<TableName, List<String>> tableCFsMap) {
        HashMap newTableCFsMap = new HashMap();
        tableCFsMap.forEach((table, cfs) -> newTableCFsMap.put(table, cfs != null ? Collections.unmodifiableList(cfs) : null));
        return Collections.unmodifiableMap(newTableCFsMap);
    }

    @Deprecated
    public ReplicationPeerConfig() {
        this.peerData = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
        this.configuration = new HashMap<String, String>(0);
        this.serial = false;
    }

    @Deprecated
    public ReplicationPeerConfig setClusterKey(String clusterKey) {
        this.clusterKey = clusterKey;
        return this;
    }

    @Deprecated
    public ReplicationPeerConfig setReplicationEndpointImpl(String replicationEndpointImpl) {
        this.replicationEndpointImpl = replicationEndpointImpl;
        return this;
    }

    public String getClusterKey() {
        return this.clusterKey;
    }

    public String getReplicationEndpointImpl() {
        return this.replicationEndpointImpl;
    }

    public Map<byte[], byte[]> getPeerData() {
        return this.peerData;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public Map<TableName, List<String>> getTableCFsMap() {
        return this.tableCFsMap;
    }

    @Deprecated
    public ReplicationPeerConfig setTableCFsMap(Map<TableName, ? extends Collection<String>> tableCFsMap) {
        this.tableCFsMap = tableCFsMap;
        return this;
    }

    public Set<String> getNamespaces() {
        return this.namespaces;
    }

    @Deprecated
    public ReplicationPeerConfig setNamespaces(Set<String> namespaces) {
        this.namespaces = namespaces;
        return this;
    }

    public long getBandwidth() {
        return this.bandwidth;
    }

    @Deprecated
    public ReplicationPeerConfig setBandwidth(long bandwidth) {
        this.bandwidth = bandwidth;
        return this;
    }

    public boolean replicateAllUserTables() {
        return this.replicateAllUserTables;
    }

    @Deprecated
    public ReplicationPeerConfig setReplicateAllUserTables(boolean replicateAllUserTables) {
        this.replicateAllUserTables = replicateAllUserTables;
        return this;
    }

    public Map<TableName, List<String>> getExcludeTableCFsMap() {
        return this.excludeTableCFsMap;
    }

    @Deprecated
    public ReplicationPeerConfig setExcludeTableCFsMap(Map<TableName, ? extends Collection<String>> tableCFsMap) {
        this.excludeTableCFsMap = tableCFsMap;
        return this;
    }

    public Set<String> getExcludeNamespaces() {
        return this.excludeNamespaces;
    }

    @Deprecated
    public ReplicationPeerConfig setExcludeNamespaces(Set<String> namespaces) {
        this.excludeNamespaces = namespaces;
        return this;
    }

    public static ReplicationPeerConfigBuilder newBuilder() {
        return new ReplicationPeerConfigBuilderImpl();
    }

    public boolean isSerial() {
        return this.serial;
    }

    public static ReplicationPeerConfigBuilder newBuilder(ReplicationPeerConfig peerConfig) {
        ReplicationPeerConfigBuilderImpl builder = new ReplicationPeerConfigBuilderImpl();
        builder.setClusterKey(peerConfig.getClusterKey()).setReplicationEndpointImpl(peerConfig.getReplicationEndpointImpl()).putAllPeerData(peerConfig.getPeerData()).putAllConfiguration(peerConfig.getConfiguration()).setTableCFsMap(peerConfig.getTableCFsMap()).setNamespaces(peerConfig.getNamespaces()).setReplicateAllUserTables(peerConfig.replicateAllUserTables()).setExcludeTableCFsMap(peerConfig.getExcludeTableCFsMap()).setExcludeNamespaces(peerConfig.getExcludeNamespaces()).setBandwidth(peerConfig.getBandwidth()).setSerial(peerConfig.isSerial());
        return builder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("clusterKey=").append(this.clusterKey).append(",");
        builder.append("replicationEndpointImpl=").append(this.replicationEndpointImpl).append(",");
        builder.append("replicateAllUserTables=").append(this.replicateAllUserTables).append(",");
        if (this.replicateAllUserTables) {
            if (this.excludeNamespaces != null) {
                builder.append("excludeNamespaces=").append(this.excludeNamespaces.toString()).append(",");
            }
            if (this.excludeTableCFsMap != null) {
                builder.append("excludeTableCFsMap=").append(this.excludeTableCFsMap.toString()).append(",");
            }
        } else {
            if (this.namespaces != null) {
                builder.append("namespaces=").append(this.namespaces.toString()).append(",");
            }
            if (this.tableCFsMap != null) {
                builder.append("tableCFs=").append(this.tableCFsMap.toString()).append(",");
            }
        }
        builder.append("bandwidth=").append(this.bandwidth).append(",");
        builder.append("serial=").append(this.serial);
        return builder.toString();
    }

    public boolean needToReplicate(TableName table) {
        return this.needToReplicate(table, null);
    }

    public boolean needToReplicate(TableName table, byte[] family) {
        String namespace = table.getNamespaceAsString();
        if (this.replicateAllUserTables) {
            if (this.excludeNamespaces != null && this.excludeNamespaces.contains(namespace)) {
                return false;
            }
            if (this.excludeTableCFsMap == null || !this.excludeTableCFsMap.containsKey(table)) {
                return true;
            }
            Collection<String> cfs = this.excludeTableCFsMap.get(table);
            return cfs != null && !cfs.isEmpty() && (family == null || !cfs.contains(Bytes.toString(family)));
        }
        if (this.namespaces == null && this.tableCFsMap == null) {
            return false;
        }
        if (this.namespaces != null && this.namespaces.contains(namespace)) {
            return true;
        }
        return this.tableCFsMap != null && this.tableCFsMap.containsKey(table) && (family == null || CollectionUtils.isEmpty(this.tableCFsMap.get(table)) || this.tableCFsMap.get(table).contains(Bytes.toString(family)));
    }

    static class ReplicationPeerConfigBuilderImpl
    implements ReplicationPeerConfigBuilder {
        private String clusterKey;
        private String replicationEndpointImpl;
        private Map<byte[], byte[]> peerData = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
        private Map<String, String> configuration = new HashMap<String, String>();
        private Map<TableName, List<String>> tableCFsMap = null;
        private Set<String> namespaces = null;
        private boolean replicateAllUserTables = true;
        private Map<TableName, List<String>> excludeTableCFsMap = null;
        private Set<String> excludeNamespaces = null;
        private long bandwidth = 0L;
        private boolean serial = false;

        ReplicationPeerConfigBuilderImpl() {
        }

        @Override
        public ReplicationPeerConfigBuilder setClusterKey(String clusterKey) {
            this.clusterKey = clusterKey;
            return this;
        }

        @Override
        public ReplicationPeerConfigBuilder setReplicationEndpointImpl(String replicationEndpointImpl) {
            this.replicationEndpointImpl = replicationEndpointImpl;
            return this;
        }

        @Override
        public ReplicationPeerConfigBuilder putConfiguration(String key2, String value2) {
            this.configuration.put(key2, value2);
            return this;
        }

        @Override
        public ReplicationPeerConfigBuilder removeConfiguration(String key2) {
            this.configuration.remove(key2);
            return this;
        }

        @Override
        public ReplicationPeerConfigBuilder putPeerData(byte[] key2, byte[] value2) {
            this.peerData.put(key2, value2);
            return this;
        }

        @Override
        public ReplicationPeerConfigBuilder setTableCFsMap(Map<TableName, List<String>> tableCFsMap) {
            this.tableCFsMap = tableCFsMap;
            return this;
        }

        @Override
        public ReplicationPeerConfigBuilder setNamespaces(Set<String> namespaces) {
            this.namespaces = namespaces;
            return this;
        }

        @Override
        public ReplicationPeerConfigBuilder setReplicateAllUserTables(boolean replicateAllUserTables) {
            this.replicateAllUserTables = replicateAllUserTables;
            return this;
        }

        @Override
        public ReplicationPeerConfigBuilder setExcludeTableCFsMap(Map<TableName, List<String>> excludeTableCFsMap) {
            this.excludeTableCFsMap = excludeTableCFsMap;
            return this;
        }

        @Override
        public ReplicationPeerConfigBuilder setExcludeNamespaces(Set<String> excludeNamespaces) {
            this.excludeNamespaces = excludeNamespaces;
            return this;
        }

        @Override
        public ReplicationPeerConfigBuilder setBandwidth(long bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        @Override
        public ReplicationPeerConfigBuilder setSerial(boolean serial) {
            this.serial = serial;
            return this;
        }

        @Override
        public ReplicationPeerConfig build() {
            return new ReplicationPeerConfig(this);
        }
    }
}

