/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class Superusers {
    private static final Logger LOG = LoggerFactory.getLogger(Superusers.class);
    public static final String SUPERUSER_CONF_KEY = "hbase.superuser";
    private static Set<String> superUsers;
    private static Set<String> superGroups;
    private static User systemUser;

    private Superusers() {
    }

    public static void initialize(Configuration conf) throws IOException {
        String[] superUserList;
        superUsers = new HashSet<String>();
        superGroups = new HashSet<String>();
        systemUser = User.getCurrent();
        if (systemUser == null) {
            throw new IllegalStateException("Unable to obtain the current user, authorization checks for internal operations will not work correctly!");
        }
        String currentUser = systemUser.getShortName();
        LOG.trace("Current user name is {}", (Object)currentUser);
        superUsers.add(currentUser);
        for (String name2 : superUserList = conf.getStrings(SUPERUSER_CONF_KEY, new String[0])) {
            if (AuthUtil.isGroupPrincipal(name2)) {
                superGroups.add(name2);
                continue;
            }
            superUsers.add(name2);
        }
    }

    public static boolean isSuperUser(User user) {
        if (superUsers == null) {
            throw new IllegalStateException("Super users/super groups lists have not been initialized properly.");
        }
        if (user == null) {
            throw new IllegalArgumentException("Null user passed for super user check");
        }
        if (superUsers.contains(user.getShortName())) {
            return true;
        }
        for (String group2 : user.getGroupNames()) {
            if (!superGroups.contains(AuthUtil.toGroupEntry(group2))) continue;
            return true;
        }
        return false;
    }

    public static boolean isSuperUser(String user) {
        return superUsers.contains(user) || superGroups.contains(user);
    }

    public static Collection<String> getSuperUsers() {
        return superUsers;
    }

    public static Collection<String> getSuperGroups() {
        return superGroups;
    }

    public static User getSystemUser() {
        return systemUser;
    }
}

