/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class AbstractByteRange
implements ByteRange {
    public static final int UNSET_HASH_VALUE = -1;
    protected byte[] bytes;
    protected int offset;
    protected int length;
    protected int hash = -1;

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public ByteRange set(int capacity) {
        return this.set(new byte[capacity]);
    }

    @Override
    public ByteRange set(byte[] bytes2) {
        if (null == bytes2) {
            return this.unset();
        }
        this.clearHashCache();
        this.bytes = bytes2;
        this.offset = 0;
        this.length = bytes2.length;
        return this;
    }

    @Override
    public ByteRange set(byte[] bytes2, int offset2, int length2) {
        if (null == bytes2) {
            return this.unset();
        }
        this.clearHashCache();
        this.bytes = bytes2;
        this.offset = offset2;
        this.length = length2;
        return this;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public ByteRange setOffset(int offset2) {
        this.clearHashCache();
        this.offset = offset2;
        return this;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public ByteRange setLength(int length2) {
        this.clearHashCache();
        this.length = length2;
        return this;
    }

    @Override
    public boolean isEmpty() {
        return AbstractByteRange.isEmpty(this);
    }

    public static boolean isEmpty(ByteRange range) {
        return range == null || range.getLength() == 0;
    }

    @Override
    public byte get(int index2) {
        return this.bytes[this.offset + index2];
    }

    @Override
    public ByteRange get(int index2, byte[] dst) {
        if (0 == dst.length) {
            return this;
        }
        return this.get(index2, dst, 0, dst.length);
    }

    @Override
    public ByteRange get(int index2, byte[] dst, int offset2, int length2) {
        if (0 == length2) {
            return this;
        }
        System.arraycopy(this.bytes, this.offset + index2, dst, offset2, length2);
        return this;
    }

    @Override
    public short getShort(int index2) {
        int offset2 = this.offset + index2;
        short n = 0;
        n = (short)((n ^ this.bytes[offset2]) & 0xFF);
        n = (short)(n << 8);
        n = (short)((n ^ this.bytes[offset2 + 1]) & 0xFF);
        return n;
    }

    @Override
    public int getInt(int index2) {
        int offset2 = this.offset + index2;
        int n = 0;
        for (int i2 = offset2; i2 < offset2 + 4; ++i2) {
            n <<= 8;
            n ^= this.bytes[i2] & 0xFF;
        }
        return n;
    }

    @Override
    public long getLong(int index2) {
        int offset2 = this.offset + index2;
        long l = 0L;
        for (int i2 = offset2; i2 < offset2 + 8; ++i2) {
            l <<= 8;
            l ^= (long)(this.bytes[i2] & 0xFF);
        }
        return l;
    }

    @Override
    public long getVLong(int index2) {
        long result2 = 0L;
        for (int shift2 = 0; shift2 < 64; shift2 += 7) {
            byte b = this.get(index2++);
            result2 |= (long)(b & 0x7F) << shift2;
            if ((b & 0x80) == 0) break;
        }
        return result2;
    }

    public static int getVLongSize(long val) {
        int rPos = 0;
        while ((val & 0xFFFFFFFFFFFFFF80L) != 0L) {
            val >>>= 7;
            ++rPos;
        }
        return rPos + 1;
    }

    @Override
    public byte[] deepCopyToNewArray() {
        byte[] result2 = new byte[this.length];
        System.arraycopy(this.bytes, this.offset, result2, 0, this.length);
        return result2;
    }

    @Override
    public void deepCopyTo(byte[] destination, int destinationOffset) {
        System.arraycopy(this.bytes, this.offset, destination, destinationOffset, this.length);
    }

    @Override
    public void deepCopySubRangeTo(int innerOffset, int copyLength, byte[] destination, int destinationOffset) {
        System.arraycopy(this.bytes, this.offset + innerOffset, destination, destinationOffset, copyLength);
    }

    public int hashCode() {
        if (this.isHashCached()) {
            return this.hash;
        }
        if (this.isEmpty()) {
            this.hash = 0;
            return this.hash;
        }
        int off = this.offset;
        this.hash = 0;
        for (int i2 = 0; i2 < this.length; ++i2) {
            this.hash = 31 * this.hash + this.bytes[off++];
        }
        return this.hash;
    }

    protected boolean isHashCached() {
        return this.hash != -1;
    }

    protected void clearHashCache() {
        this.hash = -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteRange)) {
            return false;
        }
        return this.compareTo((ByteRange)obj) == 0;
    }

    @Override
    public int compareTo(ByteRange other) {
        return Bytes.compareTo(this.bytes, this.offset, this.length, other.getBytes(), other.getOffset(), other.getLength());
    }

    public String toString() {
        return Bytes.toStringBinary(this.bytes, this.offset, this.length);
    }
}

