/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class Addressing {
    public static final String VALID_PORT_REGEX = "[\\d]+";
    public static final String HOSTNAME_PORT_SEPARATOR = ":";

    public static InetSocketAddress createInetSocketAddressFromHostAndPortStr(String hostAndPort) {
        return new InetSocketAddress(Addressing.parseHostname(hostAndPort), Addressing.parsePort(hostAndPort));
    }

    public static String createHostAndPortStr(String hostname, int port) {
        return hostname + HOSTNAME_PORT_SEPARATOR + port;
    }

    public static String parseHostname(String hostAndPort) {
        int colonIndex = hostAndPort.lastIndexOf(HOSTNAME_PORT_SEPARATOR);
        if (colonIndex < 0) {
            throw new IllegalArgumentException("Not a host:port pair: " + hostAndPort);
        }
        return hostAndPort.substring(0, colonIndex);
    }

    public static int parsePort(String hostAndPort) {
        int colonIndex = hostAndPort.lastIndexOf(HOSTNAME_PORT_SEPARATOR);
        if (colonIndex < 0) {
            throw new IllegalArgumentException("Not a host:port pair: " + hostAndPort);
        }
        return Integer.parseInt(hostAndPort.substring(colonIndex + 1));
    }

    public static InetAddress getIpAddress() throws SocketException {
        return Addressing.getIpAddress(new AddressSelectionCondition(){

            @Override
            public boolean isAcceptableAddress(InetAddress addr2) {
                return addr2 instanceof Inet4Address || addr2 instanceof Inet6Address;
            }
        });
    }

    public static InetAddress getIp4Address() throws SocketException {
        return Addressing.getIpAddress(new AddressSelectionCondition(){

            @Override
            public boolean isAcceptableAddress(InetAddress addr2) {
                return addr2 instanceof Inet4Address;
            }
        });
    }

    public static InetAddress getIp6Address() throws SocketException {
        return Addressing.getIpAddress(new AddressSelectionCondition(){

            @Override
            public boolean isAcceptableAddress(InetAddress addr2) {
                return addr2 instanceof Inet6Address;
            }
        });
    }

    private static InetAddress getIpAddress(AddressSelectionCondition condition) throws SocketException {
        Enumeration<NetworkInterface> interfaces2 = NetworkInterface.getNetworkInterfaces();
        while (interfaces2.hasMoreElements()) {
            NetworkInterface current2 = interfaces2.nextElement();
            if (!current2.isUp() || current2.isLoopback() || current2.isVirtual()) continue;
            Enumeration<InetAddress> addresses = current2.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress addr2 = addresses.nextElement();
                if (addr2.isLoopbackAddress() || !condition.isAcceptableAddress(addr2)) continue;
                return addr2;
            }
        }
        throw new SocketException("Can't get our ip address, interfaces are: " + interfaces2);
    }

    public static boolean isLocalAddress(InetAddress addr2) {
        boolean local;
        boolean bl = local = addr2.isAnyLocalAddress() || addr2.isLoopbackAddress();
        if (!local) {
            try {
                local = NetworkInterface.getByInetAddress(addr2) != null;
            }
            catch (SocketException e) {
                local = false;
            }
        }
        return local;
    }

    public static String inetSocketAddress2String(InetSocketAddress address2) {
        return address2.isUnresolved() ? address2.toString().replace("/<unresolved>", "") : address2.toString();
    }

    public static interface AddressSelectionCondition {
        public boolean isAcceptableAddress(InetAddress var1);
    }
}

