/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.ByteBufferWriter;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.UnsafeAccess;
import org.apache.hadoop.hbase.util.UnsafeAvailChecker;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.WritableUtils;
import org.apache.yetus.audience.InterfaceAudience;
import sun.nio.ch.DirectBuffer;

@Deprecated
@InterfaceAudience.Public
public final class ByteBufferUtils {
    public static final int VALUE_MASK = 127;
    public static final int NEXT_BIT_SHIFT = 7;
    public static final int NEXT_BIT_MASK = 128;
    @InterfaceAudience.Private
    static final boolean UNSAFE_AVAIL = UnsafeAvailChecker.isAvailable();
    public static final boolean UNSAFE_UNALIGNED = UnsafeAvailChecker.unaligned();

    private ByteBufferUtils() {
    }

    public static void writeVLong(ByteBuffer out, long i2) {
        if (i2 >= -112L && i2 <= 127L) {
            out.put((byte)i2);
            return;
        }
        int len = -112;
        if (i2 < 0L) {
            i2 ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = i2;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        out.put((byte)len);
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            out.put((byte)((i2 & mask) >> shiftbits));
        }
    }

    private static long readVLong(ByteVisitor visitor) {
        byte firstByte = visitor.get();
        int len = WritableUtils.decodeVIntSize((byte)firstByte);
        if (len == 1) {
            return firstByte;
        }
        long i2 = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = visitor.get();
            i2 <<= 8;
            i2 |= (long)(b & 0xFF);
        }
        return WritableUtils.isNegativeVInt((byte)firstByte) ? i2 ^ 0xFFFFFFFFFFFFFFFFL : i2;
    }

    public static long readVLong(ByteBuffer in) {
        return ByteBufferUtils.readVLong(in::get);
    }

    public static long readVLong(ByteBuff in) {
        return ByteBufferUtils.readVLong(in::get);
    }

    public static int putCompressedInt(OutputStream out, int value2) throws IOException {
        int i2 = 0;
        int tmpvalue = value2;
        do {
            byte b = (byte)(tmpvalue & 0x7F);
            if ((tmpvalue >>>= 7) != 0) {
                b = (byte)(b | 0xFFFFFF80);
            }
            out.write(b);
            ++i2;
        } while (tmpvalue != 0);
        return i2;
    }

    public static void putInt(OutputStream out, int value2) throws IOException {
        if (out instanceof ByteBufferWriter) {
            ((ByteBufferWriter)((Object)out)).writeInt(value2);
        } else {
            StreamUtils.writeInt(out, value2);
        }
    }

    public static byte toByte(ByteBuffer buffer, int offset2) {
        if (UNSAFE_AVAIL) {
            return UnsafeAccess.toByte(buffer, offset2);
        }
        return buffer.get(offset2);
    }

    public static void moveBufferToStream(OutputStream out, ByteBuffer in, int length2) throws IOException {
        ByteBufferUtils.copyBufferToStream(out, in, in.position(), length2);
        ByteBufferUtils.skip(in, length2);
    }

    public static void copyBufferToStream(OutputStream out, ByteBuffer in, int offset2, int length2) throws IOException {
        if (out instanceof ByteBufferWriter) {
            ((ByteBufferWriter)((Object)out)).write(in, offset2, length2);
        } else if (in.hasArray()) {
            out.write(in.array(), in.arrayOffset() + offset2, length2);
        } else {
            for (int i2 = 0; i2 < length2; ++i2) {
                out.write(ByteBufferUtils.toByte(in, offset2 + i2));
            }
        }
    }

    public static void copyBufferToStream(DataOutput out, ByteBuffer in, int offset2, int length2) throws IOException {
        if (out instanceof ByteBufferWriter) {
            ((ByteBufferWriter)((Object)out)).write(in, offset2, length2);
        } else if (in.hasArray()) {
            out.write(in.array(), in.arrayOffset() + offset2, length2);
        } else {
            for (int i2 = 0; i2 < length2; ++i2) {
                out.write(ByteBufferUtils.toByte(in, offset2 + i2));
            }
        }
    }

    public static int putLong(OutputStream out, long value2, int fitInBytes) throws IOException {
        long tmpValue = value2;
        for (int i2 = 0; i2 < fitInBytes; ++i2) {
            out.write((byte)(tmpValue & 0xFFL));
            tmpValue >>>= 8;
        }
        return fitInBytes;
    }

    public static int putByte(ByteBuffer buffer, int offset2, byte b) {
        if (UNSAFE_AVAIL) {
            return UnsafeAccess.putByte(buffer, offset2, b);
        }
        buffer.put(offset2, b);
        return offset2 + 1;
    }

    public static int longFitsIn(long value2) {
        if (value2 < 0L) {
            return 8;
        }
        if (value2 < 0x100000000L) {
            if (value2 < 65536L) {
                if (value2 < 256L) {
                    return 1;
                }
                return 2;
            }
            if (value2 < 0x1000000L) {
                return 3;
            }
            return 4;
        }
        if (value2 < 0x1000000000000L) {
            if (value2 < 0x10000000000L) {
                return 5;
            }
            return 6;
        }
        if (value2 < 0x100000000000000L) {
            return 7;
        }
        return 8;
    }

    public static int intFitsIn(int value2) {
        if (value2 < 0) {
            return 4;
        }
        if (value2 < 65536) {
            if (value2 < 256) {
                return 1;
            }
            return 2;
        }
        if (value2 <= 0x1000000) {
            return 3;
        }
        return 4;
    }

    public static int readCompressedInt(InputStream input) throws IOException {
        byte b;
        int result2 = 0;
        int i2 = 0;
        do {
            b = (byte)input.read();
            result2 += (b & 0x7F) << 7 * i2;
            if (++i2 <= 5) continue;
            throw new IllegalStateException("Corrupted compressed int (too long: " + (i2 + 1) + " bytes)");
        } while (0 != (b & 0x80));
        return result2;
    }

    public static int readCompressedInt(ByteBuffer buffer) {
        byte b = buffer.get();
        if ((b & 0x80) != 0) {
            return (b & 0x7F) + (ByteBufferUtils.readCompressedInt(buffer) << 7);
        }
        return b & 0x7F;
    }

    public static long readLong(InputStream in, int fitInBytes) throws IOException {
        long tmpLong = 0L;
        for (int i2 = 0; i2 < fitInBytes; ++i2) {
            tmpLong |= ((long)in.read() & 0xFFL) << 8 * i2;
        }
        return tmpLong;
    }

    public static long readLong(ByteBuffer in, int fitInBytes) {
        long tmpLength = 0L;
        for (int i2 = 0; i2 < fitInBytes; ++i2) {
            tmpLength |= ((long)in.get() & 0xFFL) << (int)(8L * (long)i2);
        }
        return tmpLength;
    }

    public static void copyFromStreamToBuffer(ByteBuffer out, DataInputStream in, int length2) throws IOException {
        if (out.hasArray()) {
            in.readFully(out.array(), out.position() + out.arrayOffset(), length2);
            ByteBufferUtils.skip(out, length2);
        } else {
            for (int i2 = 0; i2 < length2; ++i2) {
                out.put(in.readByte());
            }
        }
    }

    public static ByteBuffer drainInputStreamToBuffer(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        IOUtils.copyBytes((InputStream)is, (OutputStream)baos, (int)4096, (boolean)true);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        buffer.rewind();
        return buffer;
    }

    public static void copyFromBufferToBuffer(ByteBuffer in, ByteBuffer out) {
        if (in.hasArray() && out.hasArray()) {
            int length2 = in.remaining();
            System.arraycopy(in.array(), in.arrayOffset(), out.array(), out.arrayOffset(), length2);
            out.position(out.position() + length2);
            in.position(in.limit());
        } else if (UNSAFE_AVAIL) {
            int length3 = in.remaining();
            UnsafeAccess.copy(in, in.position(), out, out.position(), length3);
            out.position(out.position() + length3);
            in.position(in.limit());
        } else {
            out.put(in);
        }
    }

    public static void copyFromBufferToBuffer(ByteBuffer in, ByteBuffer out, int sourceOffset, int destinationOffset, int length2) {
        if (in.hasArray() && out.hasArray()) {
            System.arraycopy(in.array(), sourceOffset + in.arrayOffset(), out.array(), out.arrayOffset() + destinationOffset, length2);
        } else if (UNSAFE_AVAIL) {
            UnsafeAccess.copy(in, sourceOffset, out, destinationOffset, length2);
        } else {
            ByteBuffer outDup = out.duplicate();
            outDup.position(destinationOffset);
            ByteBuffer inDup = in.duplicate();
            inDup.position(sourceOffset).limit(sourceOffset + length2);
            outDup.put(inDup);
        }
    }

    public static void copyFromBufferToBuffer(ByteBuffer in, ByteBuffer out, int sourceOffset, int length2) {
        if (in.hasArray() && out.hasArray()) {
            System.arraycopy(in.array(), sourceOffset + in.arrayOffset(), out.array(), out.position() + out.arrayOffset(), length2);
            ByteBufferUtils.skip(out, length2);
        } else if (UNSAFE_AVAIL) {
            UnsafeAccess.copy(in, sourceOffset, out, out.position(), length2);
            ByteBufferUtils.skip(out, length2);
        } else {
            ByteBuffer inDup = in.duplicate();
            inDup.position(sourceOffset).limit(sourceOffset + length2);
            out.put(inDup);
        }
    }

    public static int findCommonPrefix(ByteBuffer buffer, int offsetLeft, int offsetRight, int limit2) {
        int prefix;
        for (prefix = 0; prefix < limit2 && buffer.get(offsetLeft + prefix) == buffer.get(offsetRight + prefix); ++prefix) {
        }
        return prefix;
    }

    public static int findCommonPrefix(byte[] left, int leftOffset, int leftLength, byte[] right, int rightOffset, int rightLength) {
        int result2;
        int length2 = Math.min(leftLength, rightLength);
        for (result2 = 0; result2 < length2 && left[leftOffset + result2] == right[rightOffset + result2]; ++result2) {
        }
        return result2;
    }

    public static int findCommonPrefix(ByteBuffer left, int leftOffset, int leftLength, ByteBuffer right, int rightOffset, int rightLength) {
        int result2;
        int length2 = Math.min(leftLength, rightLength);
        for (result2 = 0; result2 < length2 && ByteBufferUtils.toByte(left, leftOffset + result2) == ByteBufferUtils.toByte(right, rightOffset + result2); ++result2) {
        }
        return result2;
    }

    public static boolean arePartsEqual(ByteBuffer buffer, int offsetLeft, int lengthLeft, int offsetRight, int lengthRight) {
        if (lengthLeft != lengthRight) {
            return false;
        }
        if (buffer.hasArray()) {
            return 0 == Bytes.compareTo(buffer.array(), buffer.arrayOffset() + offsetLeft, lengthLeft, buffer.array(), buffer.arrayOffset() + offsetRight, lengthRight);
        }
        for (int i2 = 0; i2 < lengthRight; ++i2) {
            if (buffer.get(offsetLeft + i2) == buffer.get(offsetRight + i2)) continue;
            return false;
        }
        return true;
    }

    public static void skip(ByteBuffer buffer, int length2) {
        buffer.position(buffer.position() + length2);
    }

    public static void extendLimit(ByteBuffer buffer, int numBytes) {
        buffer.limit(buffer.limit() + numBytes);
    }

    public static byte[] toBytes(ByteBuffer buffer, int startPosition) {
        int originalPosition = buffer.position();
        byte[] output = new byte[buffer.limit() - startPosition];
        buffer.position(startPosition);
        buffer.get(output);
        buffer.position(originalPosition);
        return output;
    }

    public static byte[] toBytes(ByteBuffer buffer, int offset2, int length2) {
        byte[] output = new byte[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            output[i2] = buffer.get(offset2 + i2);
        }
        return output;
    }

    public static boolean equals(ByteBuffer buf1, int o1, int l1, ByteBuffer buf2, int o2, int l2) {
        if (l1 == 0 || l2 == 0) {
            return l1 == l2;
        }
        if (ByteBufferUtils.toByte(buf1, o1 + l1 - 1) != ByteBufferUtils.toByte(buf2, o2 + l2 - 1)) {
            return false;
        }
        return ByteBufferUtils.compareTo(buf1, o1, l1, buf2, o2, l2) == 0;
    }

    public static int hashCode(ByteBuffer buf, int offset2, int length2) {
        int hash2 = 1;
        for (int i2 = offset2; i2 < offset2 + length2; ++i2) {
            hash2 = 31 * hash2 + ByteBufferUtils.toByte(buf, i2);
        }
        return hash2;
    }

    public static int compareTo(ByteBuffer buf1, int o1, int l1, ByteBuffer buf2, int o2, int l2) {
        return ComparerHolder.BEST_COMPARER.compareTo(buf1, o1, l1, buf2, o2, l2);
    }

    public static boolean equals(ByteBuffer buf1, int o1, int l1, byte[] buf2, int o2, int l2) {
        if (l1 == 0 || l2 == 0) {
            return l1 == l2;
        }
        if (ByteBufferUtils.toByte(buf1, o1 + l1 - 1) != buf2[o2 + l2 - 1]) {
            return false;
        }
        return ByteBufferUtils.compareTo(buf1, o1, l1, buf2, o2, l2) == 0;
    }

    public static int compareTo(byte[] buf1, int o1, int l1, ByteBuffer buf2, int o2, int l2) {
        return ComparerHolder.BEST_COMPARER.compareTo(buf1, o1, l1, buf2, o2, l2);
    }

    public static int compareTo(ByteBuffer buf1, int o1, int l1, byte[] buf2, int o2, int l2) {
        return ByteBufferUtils.compareTo(buf2, o2, l2, buf1, o1, l1) * -1;
    }

    static int compareToUnsafe(Object obj1, long o1, int l1, Object obj2, long o2, int l2) {
        int i2;
        int stride = 8;
        int minLength = Math.min(l1, l2);
        int strideLimit = minLength & 0xFFFFFFF8;
        for (i2 = 0; i2 < strideLimit; i2 += 8) {
            long rw;
            long lw = UnsafeAccess.theUnsafe.getLong(obj1, o1 + (long)i2);
            if (lw == (rw = UnsafeAccess.theUnsafe.getLong(obj2, o2 + (long)i2))) continue;
            if (!UnsafeAccess.LITTLE_ENDIAN) {
                return lw + Long.MIN_VALUE < rw + Long.MIN_VALUE ? -1 : 1;
            }
            int n = Long.numberOfTrailingZeros(lw ^ rw) & 0xFFFFFFF8;
            return (int)(lw >>> n & 0xFFL) - (int)(rw >>> n & 0xFFL);
        }
        while (i2 < minLength) {
            int ir;
            int il = UnsafeAccess.theUnsafe.getByte(obj1, o1 + (long)i2) & 0xFF;
            if (il != (ir = UnsafeAccess.theUnsafe.getByte(obj2, o2 + (long)i2) & 0xFF)) {
                return il - ir;
            }
            ++i2;
        }
        return l1 - l2;
    }

    public static short toShort(ByteBuffer buffer, int offset2) {
        return ConverterHolder.BEST_CONVERTER.toShort(buffer, offset2);
    }

    public static int toInt(ByteBuffer buffer) {
        return ConverterHolder.BEST_CONVERTER.toInt(buffer);
    }

    public static int toInt(ByteBuffer buffer, int offset2) {
        return ConverterHolder.BEST_CONVERTER.toInt(buffer, offset2);
    }

    public static int readAsInt(ByteBuffer buf, int offset2, int length2) {
        if (offset2 + length2 > buf.limit()) {
            throw new IllegalArgumentException("offset (" + offset2 + ") + length (" + length2 + ") exceed the limit of the buffer: " + buf.limit());
        }
        int n = 0;
        for (int i2 = offset2; i2 < offset2 + length2; ++i2) {
            n <<= 8;
            n ^= ByteBufferUtils.toByte(buf, i2) & 0xFF;
        }
        return n;
    }

    public static long toLong(ByteBuffer buffer, int offset2) {
        return ConverterHolder.BEST_CONVERTER.toLong(buffer, offset2);
    }

    public static void putInt(ByteBuffer buffer, int val) {
        ConverterHolder.BEST_CONVERTER.putInt(buffer, val);
    }

    public static int putInt(ByteBuffer buffer, int index2, int val) {
        return ConverterHolder.BEST_CONVERTER.putInt(buffer, index2, val);
    }

    public static double toDouble(ByteBuffer buffer, int offset2) {
        return Double.longBitsToDouble(ByteBufferUtils.toLong(buffer, offset2));
    }

    public static BigDecimal toBigDecimal(ByteBuffer buffer, int offset2, int length2) {
        if (buffer == null || length2 < 5 || offset2 + length2 > buffer.limit()) {
            return null;
        }
        int scale = ByteBufferUtils.toInt(buffer, offset2);
        byte[] tcBytes = new byte[length2 - 4];
        ByteBufferUtils.copyFromBufferToArray(tcBytes, buffer, offset2 + 4, 0, length2 - 4);
        return new BigDecimal(new BigInteger(tcBytes), scale);
    }

    public static void putShort(ByteBuffer buffer, short val) {
        ConverterHolder.BEST_CONVERTER.putShort(buffer, val);
    }

    public static int putShort(ByteBuffer buffer, int index2, short val) {
        return ConverterHolder.BEST_CONVERTER.putShort(buffer, index2, val);
    }

    public static int putAsShort(ByteBuffer buf, int index2, int val) {
        buf.put(index2 + 1, (byte)val);
        buf.put(index2, (byte)(val >>= 8));
        return index2 + 2;
    }

    public static void putLong(ByteBuffer buffer, long val) {
        ConverterHolder.BEST_CONVERTER.putLong(buffer, val);
    }

    public static int putLong(ByteBuffer buffer, int index2, long val) {
        return ConverterHolder.BEST_CONVERTER.putLong(buffer, index2, val);
    }

    public static void copyFromArrayToBuffer(ByteBuffer out, byte[] in, int inOffset, int length2) {
        if (out.hasArray()) {
            System.arraycopy(in, inOffset, out.array(), out.arrayOffset() + out.position(), length2);
            out.position(out.position() + length2);
        } else if (UNSAFE_AVAIL) {
            UnsafeAccess.copy(in, inOffset, out, out.position(), length2);
            out.position(out.position() + length2);
        } else {
            out.put(in, inOffset, length2);
        }
    }

    public static void copyFromArrayToBuffer(ByteBuffer out, int outOffset, byte[] in, int inOffset, int length2) {
        if (out.hasArray()) {
            System.arraycopy(in, inOffset, out.array(), out.arrayOffset() + outOffset, length2);
        } else if (UNSAFE_AVAIL) {
            UnsafeAccess.copy(in, inOffset, out, outOffset, length2);
        } else {
            ByteBuffer outDup = out.duplicate();
            outDup.position(outOffset);
            outDup.put(in, inOffset, length2);
        }
    }

    public static void copyFromBufferToArray(byte[] out, ByteBuffer in, int sourceOffset, int destinationOffset, int length2) {
        if (in.hasArray()) {
            System.arraycopy(in.array(), sourceOffset + in.arrayOffset(), out, destinationOffset, length2);
        } else if (UNSAFE_AVAIL) {
            UnsafeAccess.copy(in, sourceOffset, out, destinationOffset, length2);
        } else {
            ByteBuffer inDup = in.duplicate();
            inDup.position(sourceOffset);
            inDup.get(out, destinationOffset, length2);
        }
    }

    public static byte[] copyOfRange(ByteBuffer original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        byte[] copy = new byte[newLength];
        ByteBufferUtils.copyFromBufferToArray(copy, original, from, 0, newLength);
        return copy;
    }

    public static String toStringBinary(ByteBuffer b, int off, int len) {
        StringBuilder result2 = new StringBuilder();
        if (off >= b.capacity()) {
            return result2.toString();
        }
        if (off + len > b.capacity()) {
            len = b.capacity() - off;
        }
        for (int i2 = off; i2 < off + len; ++i2) {
            int ch = b.get(i2) & 0xFF;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || " `~!@#$%^&*()-_=+[]{}|;:'\",.<>/?".indexOf(ch) >= 0) {
                result2.append((char)ch);
                continue;
            }
            result2.append(String.format("\\x%02X", ch));
        }
        return result2.toString();
    }

    public static String toStringBinary(ByteBuffer b) {
        return ByteBufferUtils.toStringBinary(b, 0, b.capacity());
    }

    private static interface ByteVisitor {
        public byte get();
    }

    static class ConverterHolder {
        static final String UNSAFE_CONVERTER_NAME = ConverterHolder.class.getName() + "$UnsafeConverter";
        static final Converter BEST_CONVERTER = ConverterHolder.getBestConverter();

        ConverterHolder() {
        }

        static Converter getBestConverter() {
            try {
                Class<?> theClass = Class.forName(UNSAFE_CONVERTER_NAME);
                Converter converter = (Converter)theClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                return converter;
            }
            catch (Throwable t) {
                return PureJavaConverter.INSTANCE;
            }
        }

        static final class UnsafeConverter
        extends Converter {
            @Override
            short toShort(ByteBuffer buffer, int offset2) {
                return UnsafeAccess.toShort(buffer, offset2);
            }

            @Override
            int toInt(ByteBuffer buffer) {
                int i2 = UnsafeAccess.toInt(buffer, buffer.position());
                buffer.position(buffer.position() + 4);
                return i2;
            }

            @Override
            int toInt(ByteBuffer buffer, int offset2) {
                return UnsafeAccess.toInt(buffer, offset2);
            }

            @Override
            long toLong(ByteBuffer buffer, int offset2) {
                return UnsafeAccess.toLong(buffer, offset2);
            }

            @Override
            void putInt(ByteBuffer buffer, int val) {
                int newPos = UnsafeAccess.putInt(buffer, buffer.position(), val);
                buffer.position(newPos);
            }

            @Override
            int putInt(ByteBuffer buffer, int index2, int val) {
                return UnsafeAccess.putInt(buffer, index2, val);
            }

            @Override
            void putShort(ByteBuffer buffer, short val) {
                int newPos = UnsafeAccess.putShort(buffer, buffer.position(), val);
                buffer.position(newPos);
            }

            @Override
            int putShort(ByteBuffer buffer, int index2, short val) {
                return UnsafeAccess.putShort(buffer, index2, val);
            }

            @Override
            void putLong(ByteBuffer buffer, long val) {
                int newPos = UnsafeAccess.putLong(buffer, buffer.position(), val);
                buffer.position(newPos);
            }

            @Override
            int putLong(ByteBuffer buffer, int index2, long val) {
                return UnsafeAccess.putLong(buffer, index2, val);
            }

            static {
                if (!UNSAFE_UNALIGNED) {
                    throw new Error();
                }
            }
        }

        static final class PureJavaConverter
        extends Converter {
            static final PureJavaConverter INSTANCE = new PureJavaConverter();

            private PureJavaConverter() {
            }

            @Override
            short toShort(ByteBuffer buffer, int offset2) {
                return buffer.getShort(offset2);
            }

            @Override
            int toInt(ByteBuffer buffer) {
                return buffer.getInt();
            }

            @Override
            int toInt(ByteBuffer buffer, int offset2) {
                return buffer.getInt(offset2);
            }

            @Override
            long toLong(ByteBuffer buffer, int offset2) {
                return buffer.getLong(offset2);
            }

            @Override
            void putInt(ByteBuffer buffer, int val) {
                buffer.putInt(val);
            }

            @Override
            int putInt(ByteBuffer buffer, int index2, int val) {
                buffer.putInt(index2, val);
                return index2 + 4;
            }

            @Override
            void putShort(ByteBuffer buffer, short val) {
                buffer.putShort(val);
            }

            @Override
            int putShort(ByteBuffer buffer, int index2, short val) {
                buffer.putShort(index2, val);
                return index2 + 2;
            }

            @Override
            void putLong(ByteBuffer buffer, long val) {
                buffer.putLong(val);
            }

            @Override
            int putLong(ByteBuffer buffer, int index2, long val) {
                buffer.putLong(index2, val);
                return index2 + 8;
            }
        }
    }

    static class ComparerHolder {
        static final String UNSAFE_COMPARER_NAME = ComparerHolder.class.getName() + "$UnsafeComparer";
        static final Comparer BEST_COMPARER = ComparerHolder.getBestComparer();

        ComparerHolder() {
        }

        static Comparer getBestComparer() {
            try {
                Class<?> theClass = Class.forName(UNSAFE_COMPARER_NAME);
                Comparer comparer = (Comparer)theClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                return comparer;
            }
            catch (Throwable t) {
                return PureJavaComparer.INSTANCE;
            }
        }

        static final class UnsafeComparer
        extends Comparer {
            @Override
            public int compareTo(byte[] buf1, int o1, int l1, ByteBuffer buf2, int o2, int l2) {
                long offset2Adj;
                byte[] refObj2 = null;
                if (buf2.isDirect()) {
                    offset2Adj = (long)o2 + ((DirectBuffer)((Object)buf2)).address();
                } else {
                    offset2Adj = (long)(o2 + buf2.arrayOffset()) + UnsafeAccess.BYTE_ARRAY_BASE_OFFSET;
                    refObj2 = buf2.array();
                }
                return ByteBufferUtils.compareToUnsafe(buf1, (long)o1 + UnsafeAccess.BYTE_ARRAY_BASE_OFFSET, l1, refObj2, offset2Adj, l2);
            }

            @Override
            public int compareTo(ByteBuffer buf1, int o1, int l1, ByteBuffer buf2, int o2, int l2) {
                long offset2Adj;
                long offset1Adj;
                byte[] refObj1 = null;
                byte[] refObj2 = null;
                if (buf1.isDirect()) {
                    offset1Adj = (long)o1 + ((DirectBuffer)((Object)buf1)).address();
                } else {
                    offset1Adj = (long)(o1 + buf1.arrayOffset()) + UnsafeAccess.BYTE_ARRAY_BASE_OFFSET;
                    refObj1 = buf1.array();
                }
                if (buf2.isDirect()) {
                    offset2Adj = (long)o2 + ((DirectBuffer)((Object)buf2)).address();
                } else {
                    offset2Adj = (long)(o2 + buf2.arrayOffset()) + UnsafeAccess.BYTE_ARRAY_BASE_OFFSET;
                    refObj2 = buf2.array();
                }
                return ByteBufferUtils.compareToUnsafe(refObj1, offset1Adj, l1, refObj2, offset2Adj, l2);
            }

            static {
                if (!UNSAFE_UNALIGNED) {
                    throw new Error();
                }
            }
        }

        static final class PureJavaComparer
        extends Comparer {
            static final PureJavaComparer INSTANCE = new PureJavaComparer();

            private PureJavaComparer() {
            }

            @Override
            public int compareTo(byte[] buf1, int o1, int l1, ByteBuffer buf2, int o2, int l2) {
                int end1 = o1 + l1;
                int end2 = o2 + l2;
                int i2 = o1;
                for (int j = o2; i2 < end1 && j < end2; ++i2, ++j) {
                    int a = buf1[i2] & 0xFF;
                    int b = buf2.get(j) & 0xFF;
                    if (a == b) continue;
                    return a - b;
                }
                return l1 - l2;
            }

            @Override
            public int compareTo(ByteBuffer buf1, int o1, int l1, ByteBuffer buf2, int o2, int l2) {
                int end1 = o1 + l1;
                int end2 = o2 + l2;
                int i2 = o1;
                for (int j = o2; i2 < end1 && j < end2; ++i2, ++j) {
                    int b;
                    int a = buf1.get(i2) & 0xFF;
                    if (a == (b = buf2.get(j) & 0xFF)) continue;
                    return a - b;
                }
                return l1 - l2;
            }
        }
    }

    static abstract class Converter {
        Converter() {
        }

        abstract short toShort(ByteBuffer var1, int var2);

        abstract int toInt(ByteBuffer var1);

        abstract int toInt(ByteBuffer var1, int var2);

        abstract long toLong(ByteBuffer var1, int var2);

        abstract void putInt(ByteBuffer var1, int var2);

        abstract int putInt(ByteBuffer var1, int var2, int var3);

        abstract void putShort(ByteBuffer var1, short var2);

        abstract int putShort(ByteBuffer var1, int var2, short var3);

        abstract void putLong(ByteBuffer var1, long var2);

        abstract int putLong(ByteBuffer var1, int var2, long var3);
    }

    static abstract class Comparer {
        Comparer() {
        }

        abstract int compareTo(byte[] var1, int var2, int var3, ByteBuffer var4, int var5, int var6);

        abstract int compareTo(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6);
    }
}

