/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.util.WindowMovingAverage;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class WeightedMovingAverage
extends WindowMovingAverage {
    private int[] coefficient;
    private int denominator;

    public WeightedMovingAverage(String label) {
        this(label, 5);
    }

    public WeightedMovingAverage(String label, int size2) {
        super(label, size2);
        int length2 = this.getNumberOfStatistics();
        this.denominator = length2 * (length2 + 1) / 2;
        this.coefficient = new int[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            this.coefficient[i2] = i2 + 1;
        }
    }

    @Override
    public double getAverageTime() {
        if (!this.enoughStatistics()) {
            return super.getAverageTime();
        }
        double average = 0.0;
        int coIndex = 0;
        int length2 = this.getNumberOfStatistics();
        int tmIndex = (this.getMostRecentPosistion() + 1) % length2;
        while (coIndex < length2) {
            average += (double)((long)this.coefficient[coIndex] * this.getStatisticsAtIndex(tmIndex));
            ++coIndex;
            ++tmIndex;
            tmIndex %= length2;
        }
        return average / (double)this.denominator;
    }
}

