/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.apache.hadoop.metrics2.util.MetricQuantile;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricSampleQuantiles {
    private long count = 0L;
    private LinkedList<SampleItem> samples;
    private long[] buffer = new long[500];
    private int bufferCount = 0;
    private final MetricQuantile[] quantiles;

    public MetricSampleQuantiles(MetricQuantile[] quantiles) {
        this.quantiles = Arrays.copyOf(quantiles, quantiles.length);
        this.samples = new LinkedList();
    }

    private double allowableError(int rank) {
        int size2 = this.samples.size();
        double minError = size2 + 1;
        for (MetricQuantile q : this.quantiles) {
            double error2 = (double)rank <= q.quantile * (double)size2 ? 2.0 * q.error * (double)(size2 - rank) / (1.0 - q.quantile) : 2.0 * q.error * (double)rank / q.quantile;
            if (!(error2 < minError)) continue;
            minError = error2;
        }
        return minError;
    }

    public synchronized void insert(long v) {
        this.buffer[this.bufferCount] = v;
        ++this.bufferCount;
        ++this.count;
        if (this.bufferCount == this.buffer.length) {
            this.insertBatch();
            this.compress();
        }
    }

    private void insertBatch() {
        if (this.bufferCount == 0) {
            return;
        }
        Arrays.sort(this.buffer, 0, this.bufferCount);
        int start2 = 0;
        if (this.samples.isEmpty()) {
            SampleItem newItem = new SampleItem(this.buffer[0], 1, 0);
            this.samples.add(newItem);
            ++start2;
        }
        ListIterator<SampleItem> it = this.samples.listIterator();
        SampleItem item = (SampleItem)it.next();
        for (int i2 = start2; i2 < this.bufferCount; ++i2) {
            long v = this.buffer[i2];
            while (it.nextIndex() < this.samples.size() && item.value < v) {
                item = (SampleItem)it.next();
            }
            if (item.value > v) {
                it.previous();
            }
            int delta = it.previousIndex() == 0 || it.nextIndex() == this.samples.size() ? 0 : (int)Math.floor(this.allowableError(it.nextIndex())) - 1;
            SampleItem newItem = new SampleItem(v, 1, delta);
            it.add(newItem);
            item = newItem;
        }
        this.bufferCount = 0;
    }

    private void compress() {
        if (this.samples.size() < 2) {
            return;
        }
        ListIterator it = this.samples.listIterator();
        SampleItem prev = null;
        SampleItem next2 = (SampleItem)it.next();
        while (it.hasNext()) {
            prev = next2;
            next2 = (SampleItem)it.next();
            if (!((double)(prev.g + next2.g + next2.delta) <= this.allowableError(it.previousIndex()))) continue;
            SampleItem sampleItem = next2;
            sampleItem.g = sampleItem.g + prev.g;
            it.previous();
            it.previous();
            it.remove();
            it.next();
        }
    }

    private long query(double quantile) throws IOException {
        if (this.samples.isEmpty()) {
            throw new IOException("No samples present");
        }
        int rankMin = 0;
        int desired = (int)(quantile * (double)this.count);
        for (int i2 = 1; i2 < this.samples.size(); ++i2) {
            SampleItem prev = this.samples.get(i2 - 1);
            SampleItem cur = this.samples.get(i2);
            if (!((double)((rankMin += prev.g) + cur.g + cur.delta) > (double)desired + this.allowableError(i2) / 2.0)) continue;
            return prev.value;
        }
        return this.samples.get(this.samples.size() - 1).value;
    }

    public synchronized Map<MetricQuantile, Long> snapshot() throws IOException {
        this.insertBatch();
        HashMap<MetricQuantile, Long> values = new HashMap<MetricQuantile, Long>(this.quantiles.length);
        for (int i2 = 0; i2 < this.quantiles.length; ++i2) {
            values.put(this.quantiles[i2], this.query(this.quantiles[i2].quantile));
        }
        return values;
    }

    public synchronized long getCount() {
        return this.count;
    }

    public synchronized int getSampleCount() {
        return this.samples.size();
    }

    public synchronized void clear() {
        this.count = 0L;
        this.bufferCount = 0;
        this.samples.clear();
    }

    private static class SampleItem {
        private final long value;
        private int g;
        private final int delta;

        public SampleItem(long value2, int lowerDelta, int delta) {
            this.value = value2;
            this.g = lowerDelta;
            this.delta = delta;
        }

        public String toString() {
            return String.format("%d, %d, %d", this.value, this.g, this.delta);
        }
    }
}

